/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.function;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.extension.mockito.function.ReadXmlDocumentFromResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum ParseDelegateExpressions implements Function<URL, Set<String>>
{
    EXECUTION_LISTENER,
    TASK_LISTENER,
    JAVA_DELEGATE;

    private static final Map<URL, Map<ParseDelegateExpressions, Set<String>>> cache;
    @VisibleForTesting
    static final String PATTERN_DELEGATE_EXPRESSION = "[#$]\\{([^}]+)}";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ReadXmlDocumentFromResource readXmlDocumentFromResource = ReadXmlDocumentFromResource.INSTANCE;

    public Set<String> apply(URL bpmnResource) {
        if (!cache.containsKey(bpmnResource)) {
            Map<ParseDelegateExpressions, Set<String>> result = ParseDelegateExpressions.initEmptyMap(bpmnResource);
            Element root = this.readXmlDocumentFromResource.apply(bpmnResource).getDocumentElement();
            result.get((Object)EXECUTION_LISTENER).addAll(this.parseExpressions(root.getElementsByTagName("camunda:executionListener")));
            result.get((Object)TASK_LISTENER).addAll(this.parseExpressions(root.getElementsByTagName("camunda:taskListener")));
            result.get((Object)JAVA_DELEGATE).addAll(this.parseExpressions(root.getElementsByTagName("bpmn2:serviceTask")));
        }
        return cache.get(bpmnResource).get((Object)this);
    }

    private static Map<ParseDelegateExpressions, Set<String>> initEmptyMap(URL bpmnResource) {
        HashMap<ParseDelegateExpressions, Set<String>> map = new HashMap<ParseDelegateExpressions, Set<String>>(){
            {
                this.put(EXECUTION_LISTENER, new HashSet());
                this.put(JAVA_DELEGATE, new HashSet());
                this.put(TASK_LISTENER, new HashSet());
            }
        };
        cache.put(bpmnResource, (Map<ParseDelegateExpressions, Set<String>>)map);
        return map;
    }

    private Set<String> parseExpressions(NodeList nodeList) {
        HashSet expressions = Sets.newHashSet();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap attributes = nodeList.item(i).getAttributes();
            Node delegateExpression = attributes.getNamedItem("delegateExpression");
            if (delegateExpression == null) {
                delegateExpression = attributes.getNamedItem("camunda:delegateExpression");
            }
            if (delegateExpression == null) continue;
            expressions.add(ParseDelegateExpressions.extractDelegateExpressionName(delegateExpression.getTextContent()));
        }
        return expressions;
    }

    public static String extractDelegateExpressionName(String delegateExpression) {
        return StringUtils.isNotBlank((CharSequence)delegateExpression) ? delegateExpression.replaceAll(PATTERN_DELEGATE_EXPRESSION, "$1") : null;
    }

    static {
        cache = new HashMap<URL, Map<ParseDelegateExpressions, Set<String>>>();
    }
}

