/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.mockito.mock;

import java.util.Map;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.extension.util.ProcessVariableMaps;
import org.mockito.Mockito;

abstract class FluentMock<T, P extends VariableScope> {
    protected final T mock;
    protected final Class<P> parameterType;

    protected FluentMock(T mock, Class<P> parameterType) {
        this.mock = mock;
        this.parameterType = parameterType;
    }

    protected void setVariables(VariableScope variableScope, Map<String, Object> variables) {
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            variableScope.setVariable(variable.getKey(), variable.getValue());
        }
    }

    public final void onExecutionSetVariables(Object ... keyValuePairs) {
        this.onExecutionSetVariables(ProcessVariableMaps.parseMap(keyValuePairs));
    }

    public abstract void onExecutionSetVariables(Map<String, Object> var1);

    public void onExecutionThrowBpmnError(String errorCode) {
        this.onExecutionThrowBpmnError(new BpmnError(errorCode));
    }

    public void onExecutionThrowBpmnError(String errorCode, String message) {
        this.onExecutionThrowBpmnError(new BpmnError(errorCode, message));
    }

    public abstract void onExecutionThrowBpmnError(BpmnError var1);

    public T getMock() {
        return this.mock;
    }

    protected P any() {
        return (P)((VariableScope)Mockito.any(this.parameterType));
    }
}

