/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.identity.impl.ldap.plugin;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.identity.impl.ldap.LdapConfiguration;
import org.camunda.bpm.identity.impl.ldap.LdapIdentityProviderFactory;
import org.camunda.bpm.identity.impl.ldap.util.CertificateHelper;
import org.camunda.bpm.identity.impl.ldap.util.LdapPluginLogger;

public class LdapIdentityProviderPlugin
extends LdapConfiguration
implements ProcessEnginePlugin {
    protected boolean acceptUntrustedCertificates = false;

    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        LdapPluginLogger.INSTANCE.pluginActivated(this.getClass().getSimpleName(), processEngineConfiguration.getProcessEngineName());
        if (this.acceptUntrustedCertificates) {
            CertificateHelper.acceptUntrusted();
            LdapPluginLogger.INSTANCE.acceptingUntrustedCertificates();
        }
        LdapIdentityProviderFactory ldapIdentityProviderFactory = new LdapIdentityProviderFactory();
        ldapIdentityProviderFactory.setLdapConfiguration(this);
        processEngineConfiguration.setIdentityProviderSessionFactory((SessionFactory)ldapIdentityProviderFactory);
    }

    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
    }

    public void postProcessEngineBuild(ProcessEngine processEngine) {
    }

    public void setAcceptUntrustedCertificates(boolean acceptUntrustedCertificates) {
        this.acceptUntrustedCertificates = acceptUntrustedCertificates;
    }

    public boolean isAcceptUntrustedCertificates() {
        return this.acceptUntrustedCertificates;
    }
}

