/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.identity.impl.ldap.util;

import javax.naming.directory.SearchResult;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.commons.logging.BaseLogger;

public class LdapPluginLogger
extends BaseLogger {
    public static final String PROJECT_CODE = "LDAP";
    public static final LdapPluginLogger INSTANCE = (LdapPluginLogger)BaseLogger.createLogger(LdapPluginLogger.class, (String)"LDAP", (String)"org.camunda.bpm.identity.impl.ldap", (String)"00");

    public void pluginActivated(String pluginClassName, String engineName) {
        this.logInfo("001", "PLUGIN {} activated on process engine {}", new Object[]{pluginClassName, engineName});
    }

    public void acceptingUntrustedCertificates() {
        this.logWarn("002", "Enabling accept of untrusted certificates. Use at own risk.", new Object[0]);
    }

    public void exceptionWhenClosingLdapCOntext(Exception e) {
        this.logDebug("003", "exception while closing LDAP DIR CTX", new Object[]{e});
    }

    public void invalidLdapGroupReturned(GroupEntity group, SearchResult searchResult) {
        this.logError("004", "LDAP group query returned a group with id null. This group will be ignored. This indicates a misconfiguration of the LDAP plugin or a problem with the LDAP service. Enable DEBUG/FINE logging for details.", new Object[0]);
        this.logDebug("004", "Invalid group: {} based on search result {}", new Object[]{group, searchResult});
    }

    public void invalidLdapUserReturned(UserEntity user, SearchResult searchResult) {
        this.logError("004", "LDAP user query returned a user with id null. This user will be ignored. This indicates a misconfiguration of the LDAP plugin or a problem with the LDAP service. Enable DEBUG/FINE logging for details.", new Object[0]);
        this.logDebug("004", "Invalid user: {} based on search result {}", new Object[]{user, searchResult});
    }

    public void groupQueryResult(String summary) {
        this.logDebug("005", summary, new Object[0]);
    }

    public void userQueryResult(String summary) {
        this.logDebug("006", summary, new Object[0]);
    }
}

