/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.AttributeMetadata;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.attribute.BindableMetadata;
import org.carrot2.util.attribute.BindableUtils;
import org.carrot2.util.attribute.constraint.IsConstraint;

public class BindableDescriptorBuilder {
    public static BindableDescriptor buildDescriptor(Object initializedInstance) {
        return BindableDescriptorBuilder.buildDescriptor(initializedInstance, new HashSet<Object>());
    }

    private static BindableDescriptor buildDescriptor(Object initializedInstance, Set<Object> processedInstances) {
        Class<?> clazz = initializedInstance.getClass();
        if (clazz.getAnnotation(Bindable.class) == null) {
            throw new IllegalArgumentException("Provided instance must be @Bindable");
        }
        if (!processedInstances.add(initializedInstance)) {
            throw new UnsupportedOperationException("Circular references are not supported");
        }
        BindableMetadata bindableMetadata = BindableMetadata.forClassWithParents(clazz);
        Map<String, AttributeDescriptor> attributeDescriptors = BindableDescriptorBuilder.buildAttributeDescriptors(initializedInstance, bindableMetadata);
        LinkedHashMap bindableDescriptors = Maps.newLinkedHashMap();
        Collection<Field> fieldsFromBindableHierarchy = BindableUtils.getFieldsFromBindableHierarchy(clazz);
        for (Field field : fieldsFromBindableHierarchy) {
            Object fieldValue = null;
            try {
                field.setAccessible(true);
                fieldValue = field.get(initializedInstance);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve default value of field: " + field.getClass().getName() + "#" + field.getName());
            }
            if (fieldValue == null || fieldValue.getClass().getAnnotation(Bindable.class) == null) continue;
            bindableDescriptors.put(field, BindableDescriptorBuilder.buildDescriptor(fieldValue, processedInstances));
        }
        return new BindableDescriptor(clazz, bindableMetadata, bindableDescriptors, attributeDescriptors);
    }

    private static Map<String, AttributeDescriptor> buildAttributeDescriptors(Object initializedInstance, BindableMetadata bindableMetadata) {
        Class<?> clazz = initializedInstance.getClass();
        LinkedHashMap result = Maps.newLinkedHashMap();
        Collection<Field> fieldsFromBindableHierarchy = BindableUtils.getFieldsFromBindableHierarchy(clazz);
        for (Field field : fieldsFromBindableHierarchy) {
            if (field.getAnnotation(Attribute.class) == null) continue;
            result.put(BindableUtils.getKey(field), BindableDescriptorBuilder.buildAttributeDescriptor(initializedInstance, field, bindableMetadata));
        }
        return result;
    }

    private static AttributeDescriptor buildAttributeDescriptor(Object initializedInstance, Field field, BindableMetadata bindableMetadata) {
        Object defaultValue = null;
        try {
            field.setAccessible(true);
            defaultValue = field.get(initializedInstance);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve default value of attribute: " + BindableUtils.getKey(field));
        }
        AttributeMetadata attributeMetadata = null;
        if (bindableMetadata != null) {
            attributeMetadata = bindableMetadata.getAttributeMetadata().get(field.getName());
        }
        return new AttributeDescriptor(field, defaultValue, BindableDescriptorBuilder.getConstraintAnnotations(field), attributeMetadata);
    }

    private static List<Annotation> getConstraintAnnotations(Field field) {
        Annotation[] annotations = field.getAnnotations();
        ArrayList constraintAnnotations = Lists.newArrayList();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(IsConstraint.class)) continue;
            constraintAnnotations.add(annotation);
        }
        return constraintAnnotations;
    }
}

