/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.Usable;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Abstract supertype of resources which may be obtained at\nthe beginning of a `try` statement and then released when \nthe statement completes. Unlike a [[Destroyable]] resource, \na single instance of `Obtainable` may be reused between \nmultiple `try` statements or multiple executions of the \nsame `try` statement.\n\n    Lock lock = ... ;\n    try (lock) {\n        ...\n    }\n\n- [[obtain]] is called before the body of the `try` \n  statement is executed, and\n- [[release]] is called when execution of the body of the \n  `try` statement ends, even if an exception propagates out \n  of the body of the `try`.\n\nA class which satisfies `Obtainable` may impose constraints \non the ordering and nesting of invocations of `obtain()` \nand `release()`. For example, it may be not be possible to\nobtain a resource that has already been obtained. Those \nmethods should produce an [[AssertionError]] when any such \nconstraint is violated.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::IDestroyable"})})
@TagsAnnotation$annotation$(tags={"Basic types"})
@SinceAnnotation$annotation$(version="1.1.0")
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstract supertype of resources which may be obtained at\nthe beginning of a `try` statement and then released when \nthe statement completes. Unlike a [[Destroyable]] resource, \na single instance of `Obtainable` may be reused between \nmultiple `try` statements or multiple executions of the \nsame `try` statement.\n\n    Lock lock = ... ;\n    try (lock) {\n        ...\n    }\n\n- [[obtain]] is called before the body of the `try` \n  statement is executed, and\n- [[release]] is called when execution of the body of the \n  `try` statement ends, even if an exception propagates out \n  of the body of the `try`.\n\nA class which satisfies `Obtainable` may impose constraints \non the ordering and nesting of invocations of `obtain()` \nand `release()`. For example, it may be not be possible to\nobtain a resource that has already been obtained. Those \nmethods should produce an [[AssertionError]] when any such \nconstraint is violated."}), @Annotation(value="see", arguments={"Destroyable"}), @Annotation(value="tagged", arguments={"Basic types"})})
@SatisfiedTypes(value={"ceylon.language::Usable"})
public interface Obtainable
extends Usable {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Obtainable.class, new TypeDescriptor[0]);

    @DocAnnotation$annotation$(description="Obtain this resource. Called before the body of a `try` \nstatement is executed.\n\nIf an exception is thrown by `obtain()`, then `release()` \nwill not be called.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if an illegal state is detected")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Obtain this resource. Called before the body of a `try` \nstatement is executed.\n\nIf an exception is thrown by `obtain()`, then `release()` \nwill not be called."}), @Annotation(value="throws", arguments={"AssertionError", "if an illegal state is detected"})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object obtain();

    @DocAnnotation$annotation$(description="Release this resource. Called when execution of the \nbody of a `try` statement ends, even if an exception \npropagates out of the body of the `try`.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if an illegal state is detected")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Release this resource. Called when execution of the \nbody of a `try` statement ends, even if an exception \npropagates out of the body of the `try`."}), @Annotation(value="throws", arguments={"AssertionError", "if an illegal state is detected"})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object release(@Name(value="error") @TypeInfo(value="ceylon.language::Throwable?") @DocAnnotation$annotation$(description="The exception propagating out of the body of the \n`try` statement, or `null` if no exception was\npropagated.") @Annotations(value={@Annotation(value="doc", arguments={"The exception propagating out of the body of the \n`try` statement, or `null` if no exception was\npropagated."})}) @Nullable Throwable var1);
}

