/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.List;
import ceylon.language.SearchableList$impl;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.VariableAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[List]] which can be efficiently searched for \noccurrences of a given element, or for inclusions of a \ngiven sublist of elements. This interface provides \noperations for finding:\n\n- _occurrences_ of a single value in the list, and\n- _inclusions_ of a given sublist of values in the list.\n\nOccurrences and inclusions are identified by a list index\nat which the value or sublist of values occurs in the list. \nIn the case of an inclusion, it is the index of the first \nmatching value from the sublist.\n\nInclusions may overlap. For example:\n\n    \"yoyoyoyoyo\".inclusions(\"yoy\")\n\nproduces the stream `{ 0, 2, 4, 6 }`.\n\nAn empty list is considered to be included at every index,\nincluding the index [[size]] at the very end of the \nlist. Thus:\n\n    \"hello\".inclusions(\"\")\n\nproduces the stream `{ 0, 1, 2, 3, 4, 5 }`, with 6 \ninclusions in a string of length 5. \n\nIn particular:\n\n- `\"\".inclusions(\"x\")` is the empty stream `{}`, but\n- `\"\".inclusions(\"\")` is the stream `{ 0 }`.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::CString", "::1.3.2:ceylon.language::CArray"})})
@SinceAnnotation$annotation$(version="1.2.0")
@SharedAnnotation$annotation$
@LocalDeclarations(value={"1anonymous_0_", "1anonymous_2_"})
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"A [[List]] which can be efficiently searched for \noccurrences of a given element, or for inclusions of a \ngiven sublist of elements. This interface provides \noperations for finding:\n\n- _occurrences_ of a single value in the list, and\n- _inclusions_ of a given sublist of values in the list.\n\nOccurrences and inclusions are identified by a list index\nat which the value or sublist of values occurs in the list. \nIn the case of an inclusion, it is the index of the first \nmatching value from the sublist.\n\nInclusions may overlap. For example:\n\n    \"yoyoyoyoyo\".inclusions(\"yoy\")\n\nproduces the stream `{ 0, 2, 4, 6 }`.\n\nAn empty list is considered to be included at every index,\nincluding the index [[size]] at the very end of the \nlist. Thus:\n\n    \"hello\".inclusions(\"\")\n\nproduces the stream `{ 0, 1, 2, 3, 4, 5 }`, with 6 \ninclusions in a string of length 5. \n\nIn particular:\n\n- `\"\".inclusions(\"x\")` is the empty stream `{}`, but\n- `\"\".inclusions(\"\")` is the stream `{ 0 }`."}), @Annotation(value="see", arguments={"String", "Array"})})
@SatisfiedTypes(value={"ceylon.language::List<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={}, caseTypes={})})
public interface SearchableList<Element>
extends List<Element> {
    @Ignore
    public SearchableList$impl<Element> $ceylon$language$SearchableList$impl();

    @DocAnnotation$annotation$(description="Determines if the given [[value|element]] occurs at the \ngiven index in this list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if the given [[value|element]] occurs at the \ngiven index in this list."})})
    public boolean occursAt(@Name(value="index") @DocAnnotation$annotation$(description="The index at which the value might occur.") @Annotations(value={@Annotation(value="doc", arguments={"The index at which the value might occur."})}) long var1, @Name(value="element") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The value. If null, it is considered to occur\nat any index in this list with a null element.") @Annotations(value={@Annotation(value="doc", arguments={"The value. If null, it is considered to occur\nat any index in this list with a null element."})}) Element var3);

    @Ignore
    public Iterable<? extends Integer, ? extends Object> occurrences(Element var1);

    @Ignore
    public long occurrences$from(Element var1);

    @Ignore
    public Iterable<? extends Integer, ? extends Object> occurrences(Element var1, long var2);

    @Ignore
    public long occurrences$length(Element var1, long var2);

    @DocAnnotation$annotation$(description="The indexes in this list at which the given \n[[value|element]] occurs.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The indexes in this list at which the given \n[[value|element]] occurs."})})
    @TypeInfo(value="{ceylon.language::Integer*}")
    @NonNull
    public Iterable<? extends Integer, ? extends Object> occurrences(@Name(value="element") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The value. If null, it is considered to occur\nat any index in this list with a null element.") @Annotations(value={@Annotation(value="doc", arguments={"The value. If null, it is considered to occur\nat any index in this list with a null element."})}) Element var1, @Name(value="from") @Defaulted @DocAnnotation$annotation$(description="The smallest index to consider.") @Annotations(value={@Annotation(value="doc", arguments={"The smallest index to consider."})}) long var2, @Name(value="length") @Defaulted @DocAnnotation$annotation$(description="The number of indexes to consider.") @Annotations(value={@Annotation(value="doc", arguments={"The number of indexes to consider."})}) long var4);

    @Ignore
    public boolean occurs(Element var1);

    @Ignore
    public long occurs$from(Element var1);

    @Ignore
    public boolean occurs(Element var1, long var2);

    @Ignore
    public long occurs$length(Element var1, long var2);

    @DocAnnotation$annotation$(description="Determines if the given [[value|element]] occurs as an \nelement of this list, at any index that falls within\nthe segment `from:length` defined by the optional \n[[starting index|from]] and [[length]].")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determines if the given [[value|element]] occurs as an \nelement of this list, at any index that falls within\nthe segment `from:length` defined by the optional \n[[starting index|from]] and [[length]]."})})
    public boolean occurs(@Name(value="element") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The value. If null, it is considered to occur\nat any index in this list with a null element.") @Annotations(value={@Annotation(value="doc", arguments={"The value. If null, it is considered to occur\nat any index in this list with a null element."})}) Element var1, @Name(value="from") @Defaulted @DocAnnotation$annotation$(description="The smallest index to consider.") @Annotations(value={@Annotation(value="doc", arguments={"The smallest index to consider."})}) long var2, @Name(value="length") @Defaulted @DocAnnotation$annotation$(description="The number of indexes to consider.") @Annotations(value={@Annotation(value="doc", arguments={"The number of indexes to consider."})}) long var4);

    @Ignore
    public Integer firstOccurrence(Element var1);

    @Ignore
    public long firstOccurrence$from(Element var1);

    @Ignore
    public Integer firstOccurrence(Element var1, long var2);

    @Ignore
    public long firstOccurrence$length(Element var1, long var2);

    @DocAnnotation$annotation$(description="The first index in this list at which the given \n[[value|element]] occurs, that falls within the segment \n`from:length` defined by the optional \n[[starting index|from]] and [[length]].")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The first index in this list at which the given \n[[value|element]] occurs, that falls within the segment \n`from:length` defined by the optional \n[[starting index|from]] and [[length]]."})})
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public Integer firstOccurrence(@Name(value="element") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The value. If null, it is considered to occur\nat any index in this list with a null element.") @Annotations(value={@Annotation(value="doc", arguments={"The value. If null, it is considered to occur\nat any index in this list with a null element."})}) Element var1, @Name(value="from") @Defaulted @DocAnnotation$annotation$(description="The smallest index to consider.") @VariableAnnotation$annotation$ @Annotations(modifiers=4L, value={@Annotation(value="doc", arguments={"The smallest index to consider."})}) long var2, @Name(value="length") @Defaulted @DocAnnotation$annotation$(description="The number of indexes to consider.") @VariableAnnotation$annotation$ @Annotations(modifiers=4L, value={@Annotation(value="doc", arguments={"The number of indexes to consider."})}) long var4);

    @Ignore
    public Integer lastOccurrence(Element var1);

    @Ignore
    public long lastOccurrence$from(Element var1);

    @Ignore
    public Integer lastOccurrence(Element var1, long var2);

    @Ignore
    public long lastOccurrence$length(Element var1, long var2);

    @DocAnnotation$annotation$(description="The last index in this list at which the given \n[[value|element]] occurs, that falls within the range \n`size-length-from:length` defined by the optional \n[[starting index|from]], interpreted as a reverse index \ncounting from the _end_ of the list, and [[length]].")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The last index in this list at which the given \n[[value|element]] occurs, that falls within the range \n`size-length-from:length` defined by the optional \n[[starting index|from]], interpreted as a reverse index \ncounting from the _end_ of the list, and [[length]]."})})
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public Integer lastOccurrence(@Name(value="element") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The value. If null, it is considered to occur\nat any index in this list with a null element.") @Annotations(value={@Annotation(value="doc", arguments={"The value. If null, it is considered to occur\nat any index in this list with a null element."})}) Element var1, @Name(value="from") @Defaulted @DocAnnotation$annotation$(description="The smallest index to consider, interpreted as\na reverse index counting from the _end_ of the \nlist, where `0` is the last element of the list, \nand `size-1` is the first element of the list.") @VariableAnnotation$annotation$ @Annotations(modifiers=4L, value={@Annotation(value="doc", arguments={"The smallest index to consider, interpreted as\na reverse index counting from the _end_ of the \nlist, where `0` is the last element of the list, \nand `size-1` is the first element of the list."})}) long var2, @Name(value="length") @Defaulted @DocAnnotation$annotation$(description="The number of indexes to consider.") @VariableAnnotation$annotation$ @Annotations(modifiers=4L, value={@Annotation(value="doc", arguments={"The number of indexes to consider."})}) long var4);

    @DocAnnotation$annotation$(description="Determine if the given [[list|sublist]] occurs as a \nsublist at the given index of this list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determine if the given [[list|sublist]] occurs as a \nsublist at the given index of this list."})})
    public boolean includesAt(@Name(value="index") @DocAnnotation$annotation$(description="The index at which the [[sublist]] might occur.") @Annotations(value={@Annotation(value="doc", arguments={"The index at which the [[sublist]] might occur."})}) long var1, @Name(value="sublist") @TypeInfo(value="ceylon.language::List<Element>") @NonNull List<? extends Element> var3);

    @Ignore
    public Iterable<? extends Integer, ? extends Object> inclusions(List<? extends Element> var1);

    @Ignore
    public long inclusions$from(List<? extends Element> var1);

    @DocAnnotation$annotation$(description="The indexes in this list at which the given \n[[list|sublist]] occurs as a sublist, that are greater \nthan or equal to the optional [[starting index|from]].")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The indexes in this list at which the given \n[[list|sublist]] occurs as a sublist, that are greater \nthan or equal to the optional [[starting index|from]]."})})
    @TypeInfo(value="{ceylon.language::Integer*}")
    @NonNull
    public Iterable<? extends Integer, ? extends Object> inclusions(@Name(value="sublist") @TypeInfo(value="ceylon.language::List<Element>") @NonNull List<? extends Element> var1, @Name(value="from") @Defaulted @DocAnnotation$annotation$(description="The smallest index to consider.") @Annotations(value={@Annotation(value="doc", arguments={"The smallest index to consider."})}) long var2);

    @Ignore
    public boolean includes(List<? extends Element> var1);

    @Ignore
    public long includes$from(List<? extends Element> var1);

    @DocAnnotation$annotation$(description="Determine if the given [[list|sublist]] occurs as a \nsublist at some index in this list, at any index that \nis greater than or equal to the optional \n[[starting index|from]].")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Determine if the given [[list|sublist]] occurs as a \nsublist at some index in this list, at any index that \nis greater than or equal to the optional \n[[starting index|from]]."})})
    public boolean includes(@Name(value="sublist") @TypeInfo(value="ceylon.language::List<Element>") @NonNull List<? extends Element> var1, @Name(value="from") @Defaulted @DocAnnotation$annotation$(description="The smallest index to consider.") @Annotations(value={@Annotation(value="doc", arguments={"The smallest index to consider."})}) long var2);

    @Ignore
    public Integer firstInclusion(List<? extends Element> var1);

    @Ignore
    public long firstInclusion$from(List<? extends Element> var1);

    @DocAnnotation$annotation$(description="The first index in this list at which the given \n[[list|sublist]] occurs as a sublist, that is greater \nthan or equal to the optional [[starting index|from]].")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The first index in this list at which the given \n[[list|sublist]] occurs as a sublist, that is greater \nthan or equal to the optional [[starting index|from]]."})})
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public Integer firstInclusion(@Name(value="sublist") @TypeInfo(value="ceylon.language::List<Element>") @NonNull List<? extends Element> var1, @Name(value="from") @Defaulted @DocAnnotation$annotation$(description="The smallest index to consider.") @Annotations(value={@Annotation(value="doc", arguments={"The smallest index to consider."})}) long var2);

    @Ignore
    public Integer lastInclusion(List<? extends Element> var1);

    @Ignore
    public long lastInclusion$from(List<? extends Element> var1);

    @DocAnnotation$annotation$(description="The last index in this list at which the given \n[[list|sublist]] occurs as a sublist, that falls within \nthe range `0:size-from+1-sublist.size` defined by the \noptional [[starting index|from]], interpreted as a \nreverse index counting from the _end_ of the list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The last index in this list at which the given \n[[list|sublist]] occurs as a sublist, that falls within \nthe range `0:size-from+1-sublist.size` defined by the \noptional [[starting index|from]], interpreted as a \nreverse index counting from the _end_ of the list."})})
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public Integer lastInclusion(@Name(value="sublist") @TypeInfo(value="ceylon.language::List<Element>") @NonNull List<? extends Element> var1, @Name(value="from") @Defaulted @DocAnnotation$annotation$(description="The smallest index to consider, interpreted as\na reverse index counting from the _end_ of the \nlist, where `0` is the last element of the list, \nand `size-1` is the first element of the list.") @Annotations(value={@Annotation(value="doc", arguments={"The smallest index to consider, interpreted as\na reverse index counting from the _end_ of the \nlist, where `0` is the last element of the list, \nand `size-1` is the first element of the list."})}) long var2);
}

