/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.serialization;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Package;

@Ceylon(major=8, minor=1)
@Package(name="ceylon.language.serialization", doc="The Ceylon serialization infrastructure.\n\nThis package provides an API for *serialization libraries* to\nprovide their own serialization APIs to client code. It does not \nprovide a serialization service itself.\n\nThis API:\n\n* provides a way to walk the graph of instances added for serialization, \n  including those reachable via non-\\`shared\\` attributes,\n* copes with shared references and cyclic references in object graphs,\n* prevents access to uninitialized and partially initialized instances \n  during deserialization.  \n  (this includes instances reachable from other instances, transitively).\n  \nThe API cannot prevent serialization libraries from obtaining access to \nnon-\\`shared\\` state of instances (loss of encapsulation is \nan inevitable part of serialization).\n\nA serialization library will implement some kind of \nserializer and/or deserializer (frequently both) using the facilities \nof this API.\n\n## Serializers\n\nA *serializer* takes one or many Ceylon instances and serialize them \n(and the instances reachable from them) to \nsome external representation, usually bytes or text in some specific format. \n\nA serializer provided by a serialization library:\n\n* obtains a [[SerializationContext]] by \n  calling [[serialization]],\n* uses [[SerializationContext.references]] to find the references that \n  an instance holds,\n* proceeds to traverse the graph of instances according to \n  library-specific rules\n\n## Deserializers\n\nA *deserializer* constructs a graph of \nCeylon instances according to some external representation.\n  \nA deserializer provided by a serialization library:\n\n* obtains a [[DeserializationContext]] by \n  calling [[deserialization]]\n* progressively provides information about instances:\n\n    * associates an instance with its \n      [[class|DeserializationContext.instance]],\n    * associates a member instance with its [[containing instance|DeserializationContext.memberInstance]],\n    * associates a referred instance with its [[referring instance and attribute|DeserializationContext.attribute]],\n    * associates a referred instance with its [[referring array index|DeserializationContext.element]],\n    * associates an instance with a [[given other instance|DeserializationContext.instanceValue]]. \n      This is useful for instances which refer to singletons \n      (on deserialization the singleton value has to be provided, since it \n      cannot be instantiated by the serialization API).\n         \n* once the context has complete information about the instance \n  and every instance reachable from it\n  the instance can be \n  [[reconstructed|DeserializationContext.reconstruct]].\n \n## Serializability\n\n*Serializability* is whether or not a particular serialization library can \nserialize a particular instance. \n\nInstances of classes which are annotated [[serializable]] are able to \nenumerate their state during serialization, \nand initialize their state during deserialization.\nHowever, that does not imply that every serialization library \ncan necessarily serialize instances of every `serializable` class.\n  \nThe serializability of an instance can depend on:\n\n* the class of the instance, and its super classes,\n* the serializability of the outer instance(s), if the object is an \n  instance of a member class. ,\n* the serialization library's support for serializing generic classes, \n  and member classes,\n* the serialization library's support for serializing anonymous objects\n  (such as `true`, `null` or `smaller`),\n* the underlying serialization format the serialization library supports\n   \nThe deserializability of an instance can depend on:\n\n* The runtime availability and compatibility of the class of the instances, \n  and its super classes, for each instance in the object graph. ", by={"Gavin", "Tom"}, shared=true)
@DocAnnotation$annotation$(description="The Ceylon serialization infrastructure.\n\nThis package provides an API for *serialization libraries* to\nprovide their own serialization APIs to client code. It does not \nprovide a serialization service itself.\n\nThis API:\n\n* provides a way to walk the graph of instances added for serialization, \n  including those reachable via non-\\`shared\\` attributes,\n* copes with shared references and cyclic references in object graphs,\n* prevents access to uninitialized and partially initialized instances \n  during deserialization.  \n  (this includes instances reachable from other instances, transitively).\n  \nThe API cannot prevent serialization libraries from obtaining access to \nnon-\\`shared\\` state of instances (loss of encapsulation is \nan inevitable part of serialization).\n\nA serialization library will implement some kind of \nserializer and/or deserializer (frequently both) using the facilities \nof this API.\n\n## Serializers\n\nA *serializer* takes one or many Ceylon instances and serialize them \n(and the instances reachable from them) to \nsome external representation, usually bytes or text in some specific format. \n\nA serializer provided by a serialization library:\n\n* obtains a [[SerializationContext]] by \n  calling [[serialization]],\n* uses [[SerializationContext.references]] to find the references that \n  an instance holds,\n* proceeds to traverse the graph of instances according to \n  library-specific rules\n\n## Deserializers\n\nA *deserializer* constructs a graph of \nCeylon instances according to some external representation.\n  \nA deserializer provided by a serialization library:\n\n* obtains a [[DeserializationContext]] by \n  calling [[deserialization]]\n* progressively provides information about instances:\n\n    * associates an instance with its \n      [[class|DeserializationContext.instance]],\n    * associates a member instance with its [[containing instance|DeserializationContext.memberInstance]],\n    * associates a referred instance with its [[referring instance and attribute|DeserializationContext.attribute]],\n    * associates a referred instance with its [[referring array index|DeserializationContext.element]],\n    * associates an instance with a [[given other instance|DeserializationContext.instanceValue]]. \n      This is useful for instances which refer to singletons \n      (on deserialization the singleton value has to be provided, since it \n      cannot be instantiated by the serialization API).\n         \n* once the context has complete information about the instance \n  and every instance reachable from it\n  the instance can be \n  [[reconstructed|DeserializationContext.reconstruct]].\n \n## Serializability\n\n*Serializability* is whether or not a particular serialization library can \nserialize a particular instance. \n\nInstances of classes which are annotated [[serializable]] are able to \nenumerate their state during serialization, \nand initialize their state during deserialization.\nHowever, that does not imply that every serialization library \ncan necessarily serialize instances of every `serializable` class.\n  \nThe serializability of an instance can depend on:\n\n* the class of the instance, and its super classes,\n* the serializability of the outer instance(s), if the object is an \n  instance of a member class. ,\n* the serialization library's support for serializing generic classes, \n  and member classes,\n* the serialization library's support for serializing anonymous objects\n  (such as `true`, `null` or `smaller`),\n* the underlying serialization format the serialization library supports\n   \nThe deserializability of an instance can depend on:\n\n* The runtime availability and compatibility of the class of the instances, \n  and its super classes, for each instance in the object graph. ")
@AuthorsAnnotation$annotation$(authors={"Gavin", "Tom"})
@TagsAnnotation$annotation$(tags={"Serialization"})
@SinceAnnotation$annotation$(version="1.2.0")
@SharedAnnotation$annotation$
final class $package_ {
    private $package_() {
    }
}

