/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.serialization;

import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.model.ClassModel;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A contract for identifying instances, specifying their classes, attributes, \nelements and values, and ultimately reconstructing those instances.\n\nInstances are identified using the [[Id]]'s semantics for equality. The \nmethods of this interface can be called in any order; the id serves to \nassociate each method invocation with the instance(s) to pertains to. \nThe only constraint is that [[reconstruct]] will throw if the context \nlacks enough information to fully initialize the requested instance \n_or any instance reachable from it_. Reference cycles are supported.\n\nFor example, given\n\n    serializable class Person(name, employer) {\n        shared String name;\n        shared Company employer;\n    }\n    serializable class Company(name) {\n        shared String name;\n        shared late Person owner;\n    }\n  \nAnd an instance graph corresponding to:\n\n    value wonkaInc = Company(\"Wonka Inc.\");\n    value willy = Person(\"Willy Wonka\", wonkaInc);\n    value umpaLumpa = Person(\"Umpa lumpa\", wonkaInc);\n    wonkaInc.owner = willy;\n\nThen we could reconstruct that instance graph like so:\n\n    value dc = deserialization<String>();\n    \n    dc.attribute(\"ww\", `value Person.name`, \"wwn\");\n    dc.attribute(\"ww\", `value Person.employer`, \"wi\");\n    dc.attribute(\"ul\", `value Person.name`, \"uln\");\n    dc.attribute(\"ul\", `value Person.employer`, \"wi\");\n    dc.attribute(\"wi\", `value Company.name`, \"win\");\n    dc.attribute(\"wi\", `value Company.owner`, \"ww\");\n    \n    dc.instanceValue(\"win\", \"Wonka Inc.\");\n    dc.instanceValue(\"wwn\", \"Willy Wonka\");\n    dc.instanceValue(\"uln\", \"Umpa lumpa\");\n    \n    dc.instance(\"wi\", `Company`);\n    dc.instance(\"ww\", `Person`);\n    dc.instance(\"ul\", `Person`);\n    \n    value wonkaInc2 = dc.reconstruct<Company>(\"wi\");\n    value willy2 = dc.reconstruct<Person>(\"ww\");\n    value umpaLumpa2 = dc.reconstruct<Person>(\"ul\");\n    \n    assert(wonkaInc2.owner === willy2);\n    assert(willy2.employer === wonkaInc2);\n    assert(umpaLumpa2.employer === wonkaInc2);\n    \nThe calls to [[attribute]], [[instanceValue]] and [[instance]] could be \nin any order.")
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
@Annotations(modifiers=18L, value={@Annotation(value="doc", arguments={"A contract for identifying instances, specifying their classes, attributes, \nelements and values, and ultimately reconstructing those instances.\n\nInstances are identified using the [[Id]]'s semantics for equality. The \nmethods of this interface can be called in any order; the id serves to \nassociate each method invocation with the instance(s) to pertains to. \nThe only constraint is that [[reconstruct]] will throw if the context \nlacks enough information to fully initialize the requested instance \n_or any instance reachable from it_. Reference cycles are supported.\n\nFor example, given\n\n    serializable class Person(name, employer) {\n        shared String name;\n        shared Company employer;\n    }\n    serializable class Company(name) {\n        shared String name;\n        shared late Person owner;\n    }\n  \nAnd an instance graph corresponding to:\n\n    value wonkaInc = Company(\"Wonka Inc.\");\n    value willy = Person(\"Willy Wonka\", wonkaInc);\n    value umpaLumpa = Person(\"Umpa lumpa\", wonkaInc);\n    wonkaInc.owner = willy;\n\nThen we could reconstruct that instance graph like so:\n\n    value dc = deserialization<String>();\n    \n    dc.attribute(\"ww\", `value Person.name`, \"wwn\");\n    dc.attribute(\"ww\", `value Person.employer`, \"wi\");\n    dc.attribute(\"ul\", `value Person.name`, \"uln\");\n    dc.attribute(\"ul\", `value Person.employer`, \"wi\");\n    dc.attribute(\"wi\", `value Company.name`, \"win\");\n    dc.attribute(\"wi\", `value Company.owner`, \"ww\");\n    \n    dc.instanceValue(\"win\", \"Wonka Inc.\");\n    dc.instanceValue(\"wwn\", \"Willy Wonka\");\n    dc.instanceValue(\"uln\", \"Umpa lumpa\");\n    \n    dc.instance(\"wi\", `Company`);\n    dc.instance(\"ww\", `Person`);\n    dc.instance(\"ul\", `Person`);\n    \n    value wonkaInc2 = dc.reconstruct<Company>(\"wi\");\n    value willy2 = dc.reconstruct<Person>(\"ww\");\n    value umpaLumpa2 = dc.reconstruct<Person>(\"ul\");\n    \n    assert(wonkaInc2.owner === willy2);\n    assert(willy2.employer === wonkaInc2);\n    assert(umpaLumpa2.employer === wonkaInc2);\n    \nThe calls to [[attribute]], [[instanceValue]] and [[instance]] could be \nin any order."})})
@TypeParameters(value={@TypeParameter(value="Id", variance=Variance.NONE, satisfies={}, caseTypes={})})
public interface DeserializationContext<Id> {
    @DocAnnotation$annotation$(description="The given [[instanceId]] refers to an instance of the given class.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:serialization:CDeserializationException", when="the given instance was specified by [[instanceValue]] or has already been reconstructed.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The given [[instanceId]] refers to an instance of the given class."}), @Annotation(value="throws", arguments={"DeserializationException", "the given instance was specified by [[instanceValue]] or has already been reconstructed."})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object instance(@Name(value="instanceId") @TypeInfo(value="Id") Id var1, @Name(value="clazz") @TypeInfo(value="ceylon.language.meta.model::ClassModel<ceylon.language::Anything,ceylon.language::Nothing>", erased=true) @NonNull ClassModel var2);

    @DocAnnotation$annotation$(description="The given [[instanceId]] is a member of the instance with the given [[containerId]].\n\nThis is used for member class instances.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:serialization:CDeserializationException", when="the given instance was specified by [[instanceValue]] or has already been reconstructed.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The given [[instanceId]] is a member of the instance with the given [[containerId]].\n\nThis is used for member class instances."}), @Annotation(value="throws", arguments={"DeserializationException", "the given instance was specified by [[instanceValue]] or has already been reconstructed."})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object memberInstance(@Name(value="containerId") @TypeInfo(value="Id") Id var1, @Name(value="instanceId") @TypeInfo(value="Id") Id var2);

    @DocAnnotation$annotation$(description="The value of the given [[attribute]] of the instance with \nthe given [[instanceId]] has given [[attributeValueId]].")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:serialization:CDeserializationException", when="the given instance was specified by [[instanceValue]] or has already been reconstructed.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The value of the given [[attribute]] of the instance with \nthe given [[instanceId]] has given [[attributeValueId]]."}), @Annotation(value="throws", arguments={"DeserializationException", "the given instance was specified by [[instanceValue]] or has already been reconstructed."})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object attribute(@Name(value="instanceId") @TypeInfo(value="Id") Id var1, @Name(value="attribute") @TypeInfo(value="ceylon.language.meta.declaration::ValueDeclaration") @NonNull ValueDeclaration var2, @Name(value="attributeValueId") @TypeInfo(value="Id") Id var3);

    @DocAnnotation$annotation$(description="The value at the given [[index]] of the [[Array]] instance with \nthe given [[instanceId]] has given [[elementValueId]].")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:serialization:CDeserializationException", when="the given instance was specified by [[instanceValue]] or has already been reconstructed.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The value at the given [[index]] of the [[Array]] instance with \nthe given [[instanceId]] has given [[elementValueId]]."}), @Annotation(value="throws", arguments={"DeserializationException", "the given instance was specified by [[instanceValue]] or has already been reconstructed."})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object element(@Name(value="instanceId") @TypeInfo(value="Id") Id var1, @Name(value="index") long var2, @Name(value="elementValueId") @TypeInfo(value="Id") Id var4);

    @DocAnnotation$annotation$(description="The instance with the given [[instanceId]] has the given value.\n\nThis can used to register non-serializable instances with the context, \nfor example object declarations.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The instance with the given [[instanceId]] has the given value.\n\nThis can used to register non-serializable instances with the context, \nfor example object declarations."})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object instanceValue(@Name(value="instanceId") @TypeInfo(value="Id") Id var1, @Name(value="instanceValue") @TypeInfo(value="ceylon.language::Anything") @Nullable Object var2);

    @DocAnnotation$annotation$(description="Get the instance with the given [[instanceId]] reconstructing it \nif necessary.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:serialization:CDeserializationException", when="the instance, or an instance reachable from it, \ncould not be reconstructed")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Get the instance with the given [[instanceId]] reconstructing it \nif necessary."}), @Annotation(value="throws", arguments={"DeserializationException", "the instance, or an instance reachable from it, \ncould not be reconstructed"})})
    @TypeInfo(value="Instance")
    @TypeParameters(value={@TypeParameter(value="Instance", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public <Instance> Instance reconstruct(@Ignore TypeDescriptor var1, @Name(value="instanceId") @TypeInfo(value="Id") Id var2);
}

