/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap.loader;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

final class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(final String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
        return System.getProperty(key);
    }

    static String getProperty(final String key, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key, defaultValue);
                }
            });
        }
        return System.getProperty(key, defaultValue);
    }

    static boolean getBoolean(final String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean(key);
                }
            });
        }
        return Boolean.getBoolean(key);
    }

    static Method findModule() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    return SecurityActions.findModuleInternal();
                }
            });
        }
        return SecurityActions.findModuleInternal();
    }

    private static Method findModuleInternal() throws RuntimeException {
        try {
            Method declaredMethod = ModuleLoader.class.getDeclaredMethod("findModule", ModuleIdentifier.class);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

