/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.ClassOrPackageDoc;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class PackageDoc
extends ClassOrPackageDoc {
    private final Package pkg;
    private final boolean sharingPageWithModule;
    private final SortedMap<String, Class> classes = new TreeMap<String, Class>();
    private final SortedMap<String, Interface> interfaces = new TreeMap<String, Interface>();
    private final SortedMap<String, FunctionOrValue> attributes = new TreeMap<String, FunctionOrValue>();
    private final SortedMap<String, Function> methods = new TreeMap<String, Function>();
    private final SortedMap<String, Class> exceptions = new TreeMap<String, Class>();
    private final SortedMap<String, TypeAlias> aliases = new TreeMap<String, TypeAlias>();
    private final SortedMap<String, Class> annotationTypes = new TreeMap<String, Class>();
    private final SortedMap<String, Function> annotationConstructors = new TreeMap<String, Function>();

    public PackageDoc(CeylonDocTool tool, Writer writer, Package pkg) throws IOException {
        super(pkg.getModule(), tool, writer);
        this.pkg = pkg;
        this.sharingPageWithModule = tool.isRootPackage(this.module, pkg);
        this.loadMembers();
    }

    private void loadMembers() {
        for (Declaration m : this.pkg.getMembers()) {
            if (!this.tool.shouldInclude(m)) continue;
            if (m instanceof Interface) {
                this.addTo(this.interfaces, (Interface)m);
                continue;
            }
            if (m instanceof Class) {
                Class c = (Class)m;
                if (c.isAnnotation()) {
                    this.addTo(this.annotationTypes, c);
                    continue;
                }
                if (Util.isThrowable(c)) {
                    this.addTo(this.exceptions, c);
                    continue;
                }
                this.addTo(this.classes, c);
                continue;
            }
            if (m instanceof Value) {
                this.addTo(this.attributes, (Value)m);
                continue;
            }
            if (m instanceof Function) {
                Function method = (Function)m;
                if (m.isAnnotation()) {
                    this.addTo(this.annotationConstructors, method);
                    continue;
                }
                this.addTo(this.methods, method);
                continue;
            }
            if (!(m instanceof TypeAlias)) continue;
            this.addTo(this.aliases, (TypeAlias)m);
        }
    }

    private <T extends Declaration> void addTo(SortedMap<String, T> map, T decl) {
        map.put(Util.getDeclarationName(decl), decl);
        for (String alias : decl.getAliases()) {
            map.put(alias, decl);
        }
    }

    public void generate() throws IOException {
        if (!this.sharingPageWithModule) {
            this.writeHeader("Package " + this.pkg.getName(), new String[0]);
            this.writeNavBar();
        }
        this.writeSubNav();
        this.open("div class='container-fluid'");
        this.writeDescription();
        this.writeSubpackages();
        this.writeAliases();
        this.writeAnnotations();
        this.writeAttributes();
        this.writeMethods();
        this.writeInterfaces();
        this.writeClasses();
        this.writeExceptions();
        this.close("div");
        if (!this.sharingPageWithModule) {
            this.writeFooter(new String[0]);
        }
    }

    private void writeSubNav() throws IOException {
        this.open("div class='sub-navbar'");
        this.writeLinkSourceCode(this.pkg);
        if (this.sharingPageWithModule) {
            this.open("div id='section-package' class='sub-navbar-inner'");
        } else {
            this.open("div class='sub-navbar-inner'");
        }
        this.around("span class='sub-navbar-label'", "package");
        this.writeIcon(this.pkg);
        this.open("span class='sub-navbar-name'");
        this.writePackageNavigation(this.pkg);
        this.close("span");
        this.close("div");
        this.open("div class='sub-navbar-menu'");
        if (!this.sharingPageWithModule) {
            this.writeSubNavBarLink(this.linkRenderer().to(this.module).getUrl(), "Overview", 'O', "Jump to module documentation");
        }
        if (!this.aliases.isEmpty()) {
            this.writeSubNavBarLink("#section-aliases", "Aliases", 'l', "Jump to aliases");
        }
        if (!this.annotationTypes.isEmpty() || !this.annotationConstructors.isEmpty()) {
            this.writeSubNavBarLink("#section-annotations", "Annotations", 'n', "Jump to annotations");
        }
        if (!this.attributes.isEmpty()) {
            this.writeSubNavBarLink("#section-attributes", "Values", 'V', "Jump to values");
        }
        if (!this.methods.isEmpty()) {
            this.writeSubNavBarLink("#section-methods", "Functions", 'F', "Jump to functions");
        }
        if (!this.interfaces.isEmpty()) {
            this.writeSubNavBarLink("#section-interfaces", "Interfaces", 'I', "Jump to interfaces");
        }
        if (!this.classes.isEmpty()) {
            this.writeSubNavBarLink("#section-classes", "Classes", 'C', "Jump to classes");
        }
        if (!this.exceptions.isEmpty()) {
            this.writeSubNavBarLink("#section-exceptions", "Exceptions", 'E', "Jump to exceptions");
        }
        this.close("div");
        this.close("div");
    }

    private void writeDescription() throws IOException {
        this.open("div class='package-description'");
        this.writeTagged(this.pkg);
        String doc = Util.getDoc(this.pkg, this.linkRenderer());
        if (Util.isEmpty(doc)) {
            this.tool.warningMissingDoc(this.pkg.getQualifiedNameString(), this.pkg);
        }
        this.around("div class='doc'", doc);
        this.writeAnnotations(this.pkg);
        this.writeBy(this.pkg);
        this.writeSee(this.pkg);
        this.writeSince(this.pkg);
        this.close("div");
    }

    private void writeSubpackages() throws IOException {
        if (!this.sharingPageWithModule) {
            ArrayList<Package> subpackages = new ArrayList<Package>();
            for (Package p : this.module.getPackages()) {
                if (p.getName().size() != this.pkg.getName().size() + 1 || !p.getNameAsString().startsWith(this.pkg.getNameAsString()) || !this.tool.shouldInclude(p)) continue;
                subpackages.add(p);
            }
            Collections.sort(subpackages, Util.ReferenceableComparatorByName.INSTANCE);
            this.writePackagesTable("Subpackages", subpackages);
        }
    }

    private void writeAliases() throws IOException {
        if (this.aliases.isEmpty()) {
            return;
        }
        this.openTable("section-aliases", "Aliases", 2, true);
        for (Map.Entry<String, TypeAlias> a : this.aliases.entrySet()) {
            this.doc(a.getKey(), a.getValue());
        }
        this.closeTable();
    }

    private void writeAnnotations() throws IOException {
        if (this.annotationTypes.isEmpty() && this.annotationConstructors.isEmpty()) {
            return;
        }
        this.openTable("section-annotations", "Annotations", 2, true);
        for (Map.Entry<String, Function> entry : this.annotationConstructors.entrySet()) {
            this.doc(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Declaration> entry : this.annotationTypes.entrySet()) {
            this.doc(entry.getKey(), (ClassOrInterface)entry.getValue());
        }
        this.closeTable();
    }

    private void writeAttributes() throws IOException {
        if (this.attributes.isEmpty()) {
            return;
        }
        this.openTable("section-attributes", "Values", 2, true);
        for (Map.Entry<String, FunctionOrValue> v : this.attributes.entrySet()) {
            this.doc(v.getKey(), v.getValue());
        }
        this.closeTable();
    }

    private void writeMethods() throws IOException {
        if (this.methods.isEmpty()) {
            return;
        }
        this.openTable("section-methods", "Functions", 2, true);
        for (Map.Entry<String, Function> m : this.methods.entrySet()) {
            this.doc(m.getKey(), m.getValue());
        }
        this.closeTable();
    }

    private void writeInterfaces() throws IOException {
        if (this.interfaces.isEmpty()) {
            return;
        }
        this.openTable("section-interfaces", "Interfaces", 2, true);
        for (Map.Entry<String, Interface> i : this.interfaces.entrySet()) {
            this.doc(i.getKey(), i.getValue());
        }
        this.closeTable();
    }

    private void writeClasses() throws IOException {
        if (this.classes.isEmpty()) {
            return;
        }
        this.openTable("section-classes", "Classes", 2, true);
        for (Map.Entry<String, Class> c : this.classes.entrySet()) {
            this.doc(c.getKey(), c.getValue());
        }
        this.closeTable();
    }

    private void writeExceptions() throws IOException {
        if (this.exceptions.isEmpty()) {
            return;
        }
        this.openTable("section-exceptions", "Exceptions", 2, true);
        for (Map.Entry<String, Class> e : this.exceptions.entrySet()) {
            this.doc(e.getKey(), e.getValue());
        }
        this.closeTable();
    }

    @Override
    protected void registerAdditionalKeyboardShortcuts() throws IOException {
        this.registerKeyboardShortcut('p', "index.html");
        if (!this.aliases.isEmpty()) {
            this.registerKeyboardShortcut('l', "#section-aliases");
        }
        if (!this.annotationTypes.isEmpty() || !this.annotationConstructors.isEmpty()) {
            this.registerKeyboardShortcut('n', "#section-annotations");
        }
        if (!this.attributes.isEmpty()) {
            this.registerKeyboardShortcut('v', "#section-attributes");
            this.registerKeyboardShortcut('a', "#section-attributes");
        }
        if (!this.methods.isEmpty()) {
            this.registerKeyboardShortcut('f', "#section-methods");
            this.registerKeyboardShortcut('m', "#section-methods");
        }
        if (!this.interfaces.isEmpty()) {
            this.registerKeyboardShortcut('i', "#section-interfaces");
        }
        if (!this.classes.isEmpty()) {
            this.registerKeyboardShortcut('c', "#section-classes");
        }
        if (!this.exceptions.isEmpty()) {
            this.registerKeyboardShortcut('e', "#section-exceptions");
        }
    }

    @Override
    protected Object getFromObject() {
        return this.pkg;
    }
}

