/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.Helper;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class AbstractRepositoryManager
implements RepositoryManager {
    protected final Logger log;
    protected Overrides overrides;

    public AbstractRepositoryManager(Logger log, Overrides overrides) {
        this.log = log;
        this.overrides = overrides;
    }

    public static File[] flatten(ArtifactResult result) throws RepositoryException {
        if (result == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        AbstractRepositoryManager.recurse(files, result);
        return files.toArray(new File[files.size()]);
    }

    private static void recurse(List<File> files, ArtifactResult current) throws RepositoryException {
        files.add(current.artifact());
        for (ArtifactResult ar : current.dependencies()) {
            AbstractRepositoryManager.recurse(files, ar);
        }
    }

    @Override
    public File[] resolve(String namespace, String name, String version2) throws RepositoryException {
        ArtifactContext context = new ArtifactContext(namespace, name, version2);
        return this.resolve(context);
    }

    @Override
    public File[] resolve(ArtifactContext context) throws RepositoryException {
        ArtifactResult result = this.getArtifactResult(context);
        return AbstractRepositoryManager.flatten(result);
    }

    @Override
    public File getArtifact(String namespace, String name, String version2) throws RepositoryException {
        ArtifactContext context = new ArtifactContext(namespace, name, version2);
        return this.getArtifact(context);
    }

    @Override
    public File getArtifact(ArtifactContext context) throws RepositoryException {
        ArtifactResult result = this.getArtifactResult(context);
        return result != null ? result.artifact() : null;
    }

    @Override
    public ArtifactResult getArtifactResult(String namespace, String name, String version2) throws RepositoryException {
        ArtifactContext context = new ArtifactContext(namespace, name, version2);
        return this.getArtifactResult(context);
    }

    protected ArtifactResult getFolder(ArtifactContext context, Node node) throws RepositoryException {
        throw new RepositoryException("RepositoryManager doesn't support folder get: " + context);
    }

    protected ArtifactResult artifactNotFound(ArtifactContext context) throws RepositoryException {
        return null;
    }

    @Override
    public List<ArtifactResult> getArtifactResults(ArtifactContext context) throws RepositoryException {
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>();
        ArtifactResult result = null;
        LinkedHashSet<String> suffixes = new LinkedHashSet<String>(Arrays.asList(context.getSuffixes()));
        while (!suffixes.isEmpty()) {
            String[] sfx = suffixes.toArray(new String[suffixes.size()]);
            ArtifactContext ac = result == null ? context : context.getSibling(result, sfx);
            if ((result = this.getArtifactResult(ac)) == null) break;
            results.add(result);
            String suffix = ArtifactContext.getSuffixFromFilename(result.artifact().getName());
            Iterator iter = suffixes.iterator();
            while (iter.hasNext() && !suffix.equals(iter.next())) {
                iter.remove();
            }
            suffixes.remove(suffix);
            if (suffix.equals(".car")) {
                suffixes.remove(".jar");
                suffixes.remove("module.properties");
                suffixes.remove("module.xml");
                continue;
            }
            if (!suffix.equals(".jar") && !suffix.equals("module.properties") && !suffix.equals("module.xml")) continue;
            suffixes.remove(".car");
        }
        return results;
    }

    @Override
    public void putArtifact(String namespace, String name, String version2, InputStream content) throws RepositoryException {
        ArtifactContext context = new ArtifactContext(namespace, name, version2);
        this.putArtifact(context, content);
    }

    @Override
    public void putArtifact(String namespace, String name, String version2, File content) throws RepositoryException {
        ArtifactContext context = new ArtifactContext(namespace, name, version2);
        this.putArtifact(context, content);
    }

    @Override
    public void putArtifact(ArtifactContext context, File content) throws RepositoryException {
        if (content == null) {
            throw new IllegalArgumentException("Null file!");
        }
        if (!this.isSameFile(context, content)) {
            if (content.isDirectory()) {
                this.putFolder(context, content);
            } else {
                this.putArtifact(context, Helper.toInputStream(content));
            }
        } else {
            this.log.debug("  -> [skipping] source and destination are the same");
        }
    }

    public abstract boolean isSameFile(ArtifactContext var1, File var2) throws RepositoryException;

    protected void putFolder(ArtifactContext context, File folder) throws RepositoryException {
        throw new RepositoryException("RepositoryManager doesn't support folder [" + folder + "] put: " + context);
    }

    @Override
    public void removeArtifact(String namespace, String name, String version2) throws RepositoryException {
        ArtifactContext context = new ArtifactContext(namespace, name, version2);
        this.removeArtifact(context);
    }

    @Override
    public Overrides getOverrides() {
        return this.overrides;
    }

    @Override
    public void setOverrides(Overrides overrides) {
        this.overrides = overrides;
    }
}

