/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.FilterRule;
import com.redhat.ceylon.model.cmr.PathFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class PathFilterParser {
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private static final String MODULE_1_0 = "urn:jboss:module:1.0";
    private static final String MODULE_1_1 = "urn:jboss:module:1.1";
    private static final String MODULE_1_2 = "urn:jboss:module:1.2";
    private static final String MODULE_1_3 = "urn:jboss:module:1.3";
    private static final String A_NAME = "name";
    private static final String A_PATH = "path";
    private static final String E_INCLUDE = "include";
    private static final String E_EXCLUDE = "exclude";
    private static final String E_INCLUDE_SET = "include-set";
    private static final String E_EXCLUDE_SET = "exclude-set";
    private static final String E_PATH = "path";

    public static PathFilter parse(String filter) throws IOException {
        if (filter.startsWith("<exports>") || filter.startsWith("<filter>")) {
            int end = filter.indexOf(62);
            filter = filter.substring(0, end) + " xmlns=\"urn:jboss:module:1.0\"" + filter.substring(end);
        }
        return PathFilterParser.parse(new ByteArrayInputStream(filter.getBytes()));
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    public static PathFilter parse(InputStream inputStream) throws IOException {
        try {
            XMLInputFactory inputFactory = INPUT_FACTORY;
            PathFilterParser.setIfSupported(inputFactory, "javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(inputStream);
            PathFilter pathFilter = PathFilterParser.parseFilter(streamReader);
            return pathFilter;
        }
        catch (Exception e) {
            throw new IOException("Error parsing filter.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static PathFilter parseFilter(XMLStreamReader reader) throws Exception {
        reader.nextTag();
        ModulesPathFilter pathFilter = new ModulesPathFilter();
        PathFilterParser.parseFilterList(reader, pathFilter);
        return pathFilter;
    }

    public static String convertNodeToString(Node node) throws TransformerException {
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    private static void parseFilterList(XMLStreamReader reader, ModulesPathFilter pathFilter) throws IOException, XMLStreamException {
        PathFilterParser.assertNoAttributes(reader);
        block16: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 2: {
                    return;
                }
                case 1: {
                    PathFilterParser.validateNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "include": {
                            PathFilterParser.parsePath(reader, true, pathFilter);
                            continue block16;
                        }
                        case "exclude": {
                            PathFilterParser.parsePath(reader, false, pathFilter);
                            continue block16;
                        }
                        case "include-set": {
                            PathFilterParser.parseSet(reader, true, pathFilter);
                            continue block16;
                        }
                        case "exclude-set": {
                            PathFilterParser.parseSet(reader, false, pathFilter);
                            continue block16;
                        }
                    }
                    throw PathFilterParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw PathFilterParser.unexpectedContent(reader);
    }

    private static void parsePath(XMLStreamReader reader, boolean include, ModulesPathFilter pathFilter) throws IOException, XMLStreamException {
        boolean literal;
        String path = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList("path"));
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            PathFilterParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeLocalName(i);
            required.remove(attribute);
            switch (attribute) {
                case "path": {
                    path = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw PathFilterParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw PathFilterParser.missingAttributes(reader, required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                pathFilter.addFilter(new FilterRule.IsChildOfFilterRule(path, include));
            } else {
                pathFilter.addFilter(new FilterRule.IsFilterRule(path, include));
            }
        } else {
            pathFilter.addFilter(new FilterRule.MatchFilterRule(path, include));
        }
        PathFilterParser.parseNoContent(reader);
    }

    private static Set<String> parseSet(XMLStreamReader reader) throws IOException, XMLStreamException {
        PathFilterParser.assertNoAttributes(reader);
        HashSet<String> set = new HashSet<String>();
        while (true) {
            int eventType = reader.nextTag();
            block0 : switch (eventType) {
                case 2: {
                    return set;
                }
                case 1: {
                    PathFilterParser.validateNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "path": {
                            PathFilterParser.parsePathName(reader, set);
                            break block0;
                        }
                    }
                    throw PathFilterParser.unexpectedContent(reader);
                }
            }
        }
    }

    private static void parseSet(XMLStreamReader reader, boolean include, ModulesPathFilter pathFilter) throws IOException, XMLStreamException {
        pathFilter.addFilter(new FilterRule.SetFilterRule(PathFilterParser.parseSet(reader), include));
    }

    private static void parsePathName(XMLStreamReader reader, Set<String> set) throws IOException, XMLStreamException {
        String name = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME));
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            PathFilterParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeLocalName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw PathFilterParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw PathFilterParser.missingAttributes(reader, required);
        }
        set.add(name);
        PathFilterParser.parseNoContent(reader);
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException unknownAttribute(XMLStreamReader parser, int index) {
        String namespace = parser.getAttributeNamespace(index);
        String prefix = parser.getAttributePrefix(index);
        String name = parser.getAttributeLocalName(index);
        StringBuilder eb = new StringBuilder("Unknown attribute \"");
        if (prefix != null) {
            eb.append(prefix).append(':');
        }
        eb.append(name);
        if (namespace != null) {
            eb.append("\" from namespace \"").append(namespace);
        }
        eb.append('\"');
        return new XMLStreamException(eb.toString(), parser.getLocation());
    }

    private static XMLStreamException missingAttributes(XMLStreamReader parser, Set<String> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (String attribute : required) {
            b.append(' ').append(attribute);
        }
        return new XMLStreamException(b.toString(), parser.getLocation());
    }

    private static void assertNoAttributes(XMLStreamReader reader) throws XMLStreamException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw PathFilterParser.unknownAttribute(reader, 0);
        }
    }

    private static void validateAttributeNamespace(XMLStreamReader reader, int index) throws XMLStreamException {
        if (reader.getAttributeNamespace(index) != null) {
            throw PathFilterParser.unknownAttribute(reader, index);
        }
    }

    private static void parseNoContent(XMLStreamReader reader) throws IOException, XMLStreamException {
        int eventType = reader.nextTag();
        switch (eventType) {
            case 2: {
                return;
            }
        }
        throw PathFilterParser.unexpectedContent(reader);
    }

    private static void validateNamespace(XMLStreamReader reader) throws XMLStreamException {
        switch (reader.getNamespaceURI()) {
            case "urn:jboss:module:1.0": 
            case "urn:jboss:module:1.1": 
            case "urn:jboss:module:1.2": 
            case "urn:jboss:module:1.3": {
                break;
            }
            default: {
                throw PathFilterParser.unexpectedContent(reader);
            }
        }
    }

    private static class ModulesPathFilter
    implements PathFilter {
        List<FilterRule> rules = new LinkedList<FilterRule>();

        private ModulesPathFilter() {
        }

        void addFilter(FilterRule rule) {
            this.rules.add(rule);
        }

        @Override
        public boolean accept(String path) {
            for (FilterRule rule : this.rules) {
                Boolean ret = rule.accept(path);
                if (ret == null) continue;
                return ret;
            }
            return true;
        }
    }
}

