/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon.loader;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.DependencyOverride;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleLoader;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleNotFoundException;
import com.redhat.ceylon.cmr.impl.FlatRepository;
import com.redhat.ceylon.common.CeylonVersionComparator;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.Exclusion;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.loader.JdkProvider;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class BaseModuleLoaderImpl
implements ModuleLoader {
    protected final RepositoryManager repositoryManager;
    protected final ClassLoader delegateClassLoader;
    protected final JdkProvider jdkProvider;
    protected final Map<String, String> extraModules;
    protected final Map<String, ModuleLoaderContext> contexts = new HashMap<String, ModuleLoaderContext>();
    protected final boolean verbose;

    public BaseModuleLoaderImpl() {
        this(null, null);
    }

    public void log(String string) {
        System.err.println("[CMR:DEBUG] " + string);
    }

    public BaseModuleLoaderImpl(RepositoryManager repoManager, ClassLoader delegateClassLoader) {
        this(repoManager, delegateClassLoader, null, false);
    }

    public BaseModuleLoaderImpl(RepositoryManager repositoryManager, ClassLoader delegateClassLoader, Map<String, String> extraModules, boolean verbose) {
        this.repositoryManager = repositoryManager == null ? CeylonUtils.repoManager().buildManager() : repositoryManager;
        this.delegateClassLoader = delegateClassLoader == null ? BaseModuleLoaderImpl.class.getClassLoader() : delegateClassLoader;
        this.verbose = verbose;
        this.jdkProvider = new JdkProvider();
        this.extraModules = extraModules;
    }

    @Override
    public ClassLoader loadModule(String name, String version2) throws ModuleNotFoundException {
        return this.loadModule(name, version2, ModuleScope.RUNTIME);
    }

    @Override
    public ClassLoader loadModule(String name, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
        String key = name;
        ModuleLoaderContext ctx = this.contexts.get(key);
        if (ctx == null) {
            ctx = this.createModuleLoaderContext(name, version2, lookupScope);
            ctx.initialise();
            this.contexts.put(key, ctx);
        }
        return ctx.moduleClassLoader;
    }

    protected abstract ModuleLoaderContext createModuleLoaderContext(String var1, String var2, ModuleScope var3) throws ModuleNotFoundException;

    public void cleanup() {
        for (ModuleLoaderContext ctx : this.contexts.values()) {
            ctx.cleanup();
        }
        this.contexts.clear();
    }

    public URL[] getClassLoaderURLs(String module) {
        ModuleLoaderContext ctx = this.contexts.get(module);
        return ctx.getClassLoaderURLs();
    }

    protected abstract class ModuleLoaderContext
    implements ModuleGraph.DependencySelector,
    ModuleGraph.CycleListener {
        protected final String module;
        protected final String modver;
        protected final ModuleScope lookupScope;
        protected final ModuleGraph moduleGraph = new ModuleGraph();
        protected ClassLoader moduleClassLoader;
        protected SortedMap<String, SortedSet<String>> duplicateModules = new TreeMap<String, SortedSet<String>>();

        protected ModuleLoaderContext(String module, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
            this.module = module;
            this.modver = version2;
            this.lookupScope = lookupScope;
        }

        protected abstract void initialise() throws ModuleNotFoundException;

        protected void preloadModules() throws ModuleNotFoundException {
            try {
                this.loadModule(ModuleUtil.getNamespaceFromUri(this.module), ModuleUtil.getModuleNameFromUri(this.module), this.modver, false, false, null);
                this.finishLoadingModules();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void finishLoadingModules() throws IOException, ModuleNotFoundException {
            Overrides overrides;
            if (BaseModuleLoaderImpl.this.extraModules != null) {
                for (Map.Entry<String, String> entry : BaseModuleLoaderImpl.this.extraModules.entrySet()) {
                    this.loadModule(ModuleUtil.getNamespaceFromUri(entry.getKey()), ModuleUtil.getModuleNameFromUri(entry.getKey()), entry.getValue(), false, false, null);
                }
            }
            if ((overrides = BaseModuleLoaderImpl.this.repositoryManager.getOverrides()) != null) {
                for (ArtifactContext context : overrides.getAddedArtifacts()) {
                    this.loadModule(context.getNamespace(), context.getName(), context.getVersion(), false, false, null);
                }
            }
            this.moduleGraph.pruneExclusions(this);
            this.moduleGraph.checkForCycles(this);
            if (BaseModuleLoaderImpl.this.verbose) {
                this.moduleGraph.dump(false);
                System.err.println("Total: " + this.getModuleCount());
            }
        }

        protected void reloadArtifactResults() {
            this.moduleGraph.visit(new ModuleGraph.Visitor(){

                @Override
                public void visit(ModuleGraph.Module module) {
                    if (module.artifact != null) {
                        ArtifactResult result;
                        ArtifactContext artifactContext = new ArtifactContext(module.artifact.namespace(), module.name, module.version, ModuleLoaderContext.this.getArtifactSuffixes());
                        module.artifact = result = BaseModuleLoaderImpl.this.repositoryManager.getArtifactResult(artifactContext);
                    }
                }
            });
        }

        protected abstract String[] getArtifactSuffixes();

        public void fillOverrides(final Overrides overrides) {
            this.moduleGraph.visit(new ModuleGraph.Visitor(){

                @Override
                public void visit(ModuleGraph.Module module) {
                    if (module.artifact != null) {
                        overrides.addSetArtifact(module.name, module.version);
                        if (BaseModuleLoaderImpl.this.verbose) {
                            BaseModuleLoaderImpl.this.log("Fixing version of module " + module.name + " to " + module.version);
                        }
                        for (ArtifactResult dep : module.artifact.dependencies()) {
                            if (!ModuleLoaderContext.this.selectDependency(dep) || dep.getExclusions() == null) continue;
                            for (Exclusion exclusion : dep.getExclusions()) {
                                ArtifactContext artifactContext = Overrides.createMavenArtifactContext(exclusion.getGroupId(), exclusion.getArtifactId(), null, null, null);
                                DependencyOverride doo = new DependencyOverride(artifactContext, DependencyOverride.Type.REMOVE, false, false);
                                overrides.addRemovedArtifact(doo);
                                if (!BaseModuleLoaderImpl.this.verbose) continue;
                                BaseModuleLoaderImpl.this.log("Removing module " + exclusion.getGroupId() + ":" + exclusion.getArtifactId());
                            }
                        }
                    }
                }
            });
        }

        public int getModuleCount() {
            return this.moduleGraph.getCount();
        }

        /*
         * Enabled aggressive block sorting
         */
        protected boolean loadModule(String namespace, String name, String version2, boolean optional, boolean inCurrentClassLoader, ModuleGraph.Module dependent) throws IOException, ModuleNotFoundException {
            if (this.isExcluded(name, version2)) {
                return false;
            }
            ArtifactContext artifactContext = new ArtifactContext(namespace, name, version2, this.getArtifactSuffixes());
            Overrides overrides = BaseModuleLoaderImpl.this.repositoryManager.getOverrides();
            if (overrides != null) {
                if (overrides.isRemoved(artifactContext)) {
                    return false;
                }
                ArtifactContext replacement = overrides.replace(artifactContext);
                if (replacement != null) {
                    artifactContext = replacement;
                    name = replacement.getName();
                    version2 = replacement.getVersion();
                    namespace = replacement.getNamespace();
                }
                if (overrides.isVersionOverridden(artifactContext)) {
                    version2 = overrides.getVersionOverride(artifactContext);
                    artifactContext.setVersion(version2);
                }
            }
            if (BaseModuleLoaderImpl.this.jdkProvider.isJDKModule(name)) {
                return true;
            }
            ModuleGraph.Module loadedModule = this.moduleGraph.findModule(name);
            if (loadedModule != null) {
                String loadedVersion = loadedModule.version;
                if (!Objects.equals(version2, loadedVersion)) {
                    TreeSet<String> versions = (TreeSet<String>)this.duplicateModules.get(name);
                    if (versions == null) {
                        versions = new TreeSet<String>();
                        this.duplicateModules.put(name, versions);
                    }
                    versions.add(version2);
                    versions.add(loadedVersion);
                    if (CeylonVersionComparator.compareVersions(version2, loadedModule.version) <= 0) {
                        this.addDependency(dependent, loadedModule);
                        return true;
                    }
                    if (BaseModuleLoaderImpl.this.verbose) {
                        BaseModuleLoaderImpl.this.log("Replacing " + loadedModule + " with newer version " + version2);
                    }
                } else {
                    if (loadedModule.artifact != null) {
                        this.addDependency(dependent, loadedModule);
                        return true;
                    }
                    if (!optional) {
                        throw new ModuleNotFoundException("Could not find module: " + ModuleUtil.makeModuleName(name, version2));
                    }
                    this.addDependency(dependent, loadedModule);
                    return true;
                }
            }
            if (BaseModuleLoaderImpl.this.verbose) {
                BaseModuleLoaderImpl.this.log("Resolving " + name + "/" + version2);
            }
            this.prepareContext(artifactContext);
            ArtifactResult result = BaseModuleLoaderImpl.this.repositoryManager.getArtifactResult(artifactContext);
            if (!(optional || result != null && result.artifact() != null && result.artifact().exists())) {
                this.resolvingFailed(artifactContext);
                this.handleMissingModuleError(name, version2);
            } else {
                this.resolvingSuccess(result);
            }
            ModuleGraph.Module mod = dependent == null ? this.moduleGraph.addRoot(name, version2) : dependent.addDependency(name, version2);
            if (loadedModule != null) {
                loadedModule.replace(mod);
            }
            mod.artifact = result;
            if (result != null && this.selectDependencies(name, version2)) {
                if (inCurrentClassLoader || result.repository() instanceof FlatRepository) {
                    mod.inCurrentClassLoader = true;
                }
                for (ArtifactResult dep : result.dependencies()) {
                    if (mod.replaced) break;
                    if (!this.selectDependency(dep)) continue;
                    this.loadModule(dep.namespace(), dep.name(), dep.version(), dep.optional(), inCurrentClassLoader, mod);
                }
                if (name.equals("default")) {
                    this.loadModule(namespace, "ceylon.language", "1.3.2", false, inCurrentClassLoader, mod);
                }
            }
            if (result == null) return false;
            return true;
        }

        @Override
        public void cycleDetected(List<ModuleGraph.Module> path) {
        }

        protected void handleMissingModuleError(String name, String version2) throws ModuleNotFoundException {
            throw new ModuleNotFoundException("Could not find module: " + ModuleUtil.makeModuleName(name, version2));
        }

        protected boolean selectDependencies(String name, String version2) {
            return true;
        }

        protected boolean isExcluded(String name, String version2) {
            return false;
        }

        protected void resolvingSuccess(ArtifactResult result) {
        }

        protected void resolvingFailed(ArtifactContext artifactContext) {
        }

        protected void prepareContext(ArtifactContext artifactContext) {
        }

        protected boolean includeOptional() {
            return false;
        }

        @Override
        public boolean selectDependency(ArtifactResult dep) {
            if (!this.includeOptional() && dep.optional()) {
                return false;
            }
            return this.includeDependencyInLookupScope(dep);
        }

        @Override
        public boolean canExclude(ModuleGraph.Module mod) {
            Overrides overrides;
            if (mod.name.equals(this.module) && mod.version.equals(this.modver)) {
                return false;
            }
            if (BaseModuleLoaderImpl.this.extraModules != null) {
                for (Map.Entry<String, String> entry : BaseModuleLoaderImpl.this.extraModules.entrySet()) {
                    if (!mod.name.equals(entry.getKey()) || !mod.version.equals(entry.getValue())) continue;
                    return false;
                }
            }
            if ((overrides = BaseModuleLoaderImpl.this.repositoryManager.getOverrides()) != null) {
                for (ArtifactContext context : overrides.getAddedArtifacts()) {
                    if (!mod.name.equals(context.getName()) || !mod.version.equals(context.getVersion())) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean includeDependencyInLookupScope(ArtifactResult dep) {
            switch (this.lookupScope) {
                case COMPILE: {
                    return dep.moduleScope() == ModuleScope.COMPILE;
                }
                case RUNTIME: 
                case TEST: {
                    return dep.moduleScope() == ModuleScope.COMPILE || dep.moduleScope() == ModuleScope.RUNTIME;
                }
            }
            return false;
        }

        private void addDependency(ModuleGraph.Module from, ModuleGraph.Module to) {
            if (from != null) {
                from.addDependency(to);
            } else {
                this.moduleGraph.addRoot(to);
            }
        }

        public void cleanup() {
            if (this.moduleClassLoader != BaseModuleLoaderImpl.this.delegateClassLoader && this.moduleClassLoader instanceof URLClassLoader) {
                try {
                    ((URLClassLoader)this.moduleClassLoader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.moduleGraph.clear();
            this.moduleClassLoader = null;
        }

        public URL[] getClassLoaderURLs() {
            if (this.moduleClassLoader != BaseModuleLoaderImpl.this.delegateClassLoader && this.moduleClassLoader instanceof URLClassLoader) {
                return ((URLClassLoader)this.moduleClassLoader).getURLs();
            }
            return null;
        }
    }
}

