/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon.loader;

import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.Exclusion;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ModuleGraph {
    Set<Module> roots = new HashSet<Module>();
    private int count;

    public Module addRoot(String module, String version2) {
        Module mod = new Module(module, version2);
        this.roots.add(mod);
        ++this.count;
        return mod;
    }

    public Module addRoot(Module mod) {
        this.roots.add(mod);
        return mod;
    }

    public Module findModule(String module) {
        HashSet<String> visited = new HashSet<String>();
        return this.findModule(module, visited, this.roots);
    }

    private Module findModule(String module, Set<String> visited, Set<Module> modules) {
        for (Module mod : modules) {
            if (!visited.add(mod.name)) continue;
            if (mod.name.equals(module)) {
                return mod;
            }
            Module found = this.findModule(module, visited, mod.dependencies);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Module findModule(String module, String version2) {
        HashSet<Module> visited = new HashSet<Module>();
        return this.findModule(module, version2, visited, this.roots);
    }

    private Module findModule(String module, String version2, Set<Module> visited, Set<Module> modules) {
        for (Module mod : modules) {
            if (!visited.add(mod)) continue;
            if (mod.name.equals(module) && mod.version.equals(version2)) {
                return mod;
            }
            Module found = this.findModule(module, version2, visited, mod.dependencies);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void visit(Visitor visitor) {
        HashSet<Module> visited = new HashSet<Module>();
        this.visit(visitor, visited, this.roots);
    }

    private void visit(Visitor visitor, Set<Module> visited, Set<Module> modules) {
        for (Module mod : modules) {
            if (!visited.add(mod)) continue;
            visitor.visit(mod);
            this.visit(visitor, visited, mod.dependencies);
        }
    }

    public void checkForCycles(CycleListener cycleListener) {
        HashSet<Module> visited = new HashSet<Module>();
        LinkedList<Module> fromRoot = new LinkedList<Module>();
        this.checkForCycles(cycleListener, fromRoot, visited, this.roots);
    }

    private void checkForCycles(CycleListener cycleListener, LinkedList<Module> fromRoot, Set<Module> visited, Set<Module> modules) {
        for (Module mod : modules) {
            boolean cycle = fromRoot.contains(mod);
            fromRoot.addLast(mod);
            if (cycle) {
                cycleListener.cycleDetected(fromRoot);
            }
            if (visited.add(mod)) {
                this.checkForCycles(cycleListener, fromRoot, visited, mod.dependencies);
            }
            fromRoot.removeLast();
        }
    }

    public void clear() {
        this.roots.clear();
        this.count = 0;
    }

    public void pruneExclusions(final DependencySelector selector) {
        final HashSet exclusions = new HashSet();
        this.visit(new Visitor(){

            @Override
            public void visit(Module module) {
                if (module.artifact != null) {
                    for (ArtifactResult dep : module.artifact.dependencies()) {
                        if (!selector.selectDependency(dep) || dep.getExclusions() == null) continue;
                        exclusions.addAll(dep.getExclusions());
                    }
                }
            }
        });
        final LinkedList removedModules = new LinkedList();
        this.visit(new Visitor(){

            @Override
            public void visit(Module module) {
                if (module.artifact != null && selector.canExclude(module) && ModuleUtil.isMavenModule(module.name)) {
                    int sep = module.name.indexOf(58);
                    String groupId = module.name.substring(0, sep);
                    String artifactId = module.name.substring(sep + 1);
                    for (Exclusion exclusion : exclusions) {
                        if (!exclusion.getGroupId().equals(groupId) || !exclusion.getArtifactId().equals(artifactId)) continue;
                        removedModules.add(module);
                        break;
                    }
                }
            }
        });
        for (Module module : removedModules) {
            module.remove();
        }
    }

    public void dump() {
        this.dump(true);
    }

    public void dump(boolean printDuplicates) {
        HashSet<Module> visited = new HashSet<Module>();
        this.dump(0, visited, this.roots, printDuplicates);
    }

    private void dump(int level, Set<Module> visited, Set<Module> modules, boolean printDuplicates) {
        for (Module mod : modules) {
            boolean dupe;
            boolean bl = dupe = !visited.add(mod);
            if (!dupe || printDuplicates) {
                for (int i = 0; i < level; ++i) {
                    System.err.print("|    ");
                }
                System.err.print("+--- ");
                System.err.print(mod.name);
                System.err.print("/");
                System.err.print(mod.version);
            }
            if (dupe) {
                if (!printDuplicates) continue;
                System.err.println(" (*)");
                continue;
            }
            System.err.println();
            this.dump(level + 1, visited, mod.dependencies, printDuplicates);
        }
    }

    public int getCount() {
        return this.count;
    }

    public class Module {
        public final String name;
        public final String version;
        public final Set<Module> dependencies = new HashSet<Module>();
        public final Set<Module> dependents = new HashSet<Module>();
        public ArtifactResult artifact;
        public boolean inCurrentClassLoader;
        boolean replaced;

        public Module(String name, String version2) {
            this.name = name;
            this.version = version2;
        }

        public Module replace(Module replacement) {
            if (this.replaced) {
                return replacement;
            }
            this.replaced = true;
            for (Module dependent : this.dependents) {
                dependent.replaceDependency(this, replacement);
            }
            this.dependents.clear();
            ModuleGraph.this.roots.remove(this);
            for (Module dependency : this.dependencies) {
                dependency.dependents.remove(this);
            }
            this.dependencies.clear();
            ModuleGraph.this.count--;
            return replacement;
        }

        private void replaceDependency(Module from, Module to) {
            this.dependencies.remove(from);
            this.dependencies.add(to);
            to.dependents.add(this);
        }

        public String toString() {
            return this.name + "/" + this.version;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.name.hashCode();
            hash = hash * 31 + this.version.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Module)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Module other = (Module)obj;
            return this.name.equals(other.name) && this.version.equals(other.version);
        }

        public Module addDependency(String name, String version2) {
            Module mod = new Module(name, version2);
            this.dependencies.add(mod);
            mod.dependents.add(this);
            ModuleGraph.this.count++;
            return mod;
        }

        public Module addDependency(Module mod) {
            this.dependencies.add(mod);
            mod.dependents.add(this);
            return mod;
        }

        public void remove() {
            for (Module dependent : this.dependents) {
                dependent.dependencies.remove(this);
            }
            this.dependents.clear();
            ModuleGraph.this.roots.remove(this);
            for (Module dependency : this.dependencies) {
                dependency.dependents.remove(this);
            }
            this.dependencies.clear();
            ModuleGraph.this.count--;
        }
    }

    public static interface CycleListener {
        public void cycleDetected(List<Module> var1);
    }

    public static interface Visitor {
        public void visit(Module var1);
    }

    public static interface DependencySelector {
        public boolean selectDependency(ArtifactResult var1);

        public boolean canExclude(Module var1);
    }
}

