/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.PathFilterParser;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractArtifactResult;
import com.redhat.ceylon.cmr.impl.Configuration;
import com.redhat.ceylon.cmr.impl.LazyArtifactResult;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCeylonArtifactResult
extends AbstractArtifactResult {
    private RepositoryManager manager;
    private ModuleInfo infos;
    private boolean resolved = false;

    protected AbstractCeylonArtifactResult(Repository repository, RepositoryManager manager, String name, String version2) {
        super(repository, null, name, version2);
        this.manager = manager;
    }

    @Override
    public ArtifactResultType type() {
        return ArtifactResultType.CEYLON;
    }

    protected ModuleInfo resolve() {
        if (!this.resolved) {
            Overrides overrides = ((CmrRepository)this.repository()).getRoot().getService(Overrides.class);
            this.infos = Configuration.getResolvers(this.manager).resolve(this, overrides);
            this.resolved = true;
        }
        return this.infos;
    }

    protected RepositoryManager getManager() {
        return this.manager;
    }

    @Override
    public PathFilter filter() {
        ModuleInfo infos = this.resolve();
        if (infos == null || infos.getFilter() == null) {
            return null;
        }
        try {
            return PathFilterParser.parse(infos.getFilter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ArtifactResult> dependencies() throws RepositoryException {
        ModuleInfo infos = this.resolve();
        if (infos == null || infos.getDependencies().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>();
        for (ModuleDependencyInfo mi : this.getOrderedDependencies(infos)) {
            results.add(new LazyArtifactResult(this.manager, mi.getNamespace(), mi.getName(), mi.getVersion(), mi.isExport(), mi.isOptional(), mi.getModuleScope()));
        }
        return results;
    }

    private List<ModuleDependencyInfo> getOrderedDependencies(ModuleInfo infos) {
        ArrayList<ModuleDependencyInfo> dependencies = new ArrayList<ModuleDependencyInfo>(infos.getDependencies());
        for (int index = 0; index < dependencies.size(); ++index) {
            ModuleDependencyInfo dep = (ModuleDependencyInfo)dependencies.get(index);
            if (!"ceylon.language".equals(dep.getName())) continue;
            if (index == 0) break;
            dependencies.remove(index);
            dependencies.add(0, dep);
            break;
        }
        return dependencies;
    }

    @Override
    public String artifactId() {
        ModuleInfo info = this.resolve();
        if (info != null) {
            String groupId = info.getGroupId();
            String artifactId = info.getArtifactId();
            if (groupId != null && !groupId.isEmpty()) {
                if (artifactId != null && !artifactId.isEmpty()) {
                    return artifactId;
                }
                return this.name();
            }
        }
        return ModuleUtil.getMavenCoordinates(this.name())[1];
    }

    @Override
    public String groupId() {
        String groupId;
        ModuleInfo info = this.resolve();
        if (info != null && (groupId = info.getGroupId()) != null && !groupId.isEmpty()) {
            return groupId;
        }
        return ModuleUtil.getMavenCoordinates(this.name())[0];
    }
}

