/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.impl.AbstractOpenNode;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class DefaultNode
extends AbstractOpenNode {
    private static final long serialVersionUID = 1L;
    private transient ContentHandle handle;
    private boolean remote = false;

    public DefaultNode() {
    }

    public DefaultNode(String label) {
        super(label, null);
    }

    public DefaultNode(String label, Object value) {
        super(label, value);
    }

    public void setContentMarker() {
        this.setHandle(HANDLE_MARKER);
    }

    public synchronized void setHandle(ContentHandle handle) {
        this.handle = handle;
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    void setRemote(boolean remote) {
        this.remote = remote;
    }

    @Override
    public void merge(OpenNode other) {
        if (other == null) {
            throw new IllegalArgumentException("Null node!");
        }
    }

    @Override
    public OpenNode addNode(String label, Object value) {
        try {
            return this.addNode(label, value, null, ContentOptions.DEFAULT, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Should not be here!", e);
        }
    }

    @Override
    public Node removeNode(String label) {
        Node node = super.removeNode(label);
        if (node instanceof DefaultNode) {
            DefaultNode dn = (DefaultNode)node;
            ContentHandle ch = dn.handle;
            dn.handle = null;
            if (ch != null) {
                ch.clean();
            }
        }
        return node;
    }

    @Override
    public OpenNode addContent(String label, InputStream content, ContentOptions options) throws IOException {
        return this.addNode(label, null, content, options, false);
    }

    @Override
    public <T extends Serializable> OpenNode addContent(String label, T content, ContentOptions options) throws IOException {
        try (InputStream stream = IOUtils.toObjectStream(content);){
            OpenNode openNode = this.addContent(label, stream, options);
            return openNode;
        }
    }

    protected OpenNode addNode(String label, Object value, InputStream content, ContentOptions options, boolean allowNoContent) throws IOException {
        if (label == null) {
            throw new IllegalArgumentException("Null label");
        }
        if (content == null && !allowNoContent) {
            throw new IllegalArgumentException("Null content not allowed: " + label);
        }
        DefaultNode node = new DefaultNode(label, value);
        OpenNode previous = this.putChildIfAbsent(label, node);
        if (previous == null) {
            previous = node;
            node.putParentIfAbsent(this.getLabel(), this);
            if (content != null) {
                ContentStore contentStore = this.findService(ContentStore.class);
                node.handle = contentStore.putContent(node, content, options);
            }
        } else if (content != null) {
            if (options.forceOperation()) {
                ContentStore contentStore = this.findService(ContentStore.class);
                ContentHandle ch = contentStore.putContent(previous, content, options);
                if (previous instanceof DefaultNode) {
                    DefaultNode dn = (DefaultNode)previous;
                    dn.handle = ch;
                }
            } else {
                throw new IllegalArgumentException("Content node already exists: " + label);
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasBinaries() {
        DefaultNode defaultNode = this;
        synchronized (defaultNode) {
            if (this.handle != null) {
                return this.handle.hasBinaries();
            }
        }
        ContentStore cs = this.findService(ContentStore.class);
        ContentHandle ch = cs.peekContent(this);
        DefaultNode defaultNode2 = this;
        synchronized (defaultNode2) {
            this.handle = ch == null ? HANDLE_MARKER : ch;
        }
        return ch != null && ch.hasBinaries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getContent(Class<T> contentType) throws IOException {
        if (File.class.equals(contentType)) {
            DefaultNode defaultNode = this;
            synchronized (defaultNode) {
                if (this.handle != null) {
                    return (T)this.handle.getContentAsFile();
                }
            }
            ContentStore cs = this.findService(ContentStore.class);
            ContentHandle ch = cs.getContent(this);
            if (ch == null) {
                ch = HANDLE_MARKER;
            }
            DefaultNode defaultNode2 = this;
            synchronized (defaultNode2) {
                this.handle = ch;
            }
            return (T)ch.getContentAsFile();
        }
        return super.getContent(contentType);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        SizedInputStream sizedInputStream = this.getSizedInputStream();
        return sizedInputStream != null ? sizedInputStream.getInputStream() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SizedInputStream getSizedInputStream() throws IOException {
        DefaultNode defaultNode = this;
        synchronized (defaultNode) {
            if (this.handle != null) {
                return this.handle.getBinariesAsSizedStream();
            }
        }
        ContentStore cs = this.findService(ContentStore.class);
        ContentHandle ch = cs.getContent(this);
        if (ch == null) {
            ch = HANDLE_MARKER;
        }
        DefaultNode defaultNode2 = this;
        synchronized (defaultNode2) {
            this.handle = ch;
        }
        return ch.getBinariesAsSizedStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastModified() throws IOException {
        DefaultNode defaultNode = this;
        synchronized (defaultNode) {
            if (this.handle != null) {
                return this.handle.getLastModified();
            }
        }
        ContentStore cs = this.findService(ContentStore.class);
        ContentHandle ch = cs.getContent(this);
        if (ch == null) {
            ch = HANDLE_MARKER;
        }
        DefaultNode defaultNode2 = this;
        synchronized (defaultNode2) {
            this.handle = ch;
        }
        return ch.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() throws IOException {
        DefaultNode defaultNode = this;
        synchronized (defaultNode) {
            if (this.handle != null) {
                return this.handle.getSize();
            }
        }
        ContentStore cs = this.findService(ContentStore.class);
        ContentHandle ch = cs.getContent(this);
        if (ch == null) {
            ch = HANDLE_MARKER;
        }
        DefaultNode defaultNode2 = this;
        synchronized (defaultNode2) {
            this.handle = ch;
        }
        return ch.getSize();
    }

    @Override
    public String getStoreDisplayString() {
        ContentStore cs = this.findService(ContentStore.class);
        return cs.getDisplayString();
    }

    @Override
    public String getDisplayString() {
        return this.getLabel();
    }
}

