/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ContentFinderDelegate;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractRepository;
import com.redhat.ceylon.cmr.impl.DefaultNode;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.JdkProvider;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class JDKRepository
extends AbstractRepository {
    public static final String JDK_REPOSITORY_DISPLAY_STRING = "JDK modules repository";
    public static final String NAMESPACE = "jdk";
    private static final String JAVA_ORIGIN = "Java Runtime";
    private JdkProvider jdkProvider = new JdkProvider();

    public JDKRepository() {
        super(new JDKRoot());
        ((JDKRoot)this.getRoot()).finishSetupYouDumbass(this.jdkProvider);
    }

    @Override
    protected ArtifactResult getArtifactResultInternal(RepositoryManager manager, Node node) {
        return null;
    }

    @Override
    public Node findParent(ArtifactContext context) {
        return null;
    }

    @Override
    public OpenNode createParent(ArtifactContext context) {
        return null;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public static class JDKRoot
    extends DefaultNode
    implements ContentFinderDelegate {
        private JdkProvider jdkProvider;
        private SortedSet<String> sortedModuleNames;

        public JDKRoot() {
            this.addService(ContentFinderDelegate.class, this);
        }

        private void finishSetupYouDumbass(JdkProvider jdkProvider) {
            this.jdkProvider = jdkProvider;
            this.sortedModuleNames = new TreeSet<String>();
            this.sortedModuleNames.addAll(jdkProvider.getJDKModuleNames());
        }

        @Override
        public String getDisplayString() {
            return JDKRepository.JDK_REPOSITORY_DISPLAY_STRING;
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public void completeModules(ModuleQuery query, ModuleSearchResult result, Overrides overrides) {
            if (!query.getType().includes(".jar")) {
                return;
            }
            if (query.getMemberName() != null && !query.isMemberSearchPackageOnly()) {
                return;
            }
            String name = query.getName();
            if (name == null) {
                name = "";
            }
            for (String module : this.sortedModuleNames) {
                ModuleVersionDetails mvd;
                if (!module.startsWith(name) || (mvd = this.getResult(module, query)) == null) continue;
                result.addResult(module, mvd);
            }
        }

        private String doc(String module) {
            return "JDK module " + module;
        }

        @Override
        public void completeVersions(ModuleVersionQuery query, ModuleVersionResult result, Overrides overrides) {
            if (!query.getType().includes(".jar")) {
                return;
            }
            if (query.getName() == null || !this.jdkProvider.isJDKModule(query.getName())) {
                return;
            }
            String jdkVersion = this.jdkProvider.getJDKVersion();
            if (query.getVersion() != null && !query.getVersion().equals(jdkVersion)) {
                return;
            }
            ModuleVersionDetails newVersion = result.addVersion(JDKRepository.NAMESPACE, query.getName(), jdkVersion);
            newVersion.setDoc(this.doc(query.getName()));
            newVersion.getArtifactTypes().add(new ModuleVersionArtifact(".jar", null, null));
            newVersion.setVersion(jdkVersion);
            newVersion.setRemote(false);
            newVersion.setOrigin(JDKRepository.JAVA_ORIGIN);
        }

        @Override
        public void searchModules(ModuleQuery query, ModuleSearchResult result, Overrides overrides) {
            if (!query.getType().includes(".jar")) {
                return;
            }
            if (query.getMemberName() != null && !query.isMemberSearchPackageOnly()) {
                return;
            }
            String name = query.getName();
            if (name == null) {
                name = "";
            }
            name = name.toLowerCase();
            boolean stopSearching = false;
            int found = 0;
            for (String module : this.sortedModuleNames) {
                if (!module.contains(name)) continue;
                if (stopSearching) {
                    result.setHasMoreResults(true);
                    return;
                }
                ModuleVersionDetails mvd = this.getResult(module, query);
                if (mvd == null || query.getStart() != null && (long)found++ < query.getStart()) continue;
                result.addResult(module, mvd);
                if (query.getStart() == null || query.getCount() == null || (long)found < query.getStart() + query.getCount()) continue;
                stopSearching = true;
            }
        }

        private ModuleVersionDetails getResult(String module, ModuleQuery query) {
            ModuleVersionDetails mvd = new ModuleVersionDetails(JDKRepository.NAMESPACE, module, this.jdkProvider.getJDKVersion(), null, null);
            mvd.setDoc(this.doc(module));
            mvd.getArtifactTypes().add(new ModuleVersionArtifact(".jar", null, null));
            mvd.setRemote(false);
            mvd.setOrigin(JDKRepository.JAVA_ORIGIN);
            if (query.getMemberName() != null) {
                Set<String> jdkMembers = this.jdkProvider.getJDKPackages(module);
                if (jdkMembers == null) {
                    return null;
                }
                Set<String> matchedMembers = AbstractRepository.matchNames(jdkMembers, query, true);
                if (matchedMembers.isEmpty()) {
                    return null;
                }
                mvd.setMembers(matchedMembers);
            }
            return mvd;
        }
    }
}

