/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.lang.reflect.Method;

public class MavenRepositoryBuilder
implements RepositoryBuilder {
    @Override
    public String absolute(File cwd, String token) {
        if (token.equals("aether") || token.equals("aether:") || token.equals("aether:/#") || token.equals("mvn") || token.equals("mvn:") || token.equals("mvn:/#") || token.equals("maven") || token.equals("maven:") || token.equals("maven:/#")) {
            return token;
        }
        if (token.startsWith("aether:")) {
            return this.absolute(cwd, token, "aether:");
        }
        if (token.startsWith("mvn:")) {
            return this.absolute(cwd, token, "mvn:");
        }
        if (token.startsWith("maven:")) {
            return this.absolute(cwd, token, "maven:");
        }
        return null;
    }

    private String absolute(File cwd, String token, String prefix) {
        token = token.substring(prefix.length());
        File f = FileUtil.absoluteFile(FileUtil.applyCwd(cwd, new File(token)));
        token = f.getAbsolutePath();
        return prefix + token;
    }

    @Override
    public CmrRepository[] buildRepository(String token) throws Exception {
        return this.buildRepository(token, EMPTY_CONFIG);
    }

    @Override
    public CmrRepository[] buildRepository(String token, RepositoryBuilder.RepositoryBuilderConfig config) throws Exception {
        if (token.equals("aether") || token.equals("aether:") || token.equals("aether:/#") || token.equals("mvn") || token.equals("mvn:") || token.equals("mvn:/#") || token.equals("maven") || token.equals("maven:") || token.equals("maven:/#")) {
            return this.createMavenRepository(token, null, config);
        }
        if (token.startsWith("aether:")) {
            return this.createMavenRepository(token, "aether:", config);
        }
        if (token.startsWith("mvn:")) {
            return this.createMavenRepository(token, "mvn:", config);
        }
        if (token.startsWith("maven:")) {
            return this.createMavenRepository(token, "maven:", config);
        }
        return null;
    }

    private CmrRepository[] createMavenRepository(String token, String prefix, RepositoryBuilder.RepositoryBuilderConfig config) throws Exception {
        String settingsXml = null;
        if (prefix != null) {
            String settings = token.substring(prefix.length());
            int p = settings.indexOf("|");
            settingsXml = p < 0 ? settings : settings.substring(0, p);
        }
        Class<?> aetherRepositoryClass = Class.forName("com.redhat.ceylon.cmr.maven.AetherRepository");
        Method createRepository = aetherRepositoryClass.getMethod("createRepository", Logger.class, String.class, Boolean.TYPE, Integer.TYPE, String.class);
        CmrRepository repo = (CmrRepository)createRepository.invoke(null, config.log, settingsXml, config.offline, config.timeout, config.currentDirectory);
        return new CmrRepository[]{repo};
    }
}

