/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.ModulesDependencyResolver;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;

public final class PropertiesDependencyResolver
extends ModulesDependencyResolver {
    public static final PropertiesDependencyResolver INSTANCE = new PropertiesDependencyResolver();

    private PropertiesDependencyResolver() {
        super("module.properties");
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String moduleName, String moduleVersion, Overrides overrides) {
        try {
            Properties properties = new Properties();
            properties.load(stream);
            LinkedHashSet<ModuleDependencyInfo> infos = new LinkedHashSet<ModuleDependencyInfo>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String depUri = entry.getKey().toString();
                String version2 = entry.getValue().toString();
                boolean optional = false;
                boolean shared = false;
                if (depUri.startsWith("+")) {
                    depUri = depUri.substring(1);
                    shared = true;
                }
                if (depUri.endsWith("?")) {
                    depUri = depUri.substring(0, depUri.length() - 1);
                    optional = true;
                }
                String namespace = ModuleUtil.getNamespaceFromUri(depUri);
                String modName = ModuleUtil.getModuleNameFromUri(depUri);
                infos.add(new ModuleDependencyInfo(namespace, modName, version2, optional, shared, Backends.JAVA));
            }
            ModuleInfo ret = new ModuleInfo(moduleName, moduleVersion, ModuleUtil.getMavenGroupIdIfMavenModule(moduleName), ModuleUtil.getMavenArtifactIdIfMavenModule(moduleName), null, infos);
            if (overrides != null) {
                ret = overrides.applyOverrides(moduleName, moduleVersion, ret);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

