/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.SourceArtifactCreator;
import com.redhat.ceylon.cmr.api.SourceStream;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class SourceArtifactCreatorImpl
implements SourceArtifactCreator {
    private final ArtifactContext srcContext;
    private final RepositoryManager repoManager;
    private File originalSrcFile;
    private boolean verbose;
    private Logger log;
    private final Iterable<? extends File> sourcePaths;

    public SourceArtifactCreatorImpl(RepositoryManager repoManager, Iterable<? extends File> sourcePaths, String moduleName, String moduleVersion, boolean verbose, Logger log) throws IOException {
        this.repoManager = repoManager;
        this.verbose = verbose;
        this.log = log;
        this.sourcePaths = sourcePaths;
        this.srcContext = new ArtifactContext(null, moduleName, moduleVersion, ".src");
        this.originalSrcFile = repoManager.getArtifact(this.srcContext);
    }

    private void setupSrcOutput() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> copyStreams(Collection<SourceStream> sourceStreams) throws IOException {
        final HashSet<String> copiedFiles = new HashSet<String>();
        File outputSrcFile = File.createTempFile("ceylon-", ".src");
        try (JarOutputStream srcOutputStream = new JarOutputStream(new FileOutputStream(outputSrcFile));){
            HashSet<SourceStream> uniqueSources = new HashSet<SourceStream>(sourceStreams);
            HashSet<String> folders = new HashSet<String>();
            for (SourceStream sourceStream : uniqueSources) {
                String sourceFile = sourceStream.getSourceRelativePath();
                if (copiedFiles.contains(sourceFile)) continue;
                srcOutputStream.putNextEntry(new ZipEntry(sourceFile));
                try (InputStream inputStream = sourceStream.getInputStream();){
                    JarUtils.copy(inputStream, srcOutputStream);
                }
                finally {
                    srcOutputStream.closeEntry();
                }
                copiedFiles.add(sourceFile);
                String folder = JarUtils.getFolder(sourceFile);
                if (folder == null) continue;
                folders.add(folder);
            }
            JarUtils.finishUpdatingJar(this.originalSrcFile, outputSrcFile, this.srcContext, srcOutputStream, new JarUtils.JarEntryFilter(){

                @Override
                public boolean avoid(String entryFullName) {
                    return copiedFiles.contains(entryFullName);
                }
            }, this.repoManager, this.verbose, this.log, folders);
        }
        finally {
            FileUtil.deleteQuietly(outputSrcFile);
        }
        return copiedFiles;
    }

    @Override
    public Set<String> copy(Collection<String> sources) throws IOException {
        ArrayList<SourceStream> sourceStreams = new ArrayList<SourceStream>(sources.size());
        for (final String prefixedSourceFile : sources) {
            sourceStreams.add(new SourceStream(){

                @Override
                public String getSourceRelativePath() {
                    return JarUtils.toPlatformIndependentPath(SourceArtifactCreatorImpl.this.sourcePaths, prefixedSourceFile);
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(prefixedSourceFile);
                }

                public boolean equals(Object obj) {
                    return prefixedSourceFile.equals(obj);
                }

                @Override
                public int hashCode() {
                    return prefixedSourceFile.hashCode();
                }
            });
        }
        return this.copyStreams(sourceStreams);
    }

    @Override
    public Iterable<? extends File> getPaths() {
        return this.sourcePaths;
    }
}

