/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.impl.AbstractContentStore;
import com.redhat.ceylon.cmr.impl.DefaultNode;
import com.redhat.ceylon.cmr.impl.RootNode;
import com.redhat.ceylon.cmr.maven.AetherUtils;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;

public class AetherContentStore
extends AbstractContentStore {
    private final AetherUtils utils;

    public AetherContentStore(Logger log, String settingsXml, boolean offline, int timeout, String currentDirectory) {
        super(log, offline, timeout);
        this.utils = new AetherUtils(log, settingsXml, offline, timeout, currentDirectory);
    }

    AetherUtils getUtils() {
        return this.utils;
    }

    @Override
    public Iterable<File> getBaseDirectories() {
        return Arrays.asList(this.utils.getLocalRepositoryBaseDir());
    }

    @Override
    public OpenNode createRoot() {
        return new RootNode(this, this);
    }

    @Override
    public OpenNode find(Node parent, String child) {
        DefaultNode node = null;
        if (!this.hasContent(child)) {
            node = new DefaultNode(child);
            node.setContentMarker();
        } else {
            File dependency = this.utils.findDependency(parent);
            if (dependency != null) {
                node = new DefaultNode(child);
                node.setHandle(new FileContentHandle(dependency));
            }
        }
        return node;
    }

    @Override
    public ContentHandle peekContent(Node node) {
        File dependency = this.utils.findDependency(node);
        return dependency != null ? new FileContentHandle(dependency) : null;
    }

    @Override
    public ContentHandle getContent(Node node) throws IOException {
        return new AetherContentHandle(node);
    }

    @Override
    public ContentHandle putContent(Node node, InputStream stream, ContentOptions options) throws IOException {
        return null;
    }

    @Override
    public OpenNode create(Node parent, String child) {
        return null;
    }

    @Override
    public Iterable<? extends OpenNode> find(Node parent) {
        return Collections.emptyList();
    }

    @Override
    public String getDisplayString() {
        String name = "Aether";
        if (this.offline) {
            name = name + " (offline)";
        }
        return name;
    }

    @Override
    public boolean isHerd() {
        return false;
    }

    @Override
    public boolean canHandleFolders() {
        return false;
    }

    private class AetherContentHandle
    implements ContentHandle {
        private Node node;

        private AetherContentHandle(Node node) {
            this.node = node;
        }

        @Override
        public boolean hasBinaries() {
            return true;
        }

        @Override
        public InputStream getBinariesAsStream() throws IOException {
            return new FileInputStream(this.getContentAsFile());
        }

        @Override
        public SizedInputStream getBinariesAsSizedStream() throws IOException {
            File file = this.getContentAsFile();
            return new SizedInputStream(new FileInputStream(file), file.length());
        }

        @Override
        public File getContentAsFile() throws IOException {
            ArtifactContext ac = ArtifactContext.fromNode(this.node);
            if (ac == null) {
                throw new IOException("Missing artifact context info!");
            }
            return AetherContentStore.this.utils.findDependency(this.node);
        }

        @Override
        public long getLastModified() throws IOException {
            return this.getContentAsFile().lastModified();
        }

        @Override
        public long getSize() throws IOException {
            return this.getContentAsFile().length();
        }

        @Override
        public void clean() {
        }
    }

    private static class FileContentHandle
    implements ContentHandle {
        private final File file;

        private FileContentHandle(File file) {
            this.file = file;
        }

        @Override
        public boolean hasBinaries() {
            return true;
        }

        @Override
        public InputStream getBinariesAsStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public SizedInputStream getBinariesAsSizedStream() throws IOException {
            return new SizedInputStream(this.getBinariesAsStream(), this.file.length());
        }

        @Override
        public File getContentAsFile() throws IOException {
            return this.file;
        }

        @Override
        public long getLastModified() throws IOException {
            return this.file.lastModified();
        }

        @Override
        public long getSize() throws IOException {
            return this.file.length();
        }

        @Override
        public void clean() {
        }
    }
}

