/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactOverrides;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.DependencyOverride;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.PathFilterParser;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.AbstractArtifactResult;
import com.redhat.ceylon.cmr.impl.LazyArtifactResult;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.maven.MavenUtils;
import com.redhat.ceylon.cmr.resolver.aether.AetherException;
import com.redhat.ceylon.cmr.resolver.aether.AetherResolver;
import com.redhat.ceylon.cmr.resolver.aether.AetherResolverImpl;
import com.redhat.ceylon.cmr.resolver.aether.DependencyDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.ExclusionDescriptor;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.Exclusion;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class AetherUtils {
    private Logger log;
    private AetherResolver impl;

    AetherUtils(Logger log, String settingsXml, boolean offline, int timeout, String currentDirectory) {
        this.log = log;
        if (settingsXml == null) {
            settingsXml = MavenUtils.getDefaultMavenSettings();
        }
        this.impl = new AetherResolverImpl(currentDirectory, settingsXml, offline, timeout);
    }

    File findDependency(Node node) {
        ArtifactResult result = this.findDependencies(null, node, true);
        return result != null ? result.artifact() : null;
    }

    public File getLocalRepositoryBaseDir() {
        return this.impl.getLocalRepositoryBaseDir();
    }

    ArtifactResult findDependencies(RepositoryManager manager, Node node) {
        return this.findDependencies(manager, node, null);
    }

    String[] nameToGroupArtifactIds(String name) {
        int p = name.lastIndexOf(":");
        if (p == -1) {
            return null;
        }
        String groupId = name.substring(0, p);
        String artifactId = name.substring(p + 1);
        return new String[]{groupId, artifactId};
    }

    private ArtifactResult findDependencies(RepositoryManager manager, Node node, Boolean fetchSingleArtifact) {
        ArtifactContext ac = ArtifactContext.fromNode(node);
        if (ac == null) {
            return null;
        }
        String name = ac.getName();
        String[] groupArtifactIds = this.nameToGroupArtifactIds(name);
        if (groupArtifactIds == null) {
            return null;
        }
        String groupId = groupArtifactIds[0];
        String artifactId = groupArtifactIds[1];
        String version2 = ac.getVersion();
        String repositoryDisplayString = NodeUtils.getRepositoryDisplayString(node);
        CmrRepository repository = NodeUtils.getRepository(node);
        if (CeylonUtils.arrayContains(ac.getSuffixes(), "-sources.jar")) {
            return this.fetchWithClassifier(repository, groupId, artifactId, version2, "sources", repositoryDisplayString);
        }
        return this.fetchDependencies(manager, repository, groupId, artifactId, version2, fetchSingleArtifact != null ? fetchSingleArtifact.booleanValue() : ac.isIgnoreDependencies(), repositoryDisplayString);
    }

    private ArtifactResult fetchDependencies(RepositoryManager manager, CmrRepository repository, String groupId, String artifactId, String version2, boolean fetchSingleArtifact, String repositoryDisplayString) {
        String classifier = null;
        Overrides overrides = repository.getRoot().getService(Overrides.class);
        ArtifactOverrides ao = null;
        this.log.debug("Overrides: " + overrides);
        ArtifactContext context = this.getArtifactContext(groupId, artifactId, version2, null, null);
        if (overrides != null) {
            ao = overrides.getArtifactOverrides(context);
            this.log.debug(" [" + context + "] => " + ao);
        }
        ArtifactContext replacementContext = null;
        if (ao != null && ao.getReplace() != null) {
            replacementContext = ao.getReplace().getArtifactContext();
        } else if (overrides != null) {
            replacementContext = overrides.replace(context);
        }
        if (replacementContext != null) {
            this.log.debug(String.format("[Maven-Overrides] Replacing %s with %s.", context, replacementContext));
            String[] nameToGroupArtifactIds = this.nameToGroupArtifactIds(replacementContext.getName());
            if (nameToGroupArtifactIds != null) {
                groupId = nameToGroupArtifactIds[0];
                artifactId = nameToGroupArtifactIds[1];
                version2 = replacementContext.getVersion();
                context = this.getArtifactContext(groupId, artifactId, version2, null, null);
                ao = overrides.getArtifactOverrides(context);
            }
        }
        if (overrides != null && overrides.isVersionOverridden(context)) {
            version2 = overrides.getVersionOverride(context);
            context.setVersion(version2);
        }
        if (ao != null && ao.hasClassifier()) {
            classifier = ao.getClassifier();
            this.log.debug("Using classifier " + classifier);
        }
        String name = AetherUtils.toCanonicalForm(groupId, artifactId);
        String coordinates = AetherUtils.toCanonicalForm(name, version2);
        try {
            SingleArtifactResult result;
            DependencyDescriptor info = this.impl.getDependencies(groupId, artifactId, version2, classifier, null, fetchSingleArtifact);
            if (info == null) {
                this.log.debug("No artifact found: " + coordinates);
                return null;
            }
            if (fetchSingleArtifact) {
                result = new SingleArtifactResult(repository, name, version2, groupId, artifactId, info.getFile(), repositoryDisplayString);
            } else {
                ArrayList<ArtifactResult> dependencies = new ArrayList<ArtifactResult>();
                for (DependencyDescriptor dep : info.getDependencies()) {
                    String dGroupId = dep.getGroupId();
                    String dArtifactId = dep.getArtifactId();
                    String dVersion = dep.getVersion();
                    boolean export = false;
                    boolean optional = dep.isOptional();
                    boolean isCeylon = false;
                    ModuleScope scope = AetherUtils.toModuleScope(dep);
                    ArtifactContext dContext = null;
                    if (overrides != null) {
                        dContext = this.getArtifactContext(dGroupId, dArtifactId, dVersion, null, null);
                    }
                    if (overrides != null) {
                        if (overrides.isRemoved(dContext) || ao != null && ao.isRemoved(dContext)) {
                            this.log.debug(String.format("[Maven-Overrides] Removing %s from %s.", dep, context));
                            continue;
                        }
                        if (ao != null && ao.isAddedOrUpdated(dContext)) {
                            this.log.debug(String.format("[Maven-Overrides] Replacing %s from %s.", dep, context));
                            continue;
                        }
                        ArtifactContext replace = overrides.replace(dContext);
                        if (replace != null) {
                            dContext = replace;
                            String[] groupArtifactIds = this.nameToGroupArtifactIds(replace.getName());
                            if (groupArtifactIds == null) {
                                isCeylon = true;
                            } else {
                                dGroupId = groupArtifactIds[0];
                                dArtifactId = groupArtifactIds[1];
                            }
                            dVersion = replace.getVersion();
                        }
                        if (ao != null) {
                            if (ao.isShareOverridden(dContext)) {
                                export = ao.isShared(dContext);
                            }
                            if (ao.isOptionalOverridden(dContext)) {
                                optional = ao.isOptional(dContext);
                            }
                        }
                    }
                    if (overrides != null && overrides.isVersionOverridden(dContext)) {
                        dVersion = overrides.getVersionOverride(dContext);
                    }
                    ArtifactResult dr = isCeylon ? this.createArtifactResult(manager, dContext.getName(), dVersion, dGroupId, dArtifactId, export, optional, scope, repositoryDisplayString) : this.createArtifactResult(manager, repository, dGroupId, dArtifactId, dVersion, export, optional, scope, repositoryDisplayString, dep.getExclusions());
                    dependencies.add(dr);
                }
                if (ao != null) {
                    for (DependencyOverride addon : ao.getAdd()) {
                        ArtifactContext dContext = addon.getArtifactContext();
                        String dVersion = overrides.getVersionOverride(dContext);
                        dependencies.add(this.createArtifactResult(manager, repository, dContext, dVersion, addon.isShared(), addon.isOptional(), ModuleScope.COMPILE, repositoryDisplayString, null));
                        this.log.debug(String.format("[Maven-Overrides] Added %s to %s.", addon.getArtifactContext(), context));
                    }
                }
                result = new AetherArtifactResult(repository, name, version2, groupId, artifactId, info.getFile(), dependencies, repositoryDisplayString);
            }
            if (ao != null && ao.getFilter() != null) {
                result.setFilter(PathFilterParser.parse(ao.getFilter()));
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (AetherException e) {
            this.log.debug("Could not resolve artifact [" + coordinates + "] : " + e);
            return null;
        }
    }

    public static ModuleScope toModuleScope(DependencyDescriptor dep) {
        if (dep.isRuntimeScope()) {
            return ModuleScope.RUNTIME;
        }
        if (dep.isTestScope()) {
            return ModuleScope.TEST;
        }
        if (dep.isProvidedScope()) {
            return ModuleScope.PROVIDED;
        }
        return ModuleScope.COMPILE;
    }

    public void search(String groupId, String artifactId, String version2, boolean exactVersionMatch, ModuleVersionResult result, Overrides overrides, String repositoryDisplayString) {
        try {
            if (version2 == null || version2.isEmpty()) {
                List<String> versions = this.impl.resolveVersionRange(groupId, artifactId, "(,)");
                for (String resolvedVersion : versions) {
                    if (resolvedVersion == null || resolvedVersion.isEmpty()) continue;
                    this.addSearchResult(groupId, artifactId, resolvedVersion, result, overrides, repositoryDisplayString);
                }
            } else if (exactVersionMatch) {
                this.addSearchResult(groupId, artifactId, version2, result, overrides, repositoryDisplayString);
            } else {
                List<String> versions = this.impl.resolveVersionRange(groupId, artifactId, "[" + version2 + ",]");
                for (String resolvedVersion : versions) {
                    if (resolvedVersion == null || !resolvedVersion.startsWith(version2)) continue;
                    this.addSearchResult(groupId, artifactId, resolvedVersion, result, overrides, repositoryDisplayString);
                }
            }
        }
        catch (AetherException e) {
            this.log.debug("Could not search for artifact versions [" + groupId + ":" + artifactId + ":" + version2 + "] : " + e);
        }
    }

    private void addSearchResult(String groupId, String artifactId, String version2, ModuleVersionResult result, Overrides overrides, String repositoryDisplayString) throws AetherException {
        DependencyDescriptor info;
        ArtifactOverrides artifactOverrides = null;
        if (overrides != null) {
            ArtifactContext ctx = new ArtifactContext("maven", groupId + ":" + artifactId, version2);
            ArtifactContext replaceContext = overrides.replace(ctx);
            if (replaceContext != null) {
                String[] groupArtifactIds = this.nameToGroupArtifactIds(replaceContext.getName());
                if (groupArtifactIds == null) {
                    return;
                }
                groupId = groupArtifactIds[0];
                artifactId = groupArtifactIds[1];
                version2 = replaceContext.getVersion();
                ctx = replaceContext;
            } else if (overrides.isVersionOverridden(ctx)) {
                version2 = overrides.getVersionOverride(ctx);
                ctx.setVersion(version2);
            }
            artifactOverrides = overrides.getArtifactOverrides(ctx);
        }
        if ((info = this.impl.getDependencies(groupId, artifactId, version2, null, "pom", false)) != null) {
            StringBuilder description = new StringBuilder();
            StringBuilder licenseBuilder = new StringBuilder();
            this.collectInfo(info, description, licenseBuilder);
            HashSet<ModuleDependencyInfo> dependencies = new HashSet<ModuleDependencyInfo>();
            HashSet<ModuleVersionArtifact> artifactTypes = new HashSet<ModuleVersionArtifact>();
            artifactTypes.add(new ModuleVersionArtifact(".jar", null, null));
            HashSet<String> authors = new HashSet<String>();
            for (DependencyDescriptor dep : info.getDependencies()) {
                String namespace = "maven";
                String depGroupId = dep.getGroupId();
                String depArtifactId = dep.getArtifactId();
                String depName = dep.getGroupId() + ":" + dep.getArtifactId();
                String depVersion = dep.getVersion();
                boolean export = false;
                boolean optional = dep.isOptional();
                if (overrides != null) {
                    ArtifactContext depCtx = new ArtifactContext(namespace, depName, dep.getVersion());
                    if (overrides.isRemoved(depCtx) || artifactOverrides != null && (artifactOverrides.isRemoved(depCtx) || artifactOverrides.isAddedOrUpdated(depCtx))) continue;
                    ArtifactContext replaceCtx = overrides.replace(depCtx);
                    if (replaceCtx != null) {
                        depCtx = replaceCtx;
                        namespace = replaceCtx.getNamespace();
                        depName = replaceCtx.getName();
                    }
                    if (overrides.isVersionOverridden(depCtx)) {
                        depVersion = overrides.getVersionOverride(depCtx);
                    }
                    if (artifactOverrides != null) {
                        if (artifactOverrides.isShareOverridden(depCtx)) {
                            export = artifactOverrides.isShared(depCtx);
                        }
                        if (artifactOverrides.isOptionalOverridden(depCtx)) {
                            optional = artifactOverrides.isOptional(depCtx);
                        }
                    }
                }
                ModuleDependencyInfo moduleDependencyInfo = new ModuleDependencyInfo(namespace, depName, depVersion, optional, export, Backends.JAVA, AetherUtils.toModuleScope(dep));
                dependencies.add(moduleDependencyInfo);
            }
            if (artifactOverrides != null) {
                for (DependencyOverride add : artifactOverrides.getAdd()) {
                    ArtifactContext ac = add.getArtifactContext();
                    ModuleDependencyInfo moduleDependencyInfo = new ModuleDependencyInfo(ac.getNamespace(), ac.getName(), ac.getVersion(), add.isOptional(), add.isShared(), Backends.JAVA, ModuleScope.COMPILE);
                    dependencies.add(moduleDependencyInfo);
                }
            }
            ModuleVersionDetails moduleVersionDetails = new ModuleVersionDetails("maven", groupId + ":" + artifactId, version2, groupId, artifactId, description.length() > 0 ? description.toString() : null, licenseBuilder.length() > 0 ? licenseBuilder.toString() : null, authors, dependencies, artifactTypes, true, repositoryDisplayString);
            result.addVersion(moduleVersionDetails);
        }
    }

    private void collectInfo(DependencyDescriptor info, StringBuilder description, StringBuilder licenseBuilder) {
        File pomFile = info.getFile();
        if (pomFile != null && pomFile.exists()) {
            try (FileInputStream is = new FileInputStream(pomFile);){
                Element license;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(is);
                doc.getDocumentElement().normalize();
                Element root = doc.getDocumentElement();
                MavenUtils.collectText(root, description, "name", "description", "url");
                Element licenses = MavenUtils.getFirstElement(root, "licenses");
                if (licenses != null && (license = MavenUtils.getFirstElement(licenses, "license")) != null) {
                    MavenUtils.collectText(license, licenseBuilder, "name", "url");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    private ArtifactContext getArtifactContext(String groupId, String artifactId, String version2, String packaging, String classifier) {
        if (classifier != null && classifier.isEmpty()) {
            classifier = null;
        }
        return Overrides.createMavenArtifactContext(groupId, artifactId, version2, packaging, classifier);
    }

    protected ArtifactResult createArtifactResult(RepositoryManager manager, CmrRepository repository, ArtifactContext dCo, String version2, boolean shared, boolean optional, ModuleScope scope, String repositoryDisplayString, List<ExclusionDescriptor> exclusions) {
        String[] groupArtifactIds = this.nameToGroupArtifactIds(dCo.getName());
        if (groupArtifactIds == null) {
            return this.createArtifactResult(manager, dCo.getName(), version2, null, null, shared, optional, scope, repositoryDisplayString);
        }
        return this.createArtifactResult(manager, repository, groupArtifactIds[0], groupArtifactIds[1], version2, shared, optional, scope, repositoryDisplayString, exclusions);
    }

    protected ArtifactResult createArtifactResult(final RepositoryManager manager, CmrRepository repository, final String groupId, final String artifactId, final String dVersion, final boolean shared, final boolean optional, final ModuleScope scope, final String repositoryDisplayString, final List<ExclusionDescriptor> exclusions) {
        String dName = AetherUtils.toCanonicalForm(groupId, artifactId);
        return new MavenArtifactResult(repository, dName, dVersion, groupId, artifactId, repositoryDisplayString){
            private ArtifactResult result;
            {
                super(x0, x1, x2, x3, x4, x5);
                if (exclusions != null) {
                    ArrayList<Exclusion> ret = new ArrayList<Exclusion>(exclusions.size());
                    for (ExclusionDescriptor xDescr : exclusions) {
                        ret.add(new Exclusion(xDescr.getGroupId(), xDescr.getArtifactId()));
                    }
                    this.setExclusions(ret);
                }
            }

            @Override
            public boolean exported() {
                return shared;
            }

            @Override
            public boolean optional() {
                return optional;
            }

            @Override
            public ModuleScope moduleScope() {
                return scope;
            }

            private synchronized ArtifactResult getResult() {
                if (this.result == null) {
                    this.result = AetherUtils.this.fetchDependencies(manager, (CmrRepository)this.repository(), groupId, artifactId, dVersion, false, repositoryDisplayString);
                }
                return this.result;
            }

            @Override
            protected File artifactInternal() throws RepositoryException {
                return this.getResult().artifact();
            }

            @Override
            public List<ArtifactResult> dependencies() throws RepositoryException {
                return this.getResult().dependencies();
            }
        };
    }

    protected ArtifactResult createArtifactResult(RepositoryManager manager, String module, String dVersion, String groupId, String artifactId, boolean shared, boolean optional, ModuleScope scope, String repositoryDisplayString) {
        return new LazyArtifactResult(manager, "maven", module, dVersion, shared, optional, scope);
    }

    private ArtifactResult fetchWithClassifier(CmrRepository repository, String groupId, String artifactId, String version2, String classifier, String repositoryDisplayString) {
        String name = AetherUtils.toCanonicalForm(groupId, artifactId);
        String coordinates = AetherUtils.toCanonicalForm(AetherUtils.toCanonicalForm(AetherUtils.toCanonicalForm(name, "jar"), classifier), version2);
        try {
            DependencyDescriptor info = this.impl.getDependencies(groupId, artifactId, version2, classifier, "jar", true);
            if (info != null) {
                return new SingleArtifactResult(repository, name, version2, groupId, artifactId, info.getFile(), repositoryDisplayString);
            }
        }
        catch (AetherException e) {
            this.log.debug("Could not resolve " + classifier + " for artifact [" + coordinates + "] : " + e);
        }
        this.log.debug("No artifact found: " + coordinates);
        return null;
    }

    static String toCanonicalForm(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public DependencyDescriptor getDependencies(InputStream stream, String name, String version2) throws IOException {
        return this.impl.getDependencies(stream, name, version2);
    }

    public DependencyDescriptor getDependencies(File pomXml, String name, String version2) throws IOException {
        return this.impl.getDependencies(pomXml, name, version2);
    }

    private static class AetherArtifactResult
    extends SingleArtifactResult {
        private List<ArtifactResult> dependencies;

        private AetherArtifactResult(CmrRepository repository, String name, String version2, String groupId, String artifactId, File file, List<ArtifactResult> dependencies, String repositoryDisplayString) {
            super(repository, name, version2, groupId, artifactId, file, repositoryDisplayString);
            this.dependencies = dependencies;
        }

        @Override
        public List<ArtifactResult> dependencies() throws RepositoryException {
            return Collections.unmodifiableList(this.dependencies);
        }
    }

    private static class SingleArtifactResult
    extends MavenArtifactResult {
        private File file;

        private SingleArtifactResult(CmrRepository repository, String name, String version2, String groupId, String artifactId, File file, String repositoryDisplayString) {
            super(repository, name, version2, groupId, artifactId, repositoryDisplayString);
            this.file = file;
        }

        @Override
        protected File artifactInternal() throws RepositoryException {
            return this.file;
        }

        void setFilter(PathFilter filter) {
            this.setFilterInternal(filter);
        }

        @Override
        public List<ArtifactResult> dependencies() throws RepositoryException {
            return Collections.emptyList();
        }
    }

    private static abstract class MavenArtifactResult
    extends AbstractArtifactResult {
        private String repositoryDisplayString;
        private String artifactId;
        private String groupId;

        protected MavenArtifactResult(CmrRepository repository, String name, String version2, String groupId, String artifactId, String repositoryDisplayString) {
            super(repository, "maven", name, version2);
            this.repositoryDisplayString = repositoryDisplayString;
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String artifactId() {
            return this.artifactId;
        }

        @Override
        public ArtifactResultType type() {
            return ArtifactResultType.MAVEN;
        }

        @Override
        public String repositoryDisplayString() {
            return this.repositoryDisplayString;
        }
    }
}

