/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolver;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.maven.MavenUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MavenBackupDependencyResolver
extends AbstractDependencyResolver {
    public static final MavenBackupDependencyResolver INSTANCE = new MavenBackupDependencyResolver();

    private MavenBackupDependencyResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        ArtifactResult result;
        File mod;
        if (!context.ignoreInner() && (mod = (result = context.result()).artifact()) != null && mod.getName().toLowerCase().endsWith(".jar")) {
            String artifactId;
            String name = result.name();
            int p = name.indexOf(58);
            if (p < 0) {
                p = name.lastIndexOf(46);
            }
            if (p < 0) {
                return null;
            }
            String groupId = name.substring(0, p);
            String descriptorPath = String.format("META-INF/maven/%s/%s/pom.xml", groupId, artifactId = name.substring(p + 1));
            InputStream inputStream = IOUtils.findDescriptor(result, descriptorPath);
            if (inputStream != null) {
                try {
                    ModuleInfo moduleInfo = this.resolveFromInputStream(inputStream, name, result.version(), overrides);
                    return moduleInfo;
                }
                finally {
                    IOUtils.safeClose(inputStream);
                }
            }
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        if (!file.exists()) {
            return null;
        }
        try {
            ModuleInfo ret = MavenUtils.getDependencies(file, name, version2);
            if (overrides != null && ret != null) {
                ret = overrides.applyOverrides(name != null ? name : ret.getName(), version2 != null ? version2 : ret.getVersion(), ret);
            }
            return ret;
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to resolve pom", e);
        }
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        if (stream == null) {
            return null;
        }
        try {
            ModuleInfo ret = MavenUtils.getDependencies(stream, name, version2);
            if (overrides != null && ret != null) {
                ret = overrides.applyOverrides(name != null ? name : ret.getName(), version2 != null ? version2 : ret.getVersion(), ret);
            }
            return ret;
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to resolve pom", e);
        }
    }

    @Override
    public Node descriptor(Node artifact) {
        return NodeUtils.firstParent(artifact).getChild("pom.xml");
    }
}

