/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.resolver.aether;

import com.redhat.ceylon.cmr.resolver.aether.AetherException;
import com.redhat.ceylon.cmr.resolver.aether.AetherResolver;
import com.redhat.ceylon.cmr.resolver.aether.DependencyDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.DependencyNodeDependencyDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.ModelDependencyDescriptor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.version.Version;

public class AetherResolverImpl
implements AetherResolver {
    private String currentDirectory;
    private int timeout;
    private boolean offline;
    private String settingsXml;
    private static final DependencySelector NoChildSelector = new DependencySelector(){

        @Override
        public DependencySelector deriveChildSelector(DependencyCollectionContext arg0) {
            return this;
        }

        @Override
        public boolean selectDependency(Dependency arg0) {
            return false;
        }
    };

    private static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession newSession(RepositorySystem system) {
        return MavenRepositorySystemUtils.newSession();
    }

    private List<RemoteRepository> configureSession(RepositorySystem system, DefaultRepositorySystemSession session) {
        SettingsBuildingResult settingsBuildingResult;
        File userSettings;
        DefaultSettingsBuilderFactory factory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder builder = factory.newInstance();
        DefaultSettingsBuildingRequest settingsBuilderRequest = new DefaultSettingsBuildingRequest();
        settingsBuilderRequest.setSystemProperties(System.getProperties());
        String settingsFile = this.settingsXml;
        if (settingsFile == null && (userSettings = new File(System.getProperty("user.home"), ".m2/settings.xml")).exists()) {
            settingsFile = userSettings.getAbsolutePath();
        }
        if (settingsFile != null) {
            settingsBuilderRequest.setUserSettingsFile(new File(this.settingsXml));
        }
        try {
            settingsBuildingResult = builder.build(settingsBuilderRequest);
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e);
        }
        Settings set = settingsBuildingResult.getEffectiveSettings();
        String localRepository = set.getLocalRepository();
        if (localRepository == null) {
            localRepository = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        } else if (!new File(localRepository).isAbsolute() && this.currentDirectory != null) {
            localRepository = new File(new File(this.currentDirectory), localRepository).getAbsolutePath();
        }
        DefaultAuthenticationSelector authenticationSelector = new DefaultAuthenticationSelector();
        for (Server server : set.getServers()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            if (server.getUsername() != null) {
                auth.addUsername(server.getUsername());
            }
            if (server.getPassword() != null) {
                auth.addPassword(server.getPassword());
            }
            if (server.getPrivateKey() != null) {
                auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            }
            authenticationSelector.add(server.getId(), auth.build());
        }
        session.setAuthenticationSelector(authenticationSelector);
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : set.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector(mirrorSelector);
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : set.getProxies()) {
            if (!proxy.isActive()) continue;
            AuthenticationBuilder auth = new AuthenticationBuilder();
            if (proxy.getUsername() != null) {
                auth.addUsername(proxy.getUsername());
            }
            if (proxy.getPassword() != null) {
                auth.addPassword(proxy.getPassword());
            }
            Proxy p = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth.build());
            proxySelector.add(p, proxy.getNonProxyHosts());
        }
        session.setProxySelector(proxySelector);
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        RemoteRepository central = new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").build();
        repos.add(central);
        HashSet<String> activeProfiles = new HashSet<String>();
        activeProfiles.addAll(set.getActiveProfiles());
        for (Profile profile : set.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null || !activation.isActiveByDefault()) continue;
            activeProfiles.add(profile.getId());
        }
        for (String profileId : activeProfiles) {
            Profile profile = set.getProfilesAsMap().get(profileId);
            if (profile == null) continue;
            this.addReposFromProfile(repos, profile);
        }
        session.setConfigProperty("aether.connector.connectTimeout", this.timeout);
        session.setOffline(this.offline || set.isOffline());
        LocalRepository localRepo = new LocalRepository(localRepository);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(session, localRepo));
        return repos;
    }

    private void addReposFromProfile(List<RemoteRepository> repos, Profile profile) {
        for (Repository repo : profile.getRepositories()) {
            org.apache.maven.settings.RepositoryPolicy repoSnapshotPolicy;
            RemoteRepository.Builder remoteRepo = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            org.apache.maven.settings.RepositoryPolicy repoReleasePolicy = repo.getReleases();
            if (repoReleasePolicy != null) {
                String updatePolicy = repoReleasePolicy.getUpdatePolicy();
                if (updatePolicy == null || updatePolicy.isEmpty()) {
                    updatePolicy = "never";
                }
                RepositoryPolicy releasePolicy = new RepositoryPolicy(repoReleasePolicy.isEnabled(), updatePolicy, repoReleasePolicy.getChecksumPolicy());
                remoteRepo.setReleasePolicy(releasePolicy);
            }
            if ((repoSnapshotPolicy = repo.getSnapshots()) != null) {
                String updatePolicy = repoSnapshotPolicy.getUpdatePolicy();
                if (updatePolicy == null || updatePolicy.isEmpty()) {
                    updatePolicy = "never";
                }
                RepositoryPolicy snapshotPolicy = new RepositoryPolicy(repoSnapshotPolicy.isEnabled(), updatePolicy, repoSnapshotPolicy.getChecksumPolicy());
                remoteRepo.setSnapshotPolicy(snapshotPolicy);
            }
            repos.add(remoteRepo.build());
        }
    }

    public AetherResolverImpl(String currentDirectory, String settingsXml, boolean offline, int timeout) {
        this.currentDirectory = currentDirectory;
        this.timeout = timeout;
        this.offline = offline;
        this.settingsXml = settingsXml;
    }

    @Override
    public DependencyDescriptor getDependencies(String groupId, String artifactId, String version2, boolean fetchSingleArtifact) throws AetherException {
        return this.getDependencies(groupId, artifactId, version2, null, null, fetchSingleArtifact);
    }

    @Override
    public File getLocalRepositoryBaseDir() {
        RepositorySystem repoSystem = AetherResolverImpl.newRepositorySystem();
        DefaultRepositorySystemSession session = this.newSession(repoSystem);
        this.configureSession(repoSystem, session);
        return session.getLocalRepository().getBasedir();
    }

    @Override
    public DependencyDescriptor getDependencies(String groupId, String artifactId, String version2, String classifier, String extension, boolean fetchSingleArtifact) throws AetherException {
        RepositorySystem repoSystem = AetherResolverImpl.newRepositorySystem();
        DefaultRepositorySystemSession session = this.newSession(repoSystem);
        List<RemoteRepository> repos = this.configureSession(repoSystem, session);
        Artifact pomResultArtifact = null;
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, null, "pom", version2);
        if (extension == null) {
            try {
                pomResultArtifact = this.resolveSingleArtifact(repoSystem, session, repos, pomArtifact);
            }
            catch (ArtifactResolutionException e) {
                throw new AetherException(e);
            }
            if (pomResultArtifact != null) {
                extension = this.findExtension(pomResultArtifact.getFile());
            }
            if (extension == null || !extension.equals("jar") && !extension.equals("aar")) {
                extension = "jar";
            }
        }
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version2);
        DependencyNode ret = null;
        if (!fetchSingleArtifact) {
            block15: {
                try {
                    ret = this.resolveArtifactWithDependencies(repoSystem, session, repos, artifact);
                }
                catch (DependencyResolutionException e) {
                    if (this.isTimeout(e) || pomResultArtifact != null) break block15;
                    throw new AetherException(e);
                }
            }
            if (ret == null) {
                try {
                    ret = this.resolveArtifactWithDependencies(repoSystem, session, repos, pomArtifact);
                }
                catch (DependencyResolutionException e) {
                    throw new AetherException(e);
                }
            }
        } else {
            Artifact resultArtifact;
            try {
                resultArtifact = this.resolveSingleArtifact(repoSystem, session, repos, artifact);
            }
            catch (ArtifactResolutionException e) {
                if (!this.isTimeout(e) && pomResultArtifact == null) {
                    throw new AetherException(e);
                }
                resultArtifact = pomResultArtifact;
            }
            ret = new DefaultDependencyNode(resultArtifact);
        }
        return ret == null ? null : new DependencyNodeDependencyDescriptor(this, ret);
    }

    private boolean isTimeout(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e.getClass().getSimpleName().endsWith(".ConnectTimeoutException");
    }

    private DependencyNode resolveArtifactWithDependencies(RepositorySystem repoSystem, DefaultRepositorySystemSession session, List<RemoteRepository> repos, DefaultArtifact artifact) throws DependencyResolutionException {
        final Dependency dependency = new Dependency(artifact, "compile");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRepositories(repos);
        collectRequest.setRoot(dependency);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        dependencyRequest.setFilter(new DependencyFilter(){

            @Override
            public boolean accept(DependencyNode dep, List<DependencyNode> parents) {
                return parents.size() == 0;
            }
        });
        session.setDependencySelector(new DependencySelector(){

            @Override
            public DependencySelector deriveChildSelector(DependencyCollectionContext ctx) {
                if (AetherResolverImpl.this.myEquals(ctx.getDependency(), dependency)) {
                    return this;
                }
                return NoChildSelector;
            }

            @Override
            public boolean selectDependency(Dependency dep) {
                return "compile".equals(dep.getScope()) || "runtime".equals(dep.getScope()) || "provided".equals(dep.getScope());
            }
        });
        return repoSystem.resolveDependencies(session, dependencyRequest).getRoot();
    }

    private Artifact resolveSingleArtifact(RepositorySystem repoSystem, DefaultRepositorySystemSession session, List<RemoteRepository> repos, DefaultArtifact artifact) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        artifactRequest.setRepositories(repos);
        return repoSystem.resolveArtifact(session, artifactRequest).getArtifact();
    }

    private boolean myEquals(Dependency a, Dependency b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return this.myEquals(a.getArtifact(), b.getArtifact()) && a.isOptional() == b.isOptional() && Objects.equals(a.getScope(), b.getScope());
    }

    private boolean myEquals(Artifact a, Artifact b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Objects.equals(a.getArtifactId(), b.getArtifactId()) && Objects.equals(a.getGroupId(), b.getGroupId()) && Objects.equals(a.getVersion(), b.getVersion()) && Objects.equals(a.getClassifier(), b.getClassifier()) && Objects.equals(a.getExtension(), b.getExtension()) && Objects.equals(a.getFile(), b.getFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findExtension(File pomFile) {
        if (pomFile == null) return null;
        if (!pomFile.exists()) return null;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader fileReader = new FileReader(pomFile);){
            Model model = reader.read(fileReader);
            String string = model.getPackaging();
            return string;
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    @Override
    public List<String> resolveVersionRange(String groupId, String artifactId, String versionRange) throws AetherException {
        VersionRangeResult rangeResult;
        RepositorySystem repoSystem = AetherResolverImpl.newRepositorySystem();
        DefaultRepositorySystemSession session = this.newSession(repoSystem);
        List<RemoteRepository> repos = this.configureSession(repoSystem, session);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "jar", versionRange);
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(repos);
        try {
            rangeResult = repoSystem.resolveVersionRange(session, rangeRequest);
        }
        catch (VersionRangeResolutionException e) {
            throw new AetherException(e);
        }
        ArrayList<String> ret = new ArrayList<String>(rangeResult.getVersions().size());
        for (Version version2 : rangeResult.getVersions()) {
            ret.add(version2.toString());
        }
        return ret;
    }

    @Override
    public DependencyDescriptor getDependencies(File pomXml, String name, String version2) throws IOException {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader fileReader = new FileReader(pomXml);){
            model = reader.read(fileReader);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        return new ModelDependencyDescriptor(model);
    }

    @Override
    public DependencyDescriptor getDependencies(InputStream pomXml, String name, String version2) throws IOException {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            model = reader.read(pomXml);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        return new ModelDependencyDescriptor(model);
    }
}

