/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.util;

import com.redhat.ceylon.common.config.DefaultToolOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class WS {
    public static void getXML(String url, Param[] params, XMLHandler handler) {
        if (params != null) {
            url = url + WS.toQueryString(Arrays.asList(params));
        }
        WS.getXML(url, handler);
    }

    public static void getXML(String url, List<Param> params, XMLHandler handler) {
        if (params != null) {
            url = url + WS.toQueryString(params);
        }
        WS.getXML(url, handler);
    }

    public static void getXML(String url, XMLHandler handler) {
        try {
            URL endpoint = new URL(url);
            Proxy proxy = DefaultToolOptions.getDefaultProxy();
            HttpURLConnection connection = proxy != null ? (HttpURLConnection)endpoint.openConnection(proxy) : (HttpURLConnection)endpoint.openConnection();
            connection.setConnectTimeout((int)DefaultToolOptions.getDefaultTimeout());
            connection.setReadTimeout((int)DefaultToolOptions.getDefaultTimeout() * 10);
            WS.getXML(connection, handler);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getXML(HttpURLConnection connection, XMLHandler handler) {
        block12: {
            try {
                connection.addRequestProperty("Accept", "application/xml");
                connection.connect();
                try {
                    if (connection.getResponseCode() != 200) break block12;
                    try (InputStream is = connection.getInputStream();){
                        XMLInputFactory factory = XMLInputFactory.newFactory();
                        try (XMLStreamReader reader = factory.createXMLStreamReader(is);){
                            Parser p = new Parser(reader);
                            handler.onOK(p);
                        }
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (XMLStreamException x) {
                throw new RuntimeException(x);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public static List<Link> collectLinks(HttpURLConnection con) {
        List<String> linkHeaders = con.getHeaderFields().get("Link");
        LinkedList<Link> ret = new LinkedList<Link>();
        if (linkHeaders != null) {
            for (String linkHeader : linkHeaders) {
                String[] links;
                for (String link : links = linkHeader.split(",")) {
                    ret.add(WS.parseLink(link));
                }
            }
        }
        return ret;
    }

    public static String getLink(List<Link> links, String rel) {
        for (Link link : links) {
            if (!rel.equals(link.params.get("rel"))) continue;
            return link.url;
        }
        return null;
    }

    private static Link parseLink(String link) {
        String[] parts = link.split(";");
        String url = parts[0].trim();
        if (!url.startsWith("<") || !url.endsWith(">")) {
            throw new RuntimeException("Invalid link header: " + link);
        }
        if ((url = url.substring(1, url.length() - 1)).isEmpty()) {
            throw new RuntimeException("Invalid link header: " + link);
        }
        Link ret = new Link(url);
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            int eq = part.indexOf(61);
            if (eq == -1) {
                throw new RuntimeException("Invalid link header: " + link);
            }
            String name = part.substring(0, eq).trim();
            String val = part.substring(eq + 1).trim();
            if (name.isEmpty() || val.isEmpty()) {
                throw new RuntimeException("Invalid link header: " + link);
            }
            if (val.startsWith("\"")) {
                if (!val.endsWith("\"")) {
                    throw new RuntimeException("Invalid link header: " + link);
                }
                if ((val = val.substring(1, val.length() - 1)).isEmpty()) {
                    throw new RuntimeException("Invalid link header: " + link);
                }
            }
            ret.params.put(name, val);
        }
        return ret;
    }

    public static Param param(String name, String ... values) {
        return new Param(name, values);
    }

    public static Param param(String name, Long value) {
        return new Param(name, value);
    }

    public static Param param(String name, Integer value) {
        return new Param(name, value);
    }

    public static Param param(String name, Boolean value) {
        return new Param(name, value);
    }

    private static String encodeURLQueryParam(String name) {
        if (name == null) {
            return "";
        }
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toQueryString(List<Param> params) {
        StringBuilder b = new StringBuilder("?");
        boolean first = true;
        for (Param param : params) {
            if (!first) {
                b.append("&");
            }
            param.toString(b);
            first = false;
        }
        return b.toString();
    }

    public static Param[] params(Param ... params) {
        return params;
    }

    public static class Param {
        public String name;
        public String[] values;

        public Param(String name, String[] values) {
            this.name = name;
            this.values = values;
        }

        public Param(String name, Long value) {
            this.name = name;
            this.values = new String[1];
            this.values[0] = value != null ? value.toString() : null;
        }

        public Param(String name, Integer value) {
            this.name = name;
            this.values = new String[1];
            this.values[0] = value != null ? value.toString() : null;
        }

        public Param(String name, Boolean value) {
            this.name = name;
            this.values = new String[1];
            this.values[0] = value != null ? value.toString() : null;
        }

        public void toString(StringBuilder b) {
            if (this.values.length == 1) {
                b.append(WS.encodeURLQueryParam(this.name)).append("=").append(WS.encodeURLQueryParam(this.values[0]));
                return;
            }
            if (this.values.length == 0) {
                b.append(WS.encodeURLQueryParam(this.name)).append("=");
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (i != 0) {
                    b.append("&");
                }
                b.append(WS.encodeURLQueryParam(this.name)).append("=").append(WS.encodeURLQueryParam(this.values[i]));
            }
        }
    }

    public static class Link {
        public String url;
        public Map<String, String> params = new HashMap<String, String>();

        public Link(String url) {
            this.url = url;
        }
    }

    public static interface XMLHandler {
        public void onOK(Parser var1);
    }

    public static class Parser {
        private XMLStreamReader reader;

        public Parser(XMLStreamReader reader) {
            this.reader = reader;
        }

        public boolean moveToOptionalOpenTag(String name) {
            this.nextTag();
            return this.isOpenTag(name);
        }

        public boolean moveToOptionalOpenTag() {
            this.nextTag();
            return this.isOpenTag();
        }

        public String getAttribute(String name) {
            return this.reader.getAttributeValue(null, name);
        }

        public boolean isOpenTag() {
            int code = this.reader.getEventType();
            return code == 1;
        }

        public boolean isOpenTag(String name) {
            return this.isOpenTag() && this.tagName().equals(name);
        }

        public void moveToOpenTag(String name) {
            this.nextTag();
            if (!this.isOpenTag(name)) {
                throw new RuntimeException("Expected open tag " + name + " but got " + this.reader.getEventType());
            }
        }

        public void checkCloseTag() {
            int code = this.reader.getEventType();
            if (code != 2) {
                throw new RuntimeException("Expected close tag but got " + code);
            }
        }

        public void nextTag() {
            try {
                this.reader.nextTag();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        public String contents() {
            try {
                String contents = this.reader.getElementText();
                return contents;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        public String tagName() {
            return this.reader.getName().getLocalPart();
        }
    }
}

