/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import java.io.File;
import java.util.HashSet;

public class JVMModuleUtil {
    private static final HashSet<String> tokens;
    private static final String[] tokensArray;
    public static final String RUN_INFO_CLASS = "run";

    public static String quote(String name) {
        return "$" + name;
    }

    public static String unquote(String name) {
        if (!name.isEmpty() && name.charAt(0) == '$') {
            return name.substring(1);
        }
        return name;
    }

    public static boolean isJavaKeyword(String name) {
        return tokens.contains(name);
    }

    public static boolean isJavaKeyword(String string, int start, int end) {
        int length = end - start;
        block0: for (int i = 0; i < tokensArray.length; ++i) {
            String token = tokensArray[i];
            if (token.length() != length) continue;
            for (int c = 0; c < length; ++c) {
                if (string.charAt(c + start) != token.charAt(c)) continue block0;
            }
            return true;
        }
        return false;
    }

    public static String quoteIfJavaKeyword(String name) {
        if (JVMModuleUtil.isJavaKeyword(name)) {
            return JVMModuleUtil.quote(name);
        }
        return name;
    }

    public static String quoteJavaKeywords(String qualifiedName) {
        if (qualifiedName != null && JVMModuleUtil.needsJavaKeywordsQuoting(qualifiedName)) {
            return JVMModuleUtil.join(".", JVMModuleUtil.quoteJavaKeywords(qualifiedName.split("\\.")));
        }
        return qualifiedName;
    }

    public static String[] quoteJavaKeywords(String[] name) {
        String[] result = new String[name.length];
        for (int ii = 0; ii < name.length; ++ii) {
            result[ii] = JVMModuleUtil.quoteIfJavaKeyword(name[ii]);
        }
        return result;
    }

    public static String quoteJavaKeywordsInFilename(String path) {
        return JVMModuleUtil.quoteJavaKeywordsInFilename(new File(path));
    }

    public static String quoteJavaKeywordsInFilename(File file) {
        String base = file.getParentFile() != null ? JVMModuleUtil.quoteJavaKeywordsInFilename(file.getParentFile()) + File.separator : "";
        return base + JVMModuleUtil.quoteIfJavaKeyword(file.getName());
    }

    private static boolean needsJavaKeywordsQuoting(String qualifiedName) {
        int nextDot = qualifiedName.indexOf(46);
        int start = 0;
        while (nextDot != -1) {
            if (JVMModuleUtil.isJavaKeyword(qualifiedName, start, nextDot)) {
                return true;
            }
            start = nextDot + 1;
            nextDot = qualifiedName.indexOf(46, start);
        }
        return JVMModuleUtil.isJavaKeyword(qualifiedName, start, qualifiedName.length());
    }

    public static String unquoteIfJavaKeyword(String name) {
        String unquoted = JVMModuleUtil.unquote(name);
        if (JVMModuleUtil.isJavaKeyword(unquoted)) {
            return unquoted;
        }
        return name;
    }

    public static String unquoteJavaKeywords(String qualifiedName) {
        if (qualifiedName != null) {
            return JVMModuleUtil.join(".", JVMModuleUtil.unquoteJavaKeywords(qualifiedName.split("\\.")));
        }
        return qualifiedName;
    }

    public static String[] unquoteJavaKeywords(String[] name) {
        String[] result = new String[name.length];
        for (int ii = 0; ii < name.length; ++ii) {
            result[ii] = JVMModuleUtil.unquoteIfJavaKeyword(name[ii]);
        }
        return result;
    }

    public static String join(String sep, String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part).append(sep);
        }
        return sb.subSequence(0, sb.length() - sep.length()).toString();
    }

    public static String javaClassNameFromCeylon(String moduleName, String ceylonRunnableName) {
        String runClassName1 = ceylonRunnableName;
        runClassName1 = runClassName1 == null || runClassName1.isEmpty() ? (moduleName.equals("default") ? RUN_INFO_CLASS : moduleName + "." + RUN_INFO_CLASS) : runClassName1.replace("::", ".");
        ceylonRunnableName = runClassName1;
        char firstChar = ceylonRunnableName.charAt(0);
        int lastDot = ceylonRunnableName.lastIndexOf(46);
        if (lastDot > 0) {
            firstChar = ceylonRunnableName.charAt(lastDot + 1);
            String lastPart = ceylonRunnableName.substring(lastDot + 1);
            String pkgPart = ceylonRunnableName.substring(0, lastDot);
            ceylonRunnableName = JVMModuleUtil.quoteJavaKeywords(pkgPart) + "." + lastPart;
        }
        return Character.isLowerCase(firstChar) ? ceylonRunnableName + "_" : ceylonRunnableName;
    }

    static {
        tokensArray = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"};
        tokens = new HashSet();
        for (String token : tokensArray) {
            tokens.add(token);
        }
    }
}

