/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ModuleDescriptorReader {
    private Object instance;
    private Method moduleVersion;
    private Method moduleName;
    private Method moduleBackend;
    private Method moduleLicense;
    private Method moduleAuthors;
    private Method moduleImports;
    private Method moduleGroupId;
    private Method moduleArtifactId;

    public ModuleDescriptorReader(String moduleName, File srcDir) throws NoSuchModuleException {
        this(ModuleDescriptorReader.class.getClassLoader(), moduleName, srcDir);
    }

    public ModuleDescriptorReader(ClassLoader cl, String moduleName, File srcDir) throws NoSuchModuleException {
        try {
            Class<?> mdr = cl.loadClass("com.redhat.ceylon.compiler.ModuleDescriptorReader");
            this.moduleVersion = mdr.getMethod("getModuleVersion", new Class[0]);
            this.moduleVersion.setAccessible(true);
            this.moduleName = mdr.getMethod("getModuleName", new Class[0]);
            this.moduleName.setAccessible(true);
            this.moduleBackend = mdr.getMethod("getModuleBackends", new Class[0]);
            this.moduleBackend.setAccessible(true);
            this.moduleLicense = mdr.getMethod("getModuleLicense", new Class[0]);
            this.moduleLicense.setAccessible(true);
            this.moduleAuthors = mdr.getMethod("getModuleAuthors", new Class[0]);
            this.moduleAuthors.setAccessible(true);
            this.moduleImports = mdr.getMethod("getModuleImports", new Class[0]);
            this.moduleImports.setAccessible(true);
            this.moduleGroupId = mdr.getMethod("getModuleGroupId", new Class[0]);
            this.moduleGroupId.setAccessible(true);
            this.moduleArtifactId = mdr.getMethod("getModuleArtifactId", new Class[0]);
            this.moduleArtifactId.setAccessible(true);
            Constructor<?> constructor = mdr.getConstructor(String.class, File.class);
            constructor.setAccessible(true);
            this.instance = constructor.newInstance(moduleName, srcDir);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause.getClass().getName().equals("com.redhat.ceylon.common.ModuleDescriptorReader$NoSuchModuleException")) {
                throw new NoSuchModuleException(cause.getMessage());
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getModuleVersion() {
        try {
            return (String)this.moduleVersion.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getModuleName() {
        try {
            return (String)this.moduleName.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getModuleBackends() {
        try {
            return (List)this.moduleBackend.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getModuleLicense() {
        try {
            return (String)this.moduleLicense.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getModuleAuthors() {
        try {
            return (List)this.moduleAuthors.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object[]> getModuleImports() {
        try {
            return (List)this.moduleImports.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getModuleArtifactId() {
        try {
            return (String)this.moduleArtifactId.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getModuleGroupId() {
        try {
            return (String)this.moduleGroupId.invoke(this.instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class NoSuchModuleException
    extends Exception {
        public NoSuchModuleException(String string) {
            super(string);
        }
    }
}

