/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.OSUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class PathPlugins {
    private Set<String> pathPlugins;

    public Set<String> getPathPlugins() {
        if (this.pathPlugins == null) {
            this.pathPlugins = new TreeSet<String>();
            this.findPathPlugins();
        }
        return this.pathPlugins;
    }

    private void findPathPlugins() {
        File[] paths;
        HashSet<String> names = new HashSet<String>();
        for (File projectDir = new File("").getAbsoluteFile(); projectDir != null; projectDir = projectDir.getParentFile()) {
            File configBin = new File(new File(projectDir, ".ceylon"), "bin");
            this.findPathPlugins(configBin, names);
        }
        File defUserDir = new File(FileUtil.getDefaultUserDir(), "bin");
        this.findPathPlugins(defUserDir, names);
        File systemDir = new File(FileUtil.getSystemConfigDir(), "bin");
        this.findPathPlugins(systemDir, names);
        File ceylonHome = FileUtil.getInstallDir();
        if (ceylonHome != null) {
            this.findPathPlugins(new File(ceylonHome, "bin"), names);
        }
        for (File part : paths = FileUtil.getExecPath()) {
            this.findPluginInPath(part, names);
        }
    }

    private void findPathPlugins(File dir, Set<String> names) {
        this.findPluginInPath(dir, names);
        if (dir.isDirectory() && dir.canRead()) {
            for (File scriptPluginDir : dir.listFiles()) {
                if (!scriptPluginDir.isDirectory()) continue;
                this.findPluginInPath(scriptPluginDir, names);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findPluginInPath(File dir, final Set<String> names) {
        if (dir.isDirectory() && dir.canRead()) {
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path f) throws IOException {
                    String fileName = f.getFileName().toString();
                    if (fileName.toLowerCase().startsWith("ceylon-") && Files.isRegularFile(f, new LinkOption[0])) {
                        String name = fileName.substring(7);
                        if (name.toLowerCase().endsWith(".plugin") && names.add(name = name.substring(0, name.length() - 7))) {
                            PathPlugins.this.pathPlugins.add("PLUGIN:" + f.toAbsolutePath().toString());
                            return true;
                        }
                        if (Files.isExecutable(f)) {
                            if (OSUtil.isWindows()) {
                                if (!name.toLowerCase().endsWith(".bat")) {
                                    return false;
                                }
                                name = name.substring(0, name.length() - 4);
                            }
                            if (name.indexOf(46) != -1) {
                                return false;
                            }
                            if (name.equalsIgnoreCase("sh-setup")) {
                                return false;
                            }
                            if (names.add(name)) {
                                PathPlugins.this.pathPlugins.add("SCRIPT:" + f.toAbsolutePath().toString());
                                return true;
                            }
                        }
                    }
                    return false;
                }
            };
            DirectoryStream<Path> stream = null;
            try {
                stream = Files.newDirectoryStream(dir.toPath(), (DirectoryStream.Filter<? super Path>)filter);
                for (Path path : stream) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

