/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleDescriptorReader;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ModuleVersionReader {
    private final Iterable<File> sourceDirs;
    private File cwd;
    private Map<String, ModuleVersionDetails> cache;

    public ModuleVersionReader(Iterable<File> sourceDirs) {
        this.sourceDirs = sourceDirs;
        this.cache = new HashMap<String, ModuleVersionDetails>();
    }

    public ModuleVersionReader cwd(File cwd) {
        this.cwd = cwd;
        return this;
    }

    public ModuleVersionDetails fromSource(String moduleName) {
        ModuleVersionDetails mvd = this.cache.get(moduleName);
        if (mvd == null && (mvd = ModuleVersionReader.getModuleVersionDetailsFromSource(this.cwd, this.sourceDirs, moduleName)) != null) {
            this.cache.put(moduleName, mvd);
        }
        return mvd;
    }

    public static ModuleVersionDetails getModuleVersionDetailsFromSource(File cwd, Iterable<File> srcDirs, String moduleName) {
        try {
            for (File srcDir : srcDirs) {
                try {
                    return ModuleVersionReader.getModuleVersionDetailsFromSource(moduleName, FileUtil.applyCwd(cwd, srcDir));
                }
                catch (ModuleDescriptorReader.NoSuchModuleException noSuchModuleException) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ModuleVersionDetails getModuleVersionDetailsFromSource(String moduleName, File srcDir) throws ModuleDescriptorReader.NoSuchModuleException {
        ModuleDescriptorReader mdr = new ModuleDescriptorReader(moduleName, srcDir);
        String module = mdr.getModuleName();
        String version2 = mdr.getModuleVersion();
        ModuleVersionDetails mvd = new ModuleVersionDetails(null, module != null ? module : "", version2 != null ? version2 : "", mdr.getModuleGroupId(), mdr.getModuleArtifactId());
        mvd.setLicense(mdr.getModuleLicense());
        List<String> by = mdr.getModuleAuthors();
        if (by != null) {
            mvd.getAuthors().addAll(by);
        }
        TreeSet<ModuleDependencyInfo> dependencies = new TreeSet<ModuleDependencyInfo>();
        for (Object[] dep : mdr.getModuleImports()) {
            dependencies.add(new ModuleDependencyInfo((String)dep[0], (String)dep[1], (String)dep[2], (Boolean)dep[3], (Boolean)dep[4], (Backends)dep[5]));
        }
        mvd.setDependencies(dependencies);
        mvd.setRemote(false);
        mvd.setOrigin("Local source folder");
        return mvd;
    }
}

