/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import com.redhat.ceylon.common.tool.ArgumentModel;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tools.help.AbstractMl;
import com.redhat.ceylon.common.tools.help.CeylonHelpToolMessages;
import com.redhat.ceylon.common.tools.help.Html;
import com.redhat.ceylon.common.tools.help.Markdown;
import com.redhat.ceylon.common.tools.help.model.DescribedSection;
import com.redhat.ceylon.common.tools.help.model.Doc;
import com.redhat.ceylon.common.tools.help.model.Option;
import com.redhat.ceylon.common.tools.help.model.OptionsSection;
import com.redhat.ceylon.common.tools.help.model.SubtoolVisitor;
import com.redhat.ceylon.common.tools.help.model.SummarySection;
import com.redhat.ceylon.common.tools.help.model.SynopsesSection;
import com.redhat.ceylon.common.tools.help.model.Synopsis;
import com.redhat.ceylon.common.tools.help.model.Visitor;
import java.util.ResourceBundle;
import org.tautua.markdownpapers.ast.Node;

public class HtmlVisitor
implements Visitor {
    private final Html html;
    private boolean hadFirstArgument;
    private boolean hadOptions;
    private Doc doc;
    private int optionsDepth = 0;
    private final boolean omitDoctype;

    HtmlVisitor(Appendable out, boolean omitDoctype) {
        this.html = new Html(out);
        this.omitDoctype = omitDoctype;
    }

    AbstractMl getHtml() {
        return this.html;
    }

    @Override
    public void start(Doc doc) {
        this.doc = doc;
        ResourceBundle bundle = CeylonHelpToolMessages.RESOURCE_BUNDLE;
        if (!this.omitDoctype) {
            ((Html)this.html.doctype("html")).text("\n");
        }
        this.html.open("html", "head");
        ((Html)this.html.tag("meta charset='UTF-8'")).text("\n");
        ((Html)((Html)((Html)this.html.open("title")).text(doc.getInvocation())).close("title")).text("\n");
        ((Html)this.html.tag("link rel='stylesheet' type='text/css' href='bootstrap.min.css'")).text("\n");
        ((Html)this.html.tag("link rel='stylesheet' type='text/css' href='doc-tool.css'")).text("\n");
        ((Html)this.html.close("head")).text("\n");
        ((Html)this.html.open("body")).text("\n");
        ((Html)this.html.open("div class='navbar navbar-inverse navbar-static-top'")).text("\n");
        ((Html)this.html.open("div class='navbar-inner'")).text("\n");
        ((Html)this.html.open("a class='tool-header' href='index.html'")).text("\n");
        ((Html)((Html)this.html.open("i class='tool-logo'")).close("i")).text("\n");
        ((Html)((Html)((Html)this.html.open("span class='tool-label'")).text(bundle.getString("index.title"))).close("span")).text("\n");
        ((Html)((Html)((Html)this.html.open("span", "code class='tool-name'")).text(doc.getInvocation())).close("code", "span")).text("\n");
        ((Html)((Html)((Html)this.html.open("span class='tool-version'")).text(doc.getVersion())).close("span")).text("\n");
        ((Html)this.html.close("a")).text("\n");
        this.html.open("ul class='nav pull-right'");
        this.html.tag("li class='divider-vertical'");
        this.html.open("li id='infoDropdown' class='dropdown'");
        this.html.open("a href='#' title='Show keyboard shortcuts [Shortcut: ?]' role='button' class='dropdown-toggle' data-toggle='dropdown'");
        ((Html)this.html.open("i class='icon-info'")).close("i");
        this.html.close("a");
        this.html.open("ul id='info-dropdown-panel' class='dropdown-menu'");
        ((Html)((Html)this.html.open("h4")).text("Keyboard Shortcuts")).close("h4");
        ((Html)this.html.open("li class='divider'")).close("li");
        this.html.open("div id='info-common-shortcuts'");
        HtmlVisitor.shortcutInfo(this.html, "?", "Open this information panel");
        HtmlVisitor.shortcutInfo(this.html, "i", "Jump to tool index");
        HtmlVisitor.shortcutInfo(this.html, "s", "Jump to synopsis");
        HtmlVisitor.shortcutInfo(this.html, "d", "Jump to description");
        HtmlVisitor.shortcutInfo(this.html, "o", "Jump to options");
        this.html.close("div", "ul", "li", "ul");
        ((Html)this.html.close("div")).text("\n");
        ((Html)this.html.close("div")).text("\n");
    }

    private static void shortcutInfo(AbstractMl html, String key, String description) {
        ((AbstractMl)((AbstractMl)((AbstractMl)html.open("div id='" + key + "'")).open("span class='key badge'")).text(key)).close("span");
        ((AbstractMl)((AbstractMl)html.open("span class='info muted'")).text(description)).close("span", "div");
    }

    @Override
    public void end(Doc doc) {
        this.html.close("div");
        ((Html)this.html.open("script type='text/javascript' src='jquery-1.8.2.min.js'")).close("script");
        ((Html)this.html.open("script type='text/javascript' src='bootstrap.min.js'")).close("script");
        ((Html)this.html.open("script type='text/javascript' src='doc-tool.js'")).close("script");
        ((Html)((Html)this.html.open("script type='text/javascript'")).unescaped("init();")).close("script");
        this.html.close("body", "html");
    }

    private static void addTableStart(AbstractMl html, String section, String title, int cols) {
        HtmlVisitor.addTableStart(html, section, (Node)Markdown.markdown("##" + title), cols);
    }

    private static void addTableStart(AbstractMl html, String sectionId, Node title, int cols) {
        ((AbstractMl)html.open("table class='table table-condensed table-bordered'")).text("\n");
        ((AbstractMl)html.open("thead")).text("\n");
        html.open("tr class='table-header' title='Click for expand/collapse'");
        html.open("td colspan='" + cols + "'" + (sectionId != null ? " id='" + sectionId + "'" : ""));
        ((AbstractMl)html.open("i class='icon-expand'")).close("i");
        ((AbstractMl)((AbstractMl)html.markdown(title)).close("td", "tr")).text("\n");
        ((AbstractMl)html.close("thead")).text("\n");
        ((AbstractMl)html.open("tbody")).text("\n");
    }

    private static void addTableEnd(AbstractMl html) {
        html.close("tbody", "table");
    }

    @Override
    public void visitAdditionalSection(DescribedSection describedSection) {
        this.describedSection(0, describedSection);
    }

    private void describedSection(int depth, DescribedSection describedSection) {
        String sectionId = null;
        if (depth == 0) {
            if (describedSection.getRole() == DescribedSection.Role.DESCRIPTION) {
                ((Html)this.html.open("div class='section section-description'")).text("\n");
                sectionId = "section-description";
            } else {
                ((Html)this.html.open("div class='section'")).text("\n");
            }
            HtmlVisitor.addTableStart((AbstractMl)this.html, sectionId, describedSection.getTitle(), 1);
            ((Html)this.html.open("tr", "td")).markdown(describedSection.getDescription());
        } else {
            if (describedSection.getAbout() instanceof ToolModel) {
                this.html.open("div id='" + this.idSubtool((ToolModel)describedSection.getAbout()) + "'");
            } else {
                this.html.open("div");
            }
            this.html.markdown(describedSection.getTitle());
            this.html.markdown(describedSection.getDescription());
        }
        for (DescribedSection subsection : describedSection.getSubsections()) {
            this.describedSection(depth + 1, subsection);
        }
        if (depth != 0) {
            this.html.close("div");
        } else {
            this.html.close("td", "tr");
            HtmlVisitor.addTableEnd(this.html);
            ((Html)this.html.close("div")).text("\n");
        }
    }

    @Override
    public void startOptions(OptionsSection optionsSection) {
        if (this.optionsDepth == 0) {
            ((Html)this.html.open("div class='section section-options'")).text("\n");
            HtmlVisitor.addTableStart((AbstractMl)this.html, "section-options", optionsSection.getTitle(), 2);
        } else {
            this.html.open("tr class='table-header'", "td colspan='2'");
            this.html.markdown(optionsSection.getTitle());
            this.html.close("td", "tr");
        }
        ++this.optionsDepth;
    }

    private String idLongOption(OptionModel<?> option) {
        return "option--" + option.getLongName();
    }

    private String idShortOption(OptionModel<?> option) {
        return "option-" + option.getShortName();
    }

    private String idSubtool(ToolModel<?> model) {
        return "subtool-" + model.getName();
    }

    @Override
    public void visitOption(Option option) {
        String longName = option.getLongName();
        String shortName = option.getShortName();
        String argumentName = option.getArgumentName();
        OptionModel.ArgumentType argumentType = option.getOption().getArgumentType();
        this.html.open("tr");
        ((Html)this.html.open("td class='span3' id='" + this.idLongOption(option.getOption()) + "'", "code")).text(longName);
        if (argumentType == OptionModel.ArgumentType.OPTIONAL) {
            this.html.text("[");
        }
        if (argumentType != OptionModel.ArgumentType.BOOLEAN) {
            ((Html)this.html.text("=")).text(argumentName);
        }
        if (argumentType == OptionModel.ArgumentType.OPTIONAL) {
            this.html.text("]");
        }
        this.html.close("code");
        if (shortName != null) {
            this.html.text(", ");
            ((Html)this.html.open("code id='" + this.idShortOption(option.getOption()) + "'")).text(shortName);
            if (argumentType == OptionModel.ArgumentType.REQUIRED) {
                this.html.text(" ");
                this.html.text(argumentName);
            }
            this.html.close("code");
        }
        ((Html)this.html.close("td")).text("\n");
        this.html.open("td class='option-description'");
        this.html.markdown(option.getDescription());
        ((Html)this.html.close("td")).text("\n");
        this.html.close("tr");
    }

    @Override
    public void endOptions(OptionsSection optionsSection) {
        --this.optionsDepth;
        if (this.optionsDepth == 0) {
            HtmlVisitor.addTableEnd(this.html);
            this.html.close("div");
        }
    }

    @Override
    public void visitSummary(SummarySection summarySection) {
        ((Html)this.html.open("div class='sub-navbar'")).text("\n");
        this.html.open("div class='sub-navbar-inner'");
        ((Html)((Html)((Html)this.html.open("div", "code class='sub-navbar-tool'")).text(this.doc.getInvocation())).close("code", "div")).text("\n");
        ((Html)((Html)((Html)this.html.open("div class='sub-navbar-summary'")).markdown((Node)Markdown.markdown(summarySection.getSummary()))).close("div")).text("\n");
        this.html.close("div");
        ((Html)this.html.open("div class='sub-navbar-menu'")).text("\n");
        HtmlVisitor.addShortcutKey(this.html, "index.html", "Jump to tool index", "I", "ndex");
        HtmlVisitor.addShortcutKey(this.html, "#section-synopsis", "Jump to tool synopsis", "S", "ynopsis");
        HtmlVisitor.addShortcutKey(this.html, "#section-description", "Jump to tool description", "D", "escription");
        HtmlVisitor.addShortcutKey(this.html, "#section-options", "Jump to tool options", "O", "ptions");
        ((Html)this.html.close("div", "div")).text("\n");
        ((Html)this.html.open("div class='container-fluid'")).text("\n");
    }

    private static void addShortcutKey(AbstractMl html, String url, String title, String key, String rest) {
        html.open("a href='" + url + "'");
        html.open("span title='" + title + " [Shortcut: " + key + "]'");
        ((AbstractMl)((AbstractMl)((AbstractMl)((AbstractMl)html.open("span class='accesskey'")).text(key)).close("span")).text(rest)).close("span", "a");
    }

    @Override
    public void startSynopses(SynopsesSection synopsesSection) {
        ((Html)this.html.open("div class='section section-synopsis'")).text("\n");
        HtmlVisitor.addTableStart((AbstractMl)this.html, "section-synopsis", synopsesSection.getTitle(), 1);
    }

    private void longOptionSynopsis(OptionModel<?> option) {
        String string = "--" + option.getLongName();
        this.html.link(string, "#" + this.idLongOption(option));
    }

    private void shortOptionSynopsis(OptionModel<?> option) {
        String string = "-" + option.getShortName();
        this.html.link(string, "#" + this.idShortOption(option));
    }

    private void argumentSynopsis(String name) {
        this.html.link(name, "#arg" + name);
    }

    private void subtoolSynopsis(SubtoolVisitor.ToolModelAndSubtoolModel nast) {
        String name = nast.getName();
        if (nast.getModel().getSubtoolModel() == null) {
            this.html.link(name, "#" + this.idSubtool(nast.getModel()));
        } else {
            this.html.text(name);
        }
    }

    private String multiplicity(ArgumentModel<?> argument, String name) {
        name = "<" + name + ">";
        if (argument.getMultiplicity().isMultivalued()) {
            name = name + "...";
        }
        return name;
    }

    @Override
    public void startSynopsis(Synopsis synopsis) {
        this.hadFirstArgument = false;
        this.hadOptions = false;
        this.html.open("tr", "td");
        this.html.open("div class='synopsis'", "code");
        this.html.text(synopsis.getInvocation() + " ");
    }

    @Override
    public void endSynopsis(Synopsis synopsis) {
        ((Html)this.html.close("code", "div")).text("\n");
        this.html.close("td", "tr");
    }

    @Override
    public void visitSynopsisArgument(ArgumentModel<?> argument) {
        if (!this.hadFirstArgument) {
            this.html.text(" [--]");
            this.hadFirstArgument = true;
        }
        this.html.text(" ");
        String name = argument.getName();
        if (!argument.getMultiplicity().isRequired()) {
            this.html.text("[");
        }
        ((Html)this.html.text("<")).text(name);
        if (argument.getMultiplicity().isMultivalued()) {
            this.html.text("...");
        }
        this.html.text(">");
        if (!argument.getMultiplicity().isRequired()) {
            this.html.text("]");
        }
    }

    @Override
    public void visitSynopsisOption(OptionModel<?> option) {
        this.hadOptions = true;
        this.html.text(" ");
        ArgumentModel<?> argument = option.getArgument();
        if (!argument.getMultiplicity().isRequired()) {
            this.html.text("[");
        }
        if (option.getLongName() != null) {
            this.longOptionSynopsis(option);
            if (option.getArgumentType() == OptionModel.ArgumentType.REQUIRED) {
                this.html.text("=");
                this.html.text(this.multiplicity(argument, argument.getName()));
            } else if (option.getArgumentType() == OptionModel.ArgumentType.OPTIONAL) {
                this.html.text("[=");
                this.html.text(this.multiplicity(argument, argument.getName()));
                this.html.text("]");
            }
        } else {
            this.shortOptionSynopsis(option);
            if (option.getArgumentType() == OptionModel.ArgumentType.REQUIRED) {
                this.html.text(" ");
                this.html.text(this.multiplicity(argument, argument.getName()));
            }
        }
        if (!argument.getMultiplicity().isRequired()) {
            this.html.text("]");
        }
    }

    @Override
    public void endSynopses(SynopsesSection synopsesSection) {
        HtmlVisitor.addTableEnd(this.html);
        ((Html)this.html.close("div")).text("\n\n");
    }

    @Override
    public void visitDescription(DescribedSection descriptionSection) {
        this.describedSection(0, descriptionSection);
    }

    @Override
    public void visitSynopsisSubtool(SubtoolVisitor.ToolModelAndSubtoolModel option) {
        this.html.text(" ");
        this.subtoolSynopsis(option);
    }
}

