/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.PhasedUnitsModelLoader;
import com.redhat.ceylon.compiler.java.loader.SourceDeclarationVisitor;
import com.redhat.ceylon.compiler.java.util.Util;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.impl.reflect.model.ReflectionModule;
import com.redhat.ceylon.model.loader.impl.reflect.model.ReflectionModuleManager;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class PhasedUnitsModuleManager
extends ReflectionModuleManager {
    private List<ModuleSpec> modulesSpecs;
    private Callable<PhasedUnits> getPhasedUnits;
    private RepositoryManager outputRepositoryManager;
    private boolean bootstrapCeylon;
    private List<String> compiledClasses;

    public PhasedUnitsModuleManager(Callable<PhasedUnits> getPhasedUnits, Context context, List<ModuleSpec> modules, RepositoryManager outputRepositoryManager, boolean bootstrapCeylon, Logger log) {
        this.outputRepositoryManager = outputRepositoryManager;
        this.modulesSpecs = modules;
        this.getPhasedUnits = getPhasedUnits;
        this.bootstrapCeylon = bootstrapCeylon;
    }

    @Override
    protected void loadPackageDescriptors() {
        this.getModelLoader().loadPackageDescriptors();
    }

    @Override
    public boolean isModuleLoadedFromSource(String moduleName) {
        for (ModuleSpec spec : this.modulesSpecs) {
            if (!spec.getName().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    private void initTypeCheckedUnits() {
        for (PhasedUnit unit : this.getPhasedUnits().getPhasedUnits()) {
            final String pkgName = com.redhat.ceylon.ceylondoc.Util.getUnitPackageName(unit);
            unit.getCompilationUnit().visit(new SourceDeclarationVisitor(){

                @Override
                public void loadFromSource(Tree.Declaration decl) {
                    PhasedUnitsModuleManager.this.compiledClasses.add(com.redhat.ceylon.ceylondoc.Util.getQuotedFQN(pkgName, decl));
                }

                @Override
                public void loadFromSource(Tree.ModuleDescriptor that) {
                }

                @Override
                public void loadFromSource(Tree.PackageDescriptor that) {
                }
            });
        }
    }

    protected List<String> getCompiledClasses() {
        if (this.compiledClasses == null) {
            this.compiledClasses = new LinkedList<String>();
            this.initTypeCheckedUnits();
        }
        return this.compiledClasses;
    }

    @Override
    protected AbstractModelLoader createModelLoader(Modules modules) {
        return new PhasedUnitsModelLoader(this, modules, this.getPhasedUnits, this.bootstrapCeylon){

            @Override
            protected boolean isLoadedFromSource(String className) {
                return PhasedUnitsModuleManager.this.getCompiledClasses().contains(className);
            }

            @Override
            public ClassMirror lookupNewClassMirror(Module module, String name) {
                if (PhasedUnitsModuleManager.this.getCompiledClasses().contains(name)) {
                    this.logVerbose("Not loading " + name + " from class because we are typechecking them");
                    return null;
                }
                return super.lookupNewClassMirror(module, name);
            }

            @Override
            protected void logError(String message) {
                this.log.error(message);
            }

            @Override
            protected void logVerbose(String message) {
                this.log.debug(message);
            }

            @Override
            protected void logWarning(String message) {
                this.log.warning(message);
            }
        };
    }

    @Override
    public Package createPackage(String pkgName, Module module) {
        if ((pkgName.equals("ceylon.language") || pkgName.startsWith("ceylon.language.")) && this.isModuleLoadedFromSource("ceylon.language")) {
            return super.createPackage(pkgName, module);
        }
        LazyPackage pkg = new LazyPackage(this.getModelLoader());
        List<String> name = pkgName.isEmpty() ? Collections.emptyList() : PhasedUnitsModuleManager.splitModuleName(pkgName);
        pkg.setName(name);
        if (module != null) {
            module.getPackages().add(pkg);
            pkg.setModule(module);
        }
        return pkg;
    }

    @Override
    protected Module createModule(List<String> moduleName, String version2) {
        String name = Util.getName(moduleName);
        Module module = name.equals("ceylon.language") && this.isModuleLoadedFromSource("ceylon.language") ? new Module() : new ReflectionModule(this);
        module.setName(moduleName);
        module.setVersion(version2);
        if (module instanceof ReflectionModule) {
            this.setupIfJDKModule((LazyModule)module);
        }
        return module;
    }

    @Override
    public void modulesVisited() {
        try {
            super.modulesVisited();
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to find the language module sources in the specified source paths");
        }
        for (Module module : this.getModules().getListOfModules()) {
            if (!this.isModuleLoadedFromSource(module.getNameAsString())) continue;
            this.addOutputModuleToClassPath(module);
        }
    }

    private void addOutputModuleToClassPath(Module module) {
        ArtifactContext ctx = new ArtifactContext(null, module.getNameAsString(), module.getVersion(), ".car");
        ArtifactResult result = this.outputRepositoryManager.getArtifactResult(ctx);
        if (result != null) {
            this.getModelLoader().addModuleToClassPath(module, result);
        }
    }

    @Override
    public Backends getSupportedBackends() {
        return Backends.JAVA.merged(Backend.JavaScript);
    }

    private PhasedUnits getPhasedUnits() {
        try {
            return this.getPhasedUnits.call();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

