/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java;

import ceylon.language.Anything;
import ceylon.language.AssertionError;
import ceylon.language.Basic;
import ceylon.language.Boolean;
import ceylon.language.Byte;
import ceylon.language.Callable;
import ceylon.language.Finished;
import ceylon.language.Float;
import ceylon.language.Identifiable;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.List;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.OverflowException;
import ceylon.language.Ranged;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.Tuple;
import ceylon.language.empty_;
import ceylon.language.finished_;
import ceylon.language.impl.rethrow_;
import ceylon.language.meta.classDeclaration_;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.model.ClassOrInterface;
import ceylon.language.meta.model.Type;
import ceylon.language.meta.typeLiteral_;
import ceylon.language.meta.type_;
import ceylon.language.sequence_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.language.AbstractArrayIterable;
import com.redhat.ceylon.compiler.java.language.AbstractIterable;
import com.redhat.ceylon.compiler.java.language.AbstractIterator;
import com.redhat.ceylon.compiler.java.language.ObjectArray;
import com.redhat.ceylon.compiler.java.language.ObjectArrayIterable;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ClassOrInterfaceDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class Util {
    private static final int INIT_ARRAY_SIZE = 10;
    private static final java.lang.Object[] NO_ELEMENTS;
    private static HashMap<java.lang.Class<?>, Class> classCache;

    public static String declClassName(String name) {
        return name.replace("::", ".");
    }

    public static void loadModule(String name, String version2, ArtifactResult result, ClassLoader classLoader) {
        Metamodel.loadModule(name, version2, result, classLoader);
    }

    public static boolean isReified(java.lang.Object o, TypeDescriptor type) {
        return Metamodel.isReified(o, type);
    }

    private static Class getClassAnnotationForIdentifiableOrBasic(java.lang.Class<? extends java.lang.Object> klass) {
        if (classCache.containsKey(klass)) {
            return classCache.get(klass);
        }
        Class classAnnotation = klass.getAnnotation(Class.class);
        if (classAnnotation != null) {
            classCache.put(klass, classAnnotation);
            return classAnnotation;
        }
        if (klass != null && klass != java.lang.Object.class) {
            Class c = Util.getClassAnnotationForIdentifiableOrBasic(klass.getSuperclass());
            classCache.put(klass, c);
            return c;
        }
        return null;
    }

    public static boolean isIdentifiable(java.lang.Object o) {
        if (o == null) {
            return false;
        }
        return Util.isIdentifiable(o.getClass());
    }

    public static boolean isIdentifiable(java.lang.Class<?> klazz) {
        Class classAnnotation = Util.getClassAnnotationForIdentifiableOrBasic(klazz);
        return classAnnotation != null ? classAnnotation.identifiable() : true;
    }

    public static boolean isBasic(java.lang.Object o) {
        if (o == null) {
            return false;
        }
        return Util.isBasic(o.getClass());
    }

    public static boolean isBasic(java.lang.Class<?> klazz) {
        Class classAnnotation = Util.getClassAnnotationForIdentifiableOrBasic(klazz);
        return classAnnotation != null ? classAnnotation.basic() : true;
    }

    private static <T> int fastIterableSize(Iterable<? extends T, ?> iterable) {
        if (iterable instanceof Sequential || iterable instanceof AbstractArrayIterable) {
            return Util.toInt(iterable.getSize());
        }
        return -1;
    }

    private static <T> void fillArray(T[] array, int offset, Iterable<? extends T, ?> iterable) {
        java.lang.Object o;
        ceylon.language.Iterator<T> iterator = iterable.iterator();
        int index = offset;
        while ((o = iterator.next()) != finished_.get_()) {
            array[index] = o;
            ++index;
        }
    }

    public static boolean[] toBooleanArray(Iterable<? extends Boolean, ?> sequence, boolean ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toBooleanArray(list, initialElements);
        }
        BooleanArrayBuilder builder = new BooleanArrayBuilder(initialElements.length + 10);
        builder.appendArray(initialElements);
        ceylon.language.Iterator<? extends Boolean> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendBoolean(((Boolean)o).booleanValue());
        }
        return (boolean[])builder.build();
    }

    public static boolean[] toBooleanArray(List<? extends Boolean> list, boolean ... initialElements) {
        java.lang.Object o;
        if (list == null) {
            return initialElements;
        }
        int i = initialElements.length;
        boolean[] ret = new boolean[Util.toInt(list.getSize() + (long)i)];
        System.arraycopy(initialElements, 0, ret, 0, i);
        ceylon.language.Iterator<? extends Boolean> iterator = list.iterator();
        while ((o = iterator.next()) != finished_.get_()) {
            ret[i++] = ((Boolean)o).booleanValue();
        }
        return ret;
    }

    public static byte[] toByteArray(Iterable<? extends Byte, ?> sequence, byte ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toByteArray(list, initialElements);
        }
        ByteArrayBuilder builder = new ByteArrayBuilder(initialElements.length + 10);
        for (int i = 0; i < initialElements.length; ++i) {
            builder.appendByte(initialElements[i]);
        }
        ceylon.language.Iterator<? extends Byte> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendByte(((Byte)o).byteValue());
        }
        return (byte[])builder.build();
    }

    public static byte[] toByteArray(List<? extends Byte> list, byte ... initialElements) {
        byte[] ret = new byte[list == null ? 0 : Util.toInt(list.getSize()) + initialElements.length];
        for (int i = 0; i < initialElements.length; ++i) {
            ret[i] = initialElements[i];
        }
        if (list != null) {
            java.lang.Object o;
            ceylon.language.Iterator<? extends Byte> iterator = list.iterator();
            while ((o = iterator.next()) != finished_.get_()) {
                ret[i++] = ((Byte)o).byteValue();
            }
        }
        return ret;
    }

    public static short[] toShortArray(Iterable<? extends Integer, ?> sequence, long ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toShortArray(list, initialElements);
        }
        ShortArrayBuilder builder = new ShortArrayBuilder(initialElements.length + 10);
        for (int i = 0; i < initialElements.length; ++i) {
            builder.appendLong(initialElements[i]);
        }
        ceylon.language.Iterator<? extends Integer> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendLong(((Integer)o).longValue());
        }
        return (short[])builder.build();
    }

    public static short[] toShortArray(List<? extends Integer> list, long ... initialElements) {
        short[] ret = new short[list == null ? 0 : Util.toInt(list.getSize()) + initialElements.length];
        for (int i = 0; i < initialElements.length; ++i) {
            ret[i] = Util.toShort(initialElements[i]);
        }
        if (list != null) {
            java.lang.Object o;
            ceylon.language.Iterator<? extends Integer> iterator = list.iterator();
            while ((o = iterator.next()) != finished_.get_()) {
                ret[i++] = Util.toShort(((Integer)o).longValue());
            }
        }
        return ret;
    }

    public static int[] toIntArray(Iterable<? extends Integer, ?> sequence, long ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toIntArray(list, initialElements);
        }
        IntArrayBuilder builder = new IntArrayBuilder(initialElements.length + 10);
        for (int i = 0; i < initialElements.length; ++i) {
            builder.appendLong(initialElements[i]);
        }
        ceylon.language.Iterator<? extends Integer> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendLong(((Integer)o).longValue());
        }
        return (int[])builder.build();
    }

    public static int[] toIntArray(List<? extends Integer> list, long ... initialElements) {
        int[] ret = new int[list == null ? 0 : Util.toInt(list.getSize()) + initialElements.length];
        for (int i = 0; i < initialElements.length; ++i) {
            ret[i] = Util.toInt(initialElements[i]);
        }
        if (list != null) {
            java.lang.Object o;
            ceylon.language.Iterator<? extends Integer> iterator = list.iterator();
            while ((o = iterator.next()) != finished_.get_()) {
                ret[i++] = Util.toInt(((Integer)o).longValue());
            }
        }
        return ret;
    }

    public static long[] toLongArray(Iterable<? extends Integer, ?> sequence, long ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toLongArray(list, initialElements);
        }
        LongArrayBuilder builder = new LongArrayBuilder(initialElements.length + 10);
        builder.appendArray(initialElements);
        ceylon.language.Iterator<? extends Integer> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendLong(((Integer)o).longValue());
        }
        return (long[])builder.build();
    }

    public static long[] toLongArray(List<? extends Integer> list, long ... initialElements) {
        java.lang.Object o;
        if (list == null) {
            return initialElements;
        }
        int i = initialElements.length;
        long[] ret = new long[Util.toInt(list.getSize() + (long)i)];
        System.arraycopy(initialElements, 0, ret, 0, i);
        ceylon.language.Iterator<? extends Integer> iterator = list.iterator();
        while ((o = iterator.next()) != finished_.get_()) {
            ret[i++] = ((Integer)o).longValue();
        }
        return ret;
    }

    public static float[] toFloatArray(Iterable<? extends Float, ?> sequence, double ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toFloatArray(list, initialElements);
        }
        FloatArrayBuilder builder = new FloatArrayBuilder(initialElements.length + 10);
        for (int i = 0; i < initialElements.length; ++i) {
            builder.appendDouble(initialElements[i]);
        }
        ceylon.language.Iterator<? extends Float> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendDouble(((Float)o).doubleValue());
        }
        return (float[])builder.build();
    }

    public static float[] toFloatArray(List<? extends Float> list, double ... initialElements) {
        float[] ret = new float[list == null ? 0 : Util.toInt(list.getSize()) + initialElements.length];
        for (int i = 0; i < initialElements.length; ++i) {
            ret[i] = (float)initialElements[i];
        }
        if (list != null) {
            java.lang.Object o;
            ceylon.language.Iterator<? extends Float> iterator = list.iterator();
            while ((o = iterator.next()) != finished_.get_()) {
                ret[i++] = (float)((Float)o).doubleValue();
            }
        }
        return ret;
    }

    public static double[] toDoubleArray(Iterable<? extends Float, ?> sequence, double ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toDoubleArray(list, initialElements);
        }
        DoubleArrayBuilder builder = new DoubleArrayBuilder(initialElements.length + 10);
        builder.appendArray(initialElements);
        ceylon.language.Iterator<? extends Float> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendDouble(((Float)o).doubleValue());
        }
        return (double[])builder.build();
    }

    public static double[] toDoubleArray(List<? extends Float> list, double ... initialElements) {
        java.lang.Object o;
        if (list == null) {
            return initialElements;
        }
        int i = initialElements.length;
        double[] ret = new double[Util.toInt(list.getSize() + (long)i)];
        System.arraycopy(initialElements, 0, ret, 0, i);
        ceylon.language.Iterator<? extends Float> iterator = list.iterator();
        while ((o = iterator.next()) != finished_.get_()) {
            ret[i++] = ((Float)o).doubleValue();
        }
        return ret;
    }

    public static char[] toCharArray(Iterable<? extends ceylon.language.Character, ?> sequence, int ... initialElements) {
        java.lang.Object o;
        CharArrayBuilder builder = new CharArrayBuilder(initialElements.length + 10);
        for (int i = 0; i < initialElements.length; ++i) {
            builder.appendCodepoint(initialElements[i]);
        }
        ceylon.language.Iterator<? extends ceylon.language.Character> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendCodepoint(((ceylon.language.Character)o).codePoint);
        }
        return (char[])builder.build();
    }

    public static char[] toCharArray(List<? extends ceylon.language.Character> sequence, int ... initialElements) {
        return Util.toCharArray(sequence, initialElements);
    }

    public static int[] toCodepointArray(Iterable<? extends ceylon.language.Character, ?> sequence, int ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toCodepointArray(list, initialElements);
        }
        IntArrayBuilder builder = new IntArrayBuilder(initialElements.length + 10);
        builder.appendArray(initialElements);
        ceylon.language.Iterator<? extends ceylon.language.Character> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendInt(((ceylon.language.Character)o).codePoint);
        }
        return (int[])builder.build();
    }

    public static int[] toCodepointArray(List<? extends ceylon.language.Character> list, int ... initialElements) {
        java.lang.Object o;
        if (list == null) {
            return initialElements;
        }
        int i = initialElements.length;
        int[] ret = new int[Util.toInt(list.getSize() + (long)i)];
        System.arraycopy(initialElements, 0, ret, 0, i);
        ceylon.language.Iterator<? extends ceylon.language.Character> iterator = list.iterator();
        while ((o = iterator.next()) != finished_.get_()) {
            ret[i++] = ((ceylon.language.Character)o).intValue();
        }
        return ret;
    }

    public static String[] toJavaStringArray(Iterable<? extends ceylon.language.String, ?> sequence, String ... initialElements) {
        java.lang.Object o;
        if (sequence instanceof List) {
            List list = (List)sequence;
            return Util.toJavaStringArray(list, initialElements);
        }
        StringArrayBuilder builder = new StringArrayBuilder(initialElements.length + 10);
        builder.appendArray(initialElements);
        ceylon.language.Iterator<? extends ceylon.language.String> iterator = sequence.iterator();
        while (!((o = iterator.next()) instanceof Finished)) {
            builder.appendString(((ceylon.language.String)o).value);
        }
        return (String[])builder.build();
    }

    public static String[] toJavaStringArray(List<? extends ceylon.language.String> list, String ... initialElements) {
        java.lang.Object o;
        if (list == null) {
            return initialElements;
        }
        int i = initialElements.length;
        String[] ret = new String[Util.toInt(list.getSize() + (long)i)];
        System.arraycopy(initialElements, 0, ret, 0, i);
        ceylon.language.Iterator<? extends ceylon.language.String> iterator = list.iterator();
        while ((o = iterator.next()) != finished_.get_()) {
            ret[i++] = ((ceylon.language.String)o).toString();
        }
        return ret;
    }

    public static <T> T[] toArray(List<? extends T> sequence, T[] ret, T ... initialElements) {
        java.lang.Object o;
        int i;
        if (sequence == null) {
            return initialElements;
        }
        if (initialElements == null) {
            i = 1;
            ret[0] = null;
        } else {
            i = initialElements.length;
            System.arraycopy(initialElements, 0, ret, 0, i);
        }
        ceylon.language.Iterator<T> iterator = sequence.iterator();
        while ((o = iterator.next()) != finished_.get_()) {
            ret[i++] = o;
        }
        return ret;
    }

    public static <T> T[] toArray(Iterable<? extends T, ?> iterable, java.lang.Class<T> klass, T ... initialElements) {
        java.lang.Object[] ret;
        if (iterable == null) {
            return initialElements;
        }
        int size = Util.fastIterableSize(iterable);
        if (size != -1) {
            ret = (java.lang.Object[])Array.newInstance(klass, size + initialElements.length);
            if (initialElements.length != 0) {
                System.arraycopy(initialElements, 0, ret, 0, initialElements.length);
            }
            Util.fillArray(ret, initialElements.length, iterable);
        } else {
            java.lang.Object o;
            ReflectingObjectArrayBuilder<java.lang.Object> builder = new ReflectingObjectArrayBuilder<java.lang.Object>(initialElements.length + 10, klass);
            builder.appendArray(initialElements);
            ceylon.language.Iterator<T> iterator = iterable.iterator();
            while (!((o = iterator.next()) instanceof Finished)) {
                builder.appendRef(o);
            }
            ret = builder.build();
        }
        return ret;
    }

    public static <T> T[] toArray(List<? extends T> list, java.lang.Class<T> klass, T ... initialElements) {
        java.lang.Object o;
        if (list == null) {
            return initialElements;
        }
        int i = initialElements.length;
        java.lang.Object[] ret = (java.lang.Object[])Array.newInstance(klass, Util.toInt(list.getSize() + (long)i));
        System.arraycopy(initialElements, 0, ret, 0, i);
        ceylon.language.Iterator<T> iterator = list.iterator();
        while ((o = iterator.next()) != finished_.get_()) {
            ret[i++] = o;
        }
        return ret;
    }

    public static <T> T checkNull(T t) {
        if (t == null) {
            throw new AssertionError("null value returned from native call not assignable to Object");
        }
        return t;
    }

    public static String throwableMessage(Throwable t) {
        String message = t.getMessage();
        if (message == null) {
            Throwable c = t.getCause();
            message = c != null ? c.getMessage() : "";
        }
        return message;
    }

    public static <T> Sequential<T> sequentialWrapper(TypeDescriptor $reifiedT, T[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        return new Tuple($reifiedT, elements);
    }

    public static <T> Sequential<T> sequentialWrapperCopy(TypeDescriptor $reifiedT, T[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        return new Tuple($reifiedT, elements, empty_.get_(), true);
    }

    public static Sequential<? extends ceylon.language.String> sequentialWrapperBoxed(String[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (String element : elements) {
            newArray[i++] = ceylon.language.String.instance(element);
        }
        return new Tuple(ceylon.language.String.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends Integer> sequentialWrapperBoxed(byte[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (byte element : elements) {
            newArray[i++] = Byte.instance(element);
        }
        return new Tuple(Byte.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends Integer> sequentialWrapperBoxed(short[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (short element : elements) {
            newArray[i++] = Integer.instance(element);
        }
        return new Tuple(Integer.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends Integer> sequentialWrapperBoxedForInteger(int[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (int element : elements) {
            newArray[i++] = Integer.instance(element);
        }
        return new Tuple(Integer.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends Integer> sequentialWrapperBoxed(long[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (long element : elements) {
            newArray[i++] = Integer.instance(element);
        }
        return new Tuple(Integer.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends ceylon.language.Character> sequentialWrapperBoxed(char[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = Character.codePointCount(elements, 0, elements.length);
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        char lastHighSurrogate = '\u0000';
        for (char element : elements) {
            if (lastHighSurrogate != '\u0000') {
                if (Character.isLowSurrogate(element)) {
                    newArray[i++] = ceylon.language.Character.instance(Character.toCodePoint(lastHighSurrogate, element));
                    lastHighSurrogate = '\u0000';
                    continue;
                }
                throw new AssertionError("Illegal low surrogate value " + element + " after high surrogate value " + lastHighSurrogate);
            }
            if (Character.isHighSurrogate(element)) {
                lastHighSurrogate = element;
                continue;
            }
            if (Character.isLowSurrogate(element)) {
                throw new AssertionError("Illegal low surrogate value " + element + " after no high surrogate value");
            }
            newArray[i++] = ceylon.language.Character.instance(element);
        }
        if (lastHighSurrogate != '\u0000') {
            throw new AssertionError("Missing low surrogate value after high surrogate value " + lastHighSurrogate);
        }
        return new Tuple(ceylon.language.Character.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends ceylon.language.Character> sequentialWrapperBoxed(int[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (int element : elements) {
            newArray[i++] = ceylon.language.Character.instance(element);
        }
        return new Tuple(ceylon.language.Character.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends Boolean> sequentialWrapperBoxed(boolean[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (boolean element : elements) {
            newArray[i++] = Boolean.instance(element);
        }
        return new Tuple(Boolean.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends Float> sequentialWrapperBoxed(float[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (float element : elements) {
            newArray[i++] = Float.instance(element);
        }
        return new Tuple(Float.$TypeDescriptor$, newArray);
    }

    public static Sequential<? extends Float> sequentialWrapperBoxed(double[] elements) {
        if (elements.length == 0) {
            return empty_.get_();
        }
        int total = elements.length;
        java.lang.Object[] newArray = new java.lang.Object[total];
        int i = 0;
        for (double element : elements) {
            newArray[i++] = Float.instance(element);
        }
        return new Tuple(Float.$TypeDescriptor$, newArray);
    }

    @Deprecated
    public static <T> Sequential<? extends T> sequentialCopy(TypeDescriptor $reifiedT, Sequential<? extends T> rest, java.lang.Object ... elements) {
        return Util.sequentialCopy($reifiedT, 0, elements.length, elements, rest);
    }

    public static <T> Sequential<? extends T> sequentialCopy(TypeDescriptor $reifiedT, java.lang.Object[] initialElements, Sequential<? extends T> rest) {
        return Util.sequentialCopy($reifiedT, 0, initialElements.length, initialElements, rest);
    }

    public static <T> Sequential<? extends T> sequentialCopy(TypeDescriptor $reifiedT, int start, int length, java.lang.Object[] elements, Sequential<? extends T> rest) {
        return Util.sequentialCopy($reifiedT, start, length, elements, rest, false);
    }

    public static <T> Sequential<? extends T> sequentialCopy(TypeDescriptor $reifiedT, int start, int length, java.lang.Object[] elements, Sequential<? extends T> rest, boolean forceCopy) {
        java.lang.Object elem;
        if (length == 0) {
            if (rest.getEmpty()) {
                return empty_.get_();
            }
            if (!forceCopy) {
                return rest;
            }
        }
        if (rest.getEmpty()) {
            return ((ObjectArrayIterable)new ObjectArrayIterable($reifiedT, elements).skip(start)).take(length).sequence();
        }
        int total = Util.toInt(rest.getSize() + (long)length);
        java.lang.Object[] newArray = new java.lang.Object[total];
        System.arraycopy(elements, start, newArray, 0, length);
        ceylon.language.Iterator iterator = rest.iterator();
        int i = length;
        while ((elem = iterator.next()) != finished_.get_()) {
            newArray[i] = elem;
            ++i;
        }
        return new ObjectArrayIterable($reifiedT, newArray).sequence();
    }

    public static Sequential sequentialOf(TypeDescriptor reified$Element, Iterable iterable) {
        java.lang.Object result = sequence_.sequence(reified$Element, Null.$TypeDescriptor$, iterable);
        if (result == null) {
            return empty_.get_();
        }
        return (Sequential)result;
    }

    public static RuntimeException makeUnimplementedMixinAccessException() {
        return new RuntimeException("Internal error: should never be called");
    }

    public static Sequential<?> tuple_spanFrom(Ranged<?, ?, ?> tuple, Integer index) {
        Sequential seq = (Sequential)tuple;
        long i = index.longValue();
        while (i-- > 0L) {
            seq = seq.getRest();
        }
        return seq;
    }

    public static boolean[] fillArray(boolean[] array, boolean val) {
        Arrays.fill(array, val);
        return array;
    }

    public static byte[] fillArray(byte[] array, byte val) {
        Arrays.fill(array, val);
        return array;
    }

    public static short[] fillArray(short[] array, short val) {
        Arrays.fill(array, val);
        return array;
    }

    public static int[] fillArray(int[] array, int val) {
        Arrays.fill(array, val);
        return array;
    }

    public static long[] fillArray(long[] array, long val) {
        Arrays.fill(array, val);
        return array;
    }

    public static float[] fillArray(float[] array, float val) {
        Arrays.fill(array, val);
        return array;
    }

    public static double[] fillArray(double[] array, double val) {
        Arrays.fill(array, val);
        return array;
    }

    public static char[] fillArray(char[] array, char val) {
        Arrays.fill(array, val);
        return array;
    }

    public static <T> T[] fillArray(T[] array, T val) {
        Arrays.fill(array, val);
        return array;
    }

    private static void checkArrayElementType(TypeDescriptor $reifiedElement) {
        if ($reifiedElement instanceof TypeDescriptor.Composite) {
            throw new AssertionError("cannot create Java array with union or intersection element type " + $reifiedElement.toString());
        }
        if ($reifiedElement instanceof TypeDescriptor.Nothing) {
            throw new AssertionError("cannot create Java array with bottom element type Nothing");
        }
    }

    public static <T> T[] makeArray(TypeDescriptor $reifiedElement, int size) {
        Util.checkArrayElementType($reifiedElement);
        return (java.lang.Object[])Array.newInstance($reifiedElement.getArrayElementClass(), size);
    }

    public static <T> T[] makeArray(TypeDescriptor $reifiedElement, int ... dimensions) {
        Util.checkArrayElementType($reifiedElement);
        return (java.lang.Object[])Array.newInstance($reifiedElement.getArrayElementClass(), dimensions);
    }

    public static RuntimeException makeJavaArrayWrapperException() {
        return new RuntimeException("Internal error: should never be called");
    }

    public static void rethrow(Throwable t) {
        rethrow_.rethrow(t);
    }

    public static boolean eq(java.lang.Object a, java.lang.Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static <Return> Return apply(Callable<? extends Return> function, Sequential<? extends java.lang.Object> arguments) {
        return Util.apply(function, arguments, null);
    }

    public static <Return> Return apply(Callable<? extends Return> function, Sequential<? extends java.lang.Object> arguments, TypeDescriptor variadicElementType) {
        java.lang.Object it;
        short variadicParameterIndex = function.$getVariadicParameterIndex$();
        switch (Util.toInt(arguments.getSize())) {
            case 0: {
                return function.$call$();
            }
            case 1: {
                if (variadicParameterIndex == 0) {
                    return function.$callvariadic$(Util.safeSpanFrom(arguments, 0, variadicElementType));
                }
                return function.$call$(arguments.getFromFirst(0L));
            }
            case 2: {
                switch (variadicParameterIndex) {
                    case 0: {
                        return function.$callvariadic$(Util.safeSpanFrom(arguments, 0, variadicElementType));
                    }
                    case 1: {
                        return function.$callvariadic$(arguments.getFromFirst(0L), Util.safeSpanFrom(arguments, 1, variadicElementType));
                    }
                }
                return function.$call$(arguments.getFromFirst(0L), arguments.getFromFirst(1L));
            }
            case 3: {
                switch (variadicParameterIndex) {
                    case 0: {
                        return function.$callvariadic$(Util.safeSpanFrom(arguments, 0, variadicElementType));
                    }
                    case 1: {
                        return function.$callvariadic$(arguments.getFromFirst(0L), Util.safeSpanFrom(arguments, 1, variadicElementType));
                    }
                    case 2: {
                        return function.$callvariadic$(arguments.getFromFirst(0L), arguments.getFromFirst(1L), Util.safeSpanFrom(arguments, 2, variadicElementType));
                    }
                }
                return function.$call$(arguments.getFromFirst(0L), arguments.getFromFirst(1L), arguments.getFromFirst(2L));
            }
        }
        switch (variadicParameterIndex) {
            case 0: {
                return function.$callvariadic$(Util.safeSpanFrom(arguments, 0, variadicElementType));
            }
            case 1: {
                return function.$callvariadic$(arguments.getFromFirst(0L), Util.safeSpanFrom(arguments, 1, variadicElementType));
            }
            case 2: {
                return function.$callvariadic$(arguments.getFromFirst(0L), arguments.getFromFirst(1L), Util.safeSpanFrom(arguments, 2, variadicElementType));
            }
            case 3: {
                return function.$callvariadic$(arguments.getFromFirst(0L), arguments.getFromFirst(1L), arguments.getFromFirst(2L), Util.safeSpanFrom(arguments, 3, variadicElementType));
            }
            case -1: {
                java.lang.Object[] args = Util.toArray(arguments, new java.lang.Object[Util.toInt(arguments.getSize())], new java.lang.Object[0]);
                return function.$call$(args);
            }
        }
        int beforeVariadic = Math.min(Util.toInt(arguments.getSize()), variadicParameterIndex);
        boolean needsVariadic = (long)beforeVariadic < arguments.getSize();
        java.lang.Object[] args = new java.lang.Object[beforeVariadic + (needsVariadic ? 1 : 0)];
        ceylon.language.Iterator iterator = arguments.iterator();
        int i = 0;
        while (i < beforeVariadic && (it = iterator.next()) != finished_.get_()) {
            args[i++] = it;
        }
        if (needsVariadic) {
            args[i] = Util.safeSpanFrom(arguments, beforeVariadic, variadicElementType);
            return function.$callvariadic$(args);
        }
        return function.$call$(args);
    }

    private static Sequential<?> safeSpanFrom(Sequential<? extends java.lang.Object> arguments, int start, TypeDescriptor variadicElementType) {
        if (variadicElementType == null) {
            if (start == 0) {
                return arguments;
            }
            return arguments.spanFrom(Integer.instance(start));
        }
        Sequential ret = start == 0 ? arguments : arguments.spanFrom(Integer.instance(start));
        return Util.sequentialCopy(variadicElementType, 0, 0, NO_ELEMENTS, ret, true);
    }

    public static <T> java.lang.Class<T> getJavaClassForDescriptor(TypeDescriptor descriptor) {
        if (descriptor == TypeDescriptor.NothingType || descriptor == Object.$TypeDescriptor$ || descriptor == Anything.$TypeDescriptor$ || descriptor == Basic.$TypeDescriptor$ || descriptor == Null.$TypeDescriptor$ || descriptor == Identifiable.$TypeDescriptor$) {
            return java.lang.Object.class;
        }
        if (descriptor instanceof TypeDescriptor.Class) {
            return ((TypeDescriptor.Class)descriptor).getKlass();
        }
        if (descriptor instanceof TypeDescriptor.Member) {
            return Util.getJavaClassForDescriptor(((TypeDescriptor.Member)descriptor).getMember());
        }
        if (descriptor instanceof TypeDescriptor.Intersection) {
            return java.lang.Object.class;
        }
        if (descriptor instanceof TypeDescriptor.Union) {
            TypeDescriptor.Union union = (TypeDescriptor.Union)descriptor;
            TypeDescriptor[] members = union.getMembers();
            if (members.length == 2) {
                if (members[0] == Null.$TypeDescriptor$) {
                    return Util.getJavaClassForDescriptor(members[1]);
                }
                if (members[1] == Null.$TypeDescriptor$) {
                    return Util.getJavaClassForDescriptor(members[0]);
                }
            }
            return java.lang.Object.class;
        }
        return java.lang.Object.class;
    }

    public static int arrayLength(java.lang.Object array) {
        if (array instanceof java.lang.Object[]) {
            return ((java.lang.Object[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        throw new ClassCastException(Util.notArrayType(array));
    }

    public static long getIntegerArray(java.lang.Object array, int index) {
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        throw new ClassCastException(Util.notArrayType(array));
    }

    public static double getFloatArray(java.lang.Object array, int index) {
        if (array instanceof double[]) {
            return ((double[])array)[index];
        }
        if (array instanceof float[]) {
            return ((float[])array)[index];
        }
        throw new ClassCastException(Util.notArrayType(array));
    }

    public static int getCharacterArray(java.lang.Object array, int index) {
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        throw new ClassCastException(Util.notArrayType(array));
    }

    public static byte getByteArray(java.lang.Object array, int index) {
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        throw new ClassCastException(Util.notArrayType(array));
    }

    public static boolean getBooleanArray(java.lang.Object array, int index) {
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index];
        }
        throw new ClassCastException(Util.notArrayType(array));
    }

    public static String getStringArray(java.lang.Object array, int index) {
        if (array instanceof String[]) {
            return ((String[])array)[index];
        }
        throw new ClassCastException(Util.notArrayType(array));
    }

    public static java.lang.Object getObjectArray(java.lang.Object array, int index) {
        if (array instanceof java.lang.Object[]) {
            return ((java.lang.Object[])array)[index];
        }
        if (array instanceof boolean[]) {
            return Boolean.instance(((boolean[])array)[index]);
        }
        if (array instanceof float[]) {
            return Float.instance(((float[])array)[index]);
        }
        if (array instanceof double[]) {
            return Float.instance(((double[])array)[index]);
        }
        if (array instanceof char[]) {
            return ceylon.language.Character.instance(((char[])array)[index]);
        }
        if (array instanceof byte[]) {
            return Byte.instance(((byte[])array)[index]);
        }
        if (array instanceof short[]) {
            return Integer.instance(((short[])array)[index]);
        }
        if (array instanceof int[]) {
            return Integer.instance(((int[])array)[index]);
        }
        if (array instanceof long[]) {
            return Integer.instance(((long[])array)[index]);
        }
        throw new ClassCastException(Util.notArrayType(array));
    }

    private static String notArrayType(java.lang.Object obj) {
        return (obj == null ? "null" : obj.getClass().getName()) + " is not an array type";
    }

    public static Sequential<? extends Throwable> suppressedExceptions(@Name(value="exception") @TypeInfo(value="ceylon.language::Exception") Throwable exception) {
        java.lang.Object[] sup = exception.getSuppressed();
        if (sup.length > 0) {
            return new ObjectArrayIterable(TypeDescriptor.klass(Throwable.class, new TypeDescriptor[0]), sup).sequence();
        }
        return empty_.get_();
    }

    public static <T> Sequence<T> asSequence(Sequential<T> sequential) {
        if (sequential instanceof Sequence) {
            return (Sequence)sequential;
        }
        throw new AssertionError("Assertion failed: Sequence expected");
    }

    public static int toInt(long value) {
        int result = (int)value;
        if ((long)result != value) {
            throw new OverflowException(value + " cannot be safely converted into a 32-bit integer");
        }
        return result;
    }

    public static short toShort(long value) {
        short result = (short)value;
        if ((long)result != value) {
            throw new OverflowException(value + " cannot be safely converted into a 16-bit integer");
        }
        return result;
    }

    public static byte toByte(long value) {
        byte result = (byte)value;
        if ((long)result != value) {
            throw new OverflowException(value + " cannot be safely converted into a 8-bit integer");
        }
        return result;
    }

    public static MethodHandle setter(MethodHandles.Lookup lookup, String fieldName) throws ReflectiveOperationException {
        Field field = lookup.lookupClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        MethodHandle handle = lookup.unreflectSetter(field);
        return handle;
    }

    public static <T> Sequential<T> sequentialToTuple(TypeDescriptor $reifiedT, Sequential<T> elements) {
        java.lang.Object val;
        if (elements.getSize() == 0L) {
            return empty_.get_();
        }
        java.lang.Object[] array = new java.lang.Object[(int)elements.getSize()];
        ceylon.language.Iterator iterator = elements.iterator();
        int i = 0;
        while ((val = iterator.next()) != finished_.get_()) {
            array[i++] = val;
        }
        return new Tuple($reifiedT, array);
    }

    @NonNull
    public static <T> T assertExists(T instance) {
        if (instance == null) {
            throw new AssertionError("violated exists assertion");
        }
        return instance;
    }

    @NonNull
    public static <Element> Iterable<Element, java.lang.Object> toIterable(final @NonNull TypeDescriptor $reified$Element, final @NonNull java.lang.Iterable<Element> jit) {
        return new AbstractIterable<Element, java.lang.Object>($reified$Element, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Element> iterator() {
                return new AbstractIterator<Element>($reified$Element){
                    private static final long serialVersionUID = 1L;
                    private final Iterator<Element> it;
                    {
                        this.it = jit.iterator();
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.it.hasNext()) {
                            return this.it.next();
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static <Element> Iterable<Element, java.lang.Object> toIterable(final @NonNull TypeDescriptor $reified$Element, final @NonNull Element[] jit) {
        return new AbstractIterable<Element, java.lang.Object>($reified$Element, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Element> iterator() {
                return new AbstractIterator<Element>($reified$Element){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return jit[this.index++];
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static <Element> Iterable<Element, java.lang.Object> toIterable(@NonNull TypeDescriptor $reified$Element, final @NonNull Iterable<? extends Element, java.lang.Object> it) {
        return new AbstractIterable<Element, java.lang.Object>($reified$Element, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Element> iterator() {
                return it.iterator();
            }
        };
    }

    @NonNull
    public static Iterable<Boolean, java.lang.Object> toIterable(final @NonNull boolean[] jit) {
        return new AbstractIterable<Boolean, java.lang.Object>(Boolean.$TypeDescriptor$, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Boolean> iterator() {
                return new AbstractIterator<Boolean>(Boolean.$TypeDescriptor$){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return Boolean.instance(jit[this.index++]);
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static Iterable<Integer, java.lang.Object> toIterable(final @NonNull short[] jit) {
        return new AbstractIterable<Integer, java.lang.Object>(Integer.$TypeDescriptor$, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Integer> iterator() {
                return new AbstractIterator<Integer>(Integer.$TypeDescriptor$){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return Integer.instance(jit[this.index++]);
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static Iterable<Integer, java.lang.Object> toIterable(final @NonNull int[] jit) {
        return new AbstractIterable<Integer, java.lang.Object>(Integer.$TypeDescriptor$, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Integer> iterator() {
                return new AbstractIterator<Integer>(Integer.$TypeDescriptor$){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return Integer.instance(jit[this.index++]);
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static Iterable<Integer, java.lang.Object> toIterable(final @NonNull long[] jit) {
        return new AbstractIterable<Integer, java.lang.Object>(Integer.$TypeDescriptor$, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Integer> iterator() {
                return new AbstractIterator<Integer>(Integer.$TypeDescriptor$){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return Integer.instance(jit[this.index++]);
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static Iterable<Float, java.lang.Object> toIterable(final @NonNull float[] jit) {
        return new AbstractIterable<Float, java.lang.Object>(Float.$TypeDescriptor$, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Float> iterator() {
                return new AbstractIterator<Float>(Float.$TypeDescriptor$){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return Float.instance(jit[this.index++]);
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static Iterable<Float, java.lang.Object> toIterable(final @NonNull double[] jit) {
        return new AbstractIterable<Float, java.lang.Object>(Float.$TypeDescriptor$, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Float> iterator() {
                return new AbstractIterator<Float>(Float.$TypeDescriptor$){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return Float.instance(jit[this.index++]);
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static Iterable<ceylon.language.Character, java.lang.Object> toIterable(final @NonNull char[] jit) {
        return new AbstractIterable<ceylon.language.Character, java.lang.Object>(ceylon.language.Character.$TypeDescriptor$, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends ceylon.language.Character> iterator() {
                return new AbstractIterator<ceylon.language.Character>(ceylon.language.Character.$TypeDescriptor$){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return ceylon.language.Character.instance(jit[this.index++]);
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @NonNull
    public static Iterable<Byte, java.lang.Object> toIterable(final @NonNull byte[] jit) {
        return new AbstractIterable<Byte, java.lang.Object>(Byte.$TypeDescriptor$, Null.$TypeDescriptor$){
            private static final long serialVersionUID = 1L;

            @Override
            public ceylon.language.Iterator<? extends Byte> iterator() {
                return new AbstractIterator<Byte>(Byte.$TypeDescriptor$){
                    private static final long serialVersionUID = 1L;
                    private int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.index < jit.length) {
                            return Byte.instance(jit[this.index++]);
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    public static <T> java.lang.Class<? extends T> javaClassForModel(ClassOrInterface<? extends T> model) {
        ClassOrInterfaceDeclaration decl = model.getDeclaration();
        if (decl instanceof ClassOrInterfaceDeclarationImpl) {
            ClassOrInterfaceDeclarationImpl ci = (ClassOrInterfaceDeclarationImpl)decl;
            String prefix = null;
            while (ci.getJavaClass().equals(ObjectArray.class)) {
                model = (ClassOrInterface)model.getTypeArgumentList().getFromFirst(0L);
                decl = model.getDeclaration();
                ci = (ClassOrInterfaceDeclarationImpl)decl;
                prefix = prefix == null ? "[" : prefix + "[";
            }
            java.lang.Class<?> result = Util.classErasure(ci.getJavaClass());
            if (prefix != null) {
                String name = result.isArray() && result.getComponentType().isPrimitive() ? prefix + result.getName() : prefix + "L" + result.getName() + ";";
                try {
                    result = java.lang.Class.forName(name, false, result.getClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    Util.rethrow(e1);
                }
            }
            return result;
        }
        throw new AssertionError("Unsupported declaration type: " + decl);
    }

    public static <T> java.lang.Class<? extends T> classErasure(java.lang.Class<? extends T> klass) {
        return TypeDescriptor.klass(klass, new TypeDescriptor[0]).getArrayElementClass();
    }

    private static boolean hasReified(java.lang.Object instance) {
        return instance == null || instance instanceof ReifiedType;
    }

    private static String typeDescription(java.lang.Object instance) {
        if (Util.hasReified(instance)) {
            return "type " + type_.type(TypeDescriptor.Nothing.NothingType, instance).toString();
        }
        return classDeclaration_.classDeclaration(instance).toString();
    }

    public static String assertIsFailed(boolean negated, TypeDescriptor $reifiedType, @Nullable java.lang.Object operand) {
        String typeDescription = Util.typeDescription(operand);
        Type givenType = typeLiteral_.typeLiteral($reifiedType);
        String message = System.lineSeparator() + "\t\texpression has " + typeDescription;
        if (!Util.hasReified(operand) || !type_.type(TypeDescriptor.Nothing.NothingType, operand).exactly(givenType)) {
            message = message + " which is " + (negated ? "" : "not") + " a subtype of " + givenType;
        }
        return message;
    }

    public static String assertBinOpFailed(@Nullable java.lang.Object lhs, @Nullable java.lang.Object rhs) {
        String message = System.lineSeparator() + "\t\tleft-hand expression is " + (lhs == null ? "\u00abnull\u00bb" : lhs);
        message = message + System.lineSeparator() + "\t\tright-hand expression is " + (rhs == null ? "\u00abnull\u00bb" : rhs);
        if (!(Util.hasReified(lhs) && Util.hasReified(rhs) && type_.type(TypeDescriptor.Nothing.NothingType, lhs).exactly(type_.type(TypeDescriptor.Nothing.NothingType, rhs)))) {
            message = message + System.lineSeparator() + "\t\tleft-hand expression has " + Util.typeDescription(lhs);
            message = message + System.lineSeparator() + "\t\tright-hand expression has " + Util.typeDescription(rhs);
        }
        return message;
    }

    public static String assertWithinOpFailed(@NonNull java.lang.Object lhs, @NonNull java.lang.Object middle, @NonNull java.lang.Object rhs) {
        String message = System.lineSeparator() + "\t\tleft-hand expression is " + (lhs == null ? "\u00abnull\u00bb" : lhs);
        message = message + System.lineSeparator() + "\t\tmiddle expression is " + (rhs == null ? "\u00abnull\u00bb" : middle);
        message = message + System.lineSeparator() + "\t\tright-hand expression is " + (rhs == null ? "\u00abnull\u00bb" : rhs);
        return message;
    }

    public static long[] unwrapLongArray(java.lang.Object array) {
        java.lang.Object a = ((ceylon.language.Array)array).toArray();
        if (a instanceof long[]) {
            return (long[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[]");
    }

    public static int[] unwrapIntArray(java.lang.Object array) {
        java.lang.Object a = ((ceylon.language.Array)array).toArray();
        if (a instanceof int[]) {
            return (int[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[]");
    }

    public static short[] unwrapShortArray(ceylon.language.Array<? extends Short> array) {
        java.lang.Object a = array.toArray();
        if (a instanceof short[]) {
            return (short[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[]");
    }

    public static double[] unwrapDoubleArray(java.lang.Object array) {
        java.lang.Object a = ((ceylon.language.Array)array).toArray();
        if (a instanceof double[]) {
            return (double[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[]");
    }

    public static float[] unwrapFloatArray(ceylon.language.Array<? extends java.lang.Float> array) {
        java.lang.Object a = array.toArray();
        if (a instanceof float[]) {
            return (float[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[]");
    }

    public static char[] unwrapCharArray(java.lang.Object array) {
        java.lang.Object a = ((ceylon.language.Array)array).toArray();
        if (a instanceof char[]) {
            return (char[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[]");
    }

    public static byte[] unwrapByteArray(java.lang.Object array) {
        java.lang.Object a = ((ceylon.language.Array)array).toArray();
        if (a instanceof byte[]) {
            return (byte[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[]");
    }

    public static boolean[] unwrapBooleanArray(java.lang.Object array) {
        java.lang.Object a = ((ceylon.language.Array)array).toArray();
        if (a instanceof boolean[]) {
            return (boolean[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[]");
    }

    public static <T> T[] unwrapObjectArray(TypeDescriptor $reified$T, ceylon.language.Array<T> array) {
        java.lang.Object a = array.toArray();
        if (a instanceof java.lang.Object[]) {
            return (java.lang.Object[])a;
        }
        throw new AssertionError("unexpected array " + a.getClass().getComponentType().getName() + "[] with type " + $reified$T);
    }

    static {
        rethrow_.class.toString();
        NO_ELEMENTS = new java.lang.Object[0];
        classCache = new HashMap();
    }

    static final class StringArrayBuilder
    extends ArrayBuilder<String[]> {
        StringArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected String[] allocate(int size) {
            return new String[size];
        }

        @Override
        protected int size(String[] array) {
            return array.length;
        }

        void appendString(String b) {
            this.ensure(this.size + 1);
            ((String[])this.array)[this.size] = b;
            ++this.size;
        }

        void appendCeylonString(ceylon.language.String javaString) {
            this.appendString(javaString.value);
        }
    }

    static final class CharArrayBuilder
    extends ArrayBuilder<char[]> {
        CharArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected char[] allocate(int size) {
            return new char[size];
        }

        @Override
        protected int size(char[] array) {
            return array.length;
        }

        void appendChar(char b) {
            this.ensure(this.size + 1);
            ((char[])this.array)[this.size] = b;
            ++this.size;
        }

        void appendCodepoint(int codepoint) {
            if (Character.charCount(codepoint) == 1) {
                this.appendChar((char)codepoint);
            } else {
                this.appendChar(Character.highSurrogate(codepoint));
                this.appendChar(Character.lowSurrogate(codepoint));
            }
        }
    }

    static final class FloatArrayBuilder
    extends ArrayBuilder<float[]> {
        FloatArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected float[] allocate(int size) {
            return new float[size];
        }

        @Override
        protected int size(float[] array) {
            return array.length;
        }

        void appendFloat(float i) {
            this.ensure(this.size + 1);
            ((float[])this.array)[this.size] = i;
            ++this.size;
        }

        void appendDouble(double d) {
            this.appendFloat((float)d);
        }
    }

    static final class DoubleArrayBuilder
    extends ArrayBuilder<double[]> {
        DoubleArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected double[] allocate(int size) {
            return new double[size];
        }

        @Override
        protected int size(double[] array) {
            return array.length;
        }

        void appendDouble(double i) {
            this.ensure(this.size + 1);
            ((double[])this.array)[this.size] = i;
            ++this.size;
        }
    }

    static final class ShortArrayBuilder
    extends ArrayBuilder<short[]> {
        ShortArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected short[] allocate(int size) {
            return new short[size];
        }

        @Override
        protected int size(short[] array) {
            return array.length;
        }

        void appendShort(short b) {
            this.ensure(this.size + 1);
            ((short[])this.array)[this.size] = b;
            ++this.size;
        }

        void appendLong(long b) {
            this.appendShort(Util.toShort(b));
        }
    }

    static final class ByteArrayBuilder
    extends ArrayBuilder<byte[]> {
        ByteArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected byte[] allocate(int size) {
            return new byte[size];
        }

        @Override
        protected int size(byte[] array) {
            return array.length;
        }

        void appendByte(byte b) {
            this.ensure(this.size + 1);
            ((byte[])this.array)[this.size] = b;
            ++this.size;
        }
    }

    static final class BooleanArrayBuilder
    extends ArrayBuilder<boolean[]> {
        BooleanArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected boolean[] allocate(int size) {
            return new boolean[size];
        }

        @Override
        protected int size(boolean[] array) {
            return array.length;
        }

        void appendBoolean(boolean b) {
            this.ensure(this.size + 1);
            ((boolean[])this.array)[this.size] = b;
            ++this.size;
        }
    }

    static final class LongArrayBuilder
    extends ArrayBuilder<long[]> {
        LongArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected long[] allocate(int size) {
            return new long[size];
        }

        @Override
        protected int size(long[] array) {
            return array.length;
        }

        void appendLong(long i) {
            this.ensure(this.size + 1);
            ((long[])this.array)[this.size] = i;
            ++this.size;
        }
    }

    static final class IntArrayBuilder
    extends ArrayBuilder<int[]> {
        IntArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected int[] allocate(int size) {
            return new int[size];
        }

        @Override
        protected int size(int[] array) {
            return array.length;
        }

        void appendInt(int i) {
            this.ensure(this.size + 1);
            ((int[])this.array)[this.size] = i;
            ++this.size;
        }

        void appendLong(long i) {
            this.appendInt(Util.toInt(i));
        }
    }

    public static final class ReflectingObjectArrayBuilder<T>
    extends ArrayBuilder<T[]> {
        private final java.lang.Class<T> klass;

        public ReflectingObjectArrayBuilder(int initialSize, java.lang.Class<T> klass) {
            super(initialSize);
            this.klass = klass;
        }

        @Override
        protected T[] allocate(int size) {
            return new java.lang.Object[size];
        }

        @Override
        protected int size(T[] array) {
            return array.length;
        }

        public void appendRef(T t) {
            this.ensure(this.size + 1);
            ((java.lang.Object[])this.array)[this.size] = t;
            ++this.size;
        }

        @Override
        public T[] build() {
            java.lang.Object[] result = (java.lang.Object[])Array.newInstance(this.klass, this.size);
            System.arraycopy(this.array, 0, result, 0, this.size);
            return result;
        }
    }

    static final class ObjectArrayBuilder
    extends ArrayBuilder<java.lang.Object[]> {
        ObjectArrayBuilder(int initialSize) {
            super(initialSize);
        }

        @Override
        protected java.lang.Object[] allocate(int size) {
            return new java.lang.Object[size];
        }

        @Override
        protected int size(java.lang.Object[] array) {
            return array.length;
        }

        void appendRef(java.lang.Object t) {
            this.ensure(this.size + 1);
            ((java.lang.Object[])this.array)[this.size] = t;
            ++this.size;
        }
    }

    public static abstract class ArrayBuilder<A> {
        private static final int MIN_CAPACITY = 5;
        private static final int MAX_CAPACITY = java.lang.Integer.MAX_VALUE;
        protected int size;
        protected int capacity;
        protected A array;

        ArrayBuilder(int initialSize) {
            this.capacity = Math.max(initialSize, 5);
            this.array = this.allocate(this.capacity);
            this.size = 0;
        }

        final void appendArray(A elements) {
            int increment = this.size(elements);
            int newsize = this.size + increment;
            this.ensure(newsize);
            System.arraycopy(elements, 0, this.array, this.size, increment);
            this.size = newsize;
        }

        protected final void ensure(int requestedCapacity) {
            if (this.capacity >= requestedCapacity) {
                return;
            }
            int newcapacity = requestedCapacity + (requestedCapacity >> 1);
            if (newcapacity < 5) {
                newcapacity = 5;
            } else if (newcapacity > java.lang.Integer.MAX_VALUE && (newcapacity = requestedCapacity) > java.lang.Integer.MAX_VALUE) {
                throw new AssertionError("can't allocate array bigger than 2147483647");
            }
            A newArray = this.allocate(newcapacity);
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.capacity = newcapacity;
            this.array = newArray;
        }

        protected abstract A allocate(int var1);

        protected abstract int size(A var1);

        A build() {
            if (this.capacity == this.size) {
                return this.array;
            }
            A result = this.allocate(this.size);
            System.arraycopy(this.array, 0, result, 0, this.size);
            return result;
        }
    }
}

