/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.BooleanUtil;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import java.util.List;
import java.util.Stack;

public abstract class BoxingVisitor
extends Visitor {
    private Stack<Boolean> nextPreferredExpressionBoxings = null;
    private Boolean preferredExpressionBoxing = null;

    protected abstract boolean isBooleanTrue(Declaration var1);

    protected abstract boolean isBooleanFalse(Declaration var1);

    protected abstract boolean hasErasure(Type var1);

    protected abstract boolean hasErasedTypeParameters(Reference var1);

    protected abstract boolean willEraseToObject(Type var1);

    protected abstract boolean willEraseToSequence(Type var1);

    protected abstract boolean isTypeParameter(Type var1);

    protected abstract boolean isRaw(Type var1);

    protected abstract boolean needsRawCastForMixinSuperCall(TypeDeclaration var1, Type var2);

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        super.visit(that);
        if (that.getDeclaration() == null) {
            return;
        }
        TypedDeclaration decl = (TypedDeclaration)that.getDeclaration();
        if (CodegenUtil.isUnBoxed(decl) || this.isBooleanTrue(decl) || this.isBooleanFalse(decl)) {
            CodegenUtil.markUnBoxed(that);
        }
        if (CodegenUtil.isRaw(decl)) {
            CodegenUtil.markRaw(that);
        }
        if (CodegenUtil.hasTypeErased(decl)) {
            CodegenUtil.markTypeErased(that);
        }
        if (CodegenUtil.hasUntrustedType(decl)) {
            CodegenUtil.markUntrustedType(that);
        }
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression that) {
        Type primaryType;
        Reference target;
        super.visit(that);
        if (that.getDeclaration() == null) {
            return;
        }
        if (that.getMemberOperator() instanceof Tree.SafeMemberOp) {
            TypedDeclaration decl = (TypedDeclaration)that.getDeclaration();
            if (CodegenUtil.isRaw(decl)) {
                CodegenUtil.markRaw(that);
            }
            if (CodegenUtil.hasTypeErased(decl)) {
                CodegenUtil.markTypeErased(that);
            }
            if (CodegenUtil.hasUntrustedType(decl) || this.hasTypeParameterWithConstraintsOutsideScope(decl.getType(), that.getScope())) {
                CodegenUtil.markUntrustedType(that);
            }
        } else if (that.getMemberOperator() instanceof Tree.MemberOp && Decl.isValueTypeDecl(that.getPrimary()) && CodegenUtil.isUnBoxed(that.getPrimary())) {
            if (Decl.isValueTypeDecl((TypedDeclaration)that.getDeclaration()) || that.getDeclaration() instanceof Function && ((Function)that.getDeclaration()).isDeclaredVoid()) {
                CodegenUtil.markUnBoxed(that);
            }
            if (CodegenUtil.isRaw((TypedDeclaration)that.getDeclaration())) {
                CodegenUtil.markRaw(that);
            }
            if (CodegenUtil.hasTypeErased((TypedDeclaration)that.getDeclaration())) {
                CodegenUtil.markTypeErased(that);
            }
        } else {
            this.propagateFromDeclaration(that, (TypedDeclaration)that.getDeclaration());
        }
        if (that.getMemberOperator() instanceof Tree.SpreadOp) {
            Type elementType = that.getTarget().getType();
            CodegenUtil.markTypeErased(that, this.hasErasure(elementType));
        }
        if (ExpressionTransformer.isSuperOrSuperOf(that.getPrimary()) && (target = that.getTarget()) != null && target.getQualifyingType() != null && target.getQualifyingType().getDeclaration() instanceof Interface) {
            if (this.isRaw(target.getQualifyingType())) {
                CodegenUtil.markTypeErased(that);
            } else {
                TypeDeclaration declaration = target.getQualifyingType().getDeclaration();
                if (this.needsRawCastForMixinSuperCall(declaration, target.getType())) {
                    CodegenUtil.markTypeErased(that);
                }
            }
        }
        if ((primaryType = that.getPrimary() instanceof Tree.Package || that.getTarget() == null ? that.getPrimary().getTypeModel() : that.getTarget().getQualifyingType()) != null && (this.isRaw(primaryType) || this.willEraseToSequence(primaryType)) && that.getTarget() != null && that.getTarget().getDeclaration() instanceof TypedDeclaration && CodegenUtil.containsTypeParameter(((TypedDeclaration)that.getTarget().getDeclaration()).getType())) {
            CodegenUtil.markTypeErased(that);
        }
        if (this.isRaw(primaryType) && !that.getTypeModel().getDeclaration().getTypeParameters().isEmpty()) {
            CodegenUtil.markRaw(that);
        }
    }

    @Override
    public void visit(Tree.Expression that) {
        Tree.MemberOrTypeExpression expr;
        Stack<Boolean> npebs = this.setPEB();
        super.visit(that);
        this.resetPEB(npebs);
        Tree.Term term = that.getTerm();
        this.propagateFromTerm(that, term);
        if (term instanceof Tree.MemberOrTypeExpression && (expr = (Tree.MemberOrTypeExpression)term).getDeclaration() instanceof Function) {
            that.setUnboxed(false);
        }
    }

    @Override
    public void visit(Tree.InvocationExpression that) {
        Constructor ctor;
        Function mth;
        Tree.StaticMemberOrTypeExpression expr;
        super.visit(that);
        if (AnalyzerUtil.isIndirectInvocation(that, true) && !Decl.isJavaStaticOrInterfacePrimary(that.getPrimary())) {
            if (that.getPrimary().getTypeModel() != null && this.isRaw(that.getPrimary().getTypeModel())) {
                CodegenUtil.markTypeErased(that);
            }
            return;
        }
        if (this.isByteLiteral(that)) {
            CodegenUtil.markUnBoxed(that);
        } else {
            this.propagateFromTerm(that, that.getPrimary());
        }
        if (that.getPrimary() instanceof Tree.StaticMemberOrTypeExpression && (expr = (Tree.StaticMemberOrTypeExpression)that.getPrimary()).getDeclaration() instanceof Function && this.isTypeParameter((mth = (Function)expr.getDeclaration()).getType()) && (this.hasErasedTypeParameter(expr.getTarget(), expr.getTypeArguments()) || CodegenUtil.isRaw(that))) {
            CodegenUtil.markTypeErased(that);
            CodegenUtil.markUntrustedType(that);
        }
        if (that.getPrimary() instanceof Tree.MemberOrTypeExpression && Decl.isConstructor(((Tree.MemberOrTypeExpression)that.getPrimary()).getDeclaration()) && Decl.isJavaObjectArrayWith(ctor = Decl.getConstructor(((Tree.MemberOrTypeExpression)that.getPrimary()).getDeclaration()))) {
            CodegenUtil.markTypeErased(that);
        }
    }

    private boolean isByteLiteral(Tree.InvocationExpression ce) {
        Tree.PositionalArgument argument;
        List<Tree.PositionalArgument> positionalArguments;
        if (ce.getPrimary() instanceof Tree.BaseTypeExpression && ce.getPositionalArgumentList() != null && (positionalArguments = ce.getPositionalArgumentList().getPositionalArguments()).size() == 1 && (argument = positionalArguments.get(0)) instanceof Tree.ListedArgument && ((Tree.ListedArgument)argument).getExpression() != null) {
            String name;
            Declaration decl;
            Tree.Term term = ((Tree.ListedArgument)argument).getExpression().getTerm();
            if (term instanceof Tree.NegativeOp) {
                term = ((Tree.NegativeOp)term).getTerm();
            }
            if (term instanceof Tree.NaturalLiteral && (decl = ((Tree.BaseTypeExpression)ce.getPrimary()).getDeclaration()) instanceof Class && (name = decl.getQualifiedNameString()).equals("ceylon.language::Byte")) {
                return true;
            }
        }
        return false;
    }

    private boolean hasErasedTypeParameter(Reference producedReference, Tree.TypeArguments typeArguments) {
        if (typeArguments != null && typeArguments.getTypeModels() != null) {
            for (Type arg : typeArguments.getTypeModels()) {
                if (!this.hasErasure(arg)) continue;
                return true;
            }
        }
        return this.hasErasedTypeParameters(producedReference);
    }

    @Override
    public void visit(Tree.ParameterizedExpression that) {
        super.visit(that);
        this.propagateFromTerm(that, that.getPrimary());
    }

    @Override
    public void visit(Tree.IndexExpression that) {
        super.visit(that);
        if (that.getPrimary() == null || that.getPrimary().getTypeModel() == null) {
            return;
        }
        Type lhsModel = that.getPrimary().getTypeModel();
        if (lhsModel.getDeclaration() == null) {
            return;
        }
        String methodName = that.getElementOrRange() instanceof Tree.Element ? "get" : "span";
        TypedDeclaration member = (TypedDeclaration)lhsModel.getDeclaration().getMember(methodName, null, false);
        if (member == null) {
            return;
        }
        this.propagateFromDeclaration(that, member);
        if (member.getType().getUnderlyingType() != null) {
            Type type = that.getTypeModel();
            if (type.isCached()) {
                type = type.clone();
            }
            type.setUnderlyingType(member.getType().getUnderlyingType());
            that.setTypeModel(type);
        }
    }

    @Override
    public void visit(Tree.NaturalLiteral that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.FloatLiteral that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.StringLiteral that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.CharLiteral that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.StringTemplate that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.PositiveOp that) {
        super.visit(that);
        this.propagateBoxingFromTerm(that, that.getTerm());
    }

    @Override
    public void visit(Tree.NegativeOp that) {
        super.visit(that);
        this.propagateBoxingFromTerm(that, that.getTerm());
    }

    @Override
    public void visit(Tree.ArithmeticOp that) {
        super.visit(that);
        if (that.getLeftTerm().getUnboxed() || that.getRightTerm().getUnboxed() || BooleanUtil.isFalse(this.preferredExpressionBoxing)) {
            CodegenUtil.markUnBoxed(that);
        }
    }

    @Override
    public void visit(Tree.ArithmeticAssignmentOp that) {
        super.visit(that);
        if (that.getLeftTerm().getUnboxed() && that.getRightTerm().getUnboxed()) {
            CodegenUtil.markUnBoxed(that);
        }
    }

    @Override
    public void visit(Tree.PostfixOperatorExpression that) {
        super.visit(that);
        this.propagateBoxingFromTerm(that, that.getTerm());
    }

    @Override
    public void visit(Tree.PrefixOperatorExpression that) {
        super.visit(that);
        this.propagateBoxingFromTerm(that, that.getTerm());
    }

    @Override
    public void visit(Tree.NotOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.LogicalOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.AssignOp that) {
        super.visit(that);
        this.propagateFromTerm(that, that.getLeftTerm());
    }

    @Override
    public void visit(Tree.LogicalAssignmentOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.EqualityOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.IdenticalOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.ComparisonOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.CompareOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.WithinOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.Bound that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.InOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.IsOp that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.Nonempty that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    @Override
    public void visit(Tree.Exists that) {
        super.visit(that);
        CodegenUtil.markUnBoxed(that);
    }

    private void propagateFromDeclaration(Tree.Term that, TypedDeclaration decl) {
        if (CodegenUtil.isUnBoxed(decl)) {
            CodegenUtil.markUnBoxed(that);
        }
        if (CodegenUtil.isRaw(decl)) {
            CodegenUtil.markRaw(that);
        }
        if (CodegenUtil.hasTypeErased(decl)) {
            CodegenUtil.markTypeErased(that);
        }
        if (CodegenUtil.hasUntrustedType(decl) || this.hasTypeParameterWithConstraintsOutsideScope(decl.getType(), that.getScope())) {
            CodegenUtil.markUntrustedType(that);
        }
    }

    private void propagateBoxingFromTerm(Tree.Term that, Tree.Term term) {
        if (CodegenUtil.isUnBoxed(term)) {
            CodegenUtil.markUnBoxed(that);
        }
    }

    private void propagateFromTerm(Tree.Term that, Tree.Term term) {
        if (CodegenUtil.isUnBoxed(term)) {
            CodegenUtil.markUnBoxed(that);
        }
        if (CodegenUtil.isRaw(term)) {
            CodegenUtil.markRaw(that);
        }
        if (CodegenUtil.hasTypeErased(term)) {
            CodegenUtil.markTypeErased(that);
        }
        if (CodegenUtil.hasUntrustedType(term)) {
            CodegenUtil.markUntrustedType(that);
        }
    }

    private boolean hasTypeParameterWithConstraintsOutsideScope(Type type, Scope scope) {
        return this.hasTypeParameterWithConstraintsOutsideScopeResolved(type != null ? type.resolveAliases() : null, scope);
    }

    private boolean hasTypeParameterWithConstraintsOutsideScopeResolved(Type type, Scope scope) {
        if (type == null) {
            return false;
        }
        if (type.isUnion()) {
            List<Type> caseTypes = type.getCaseTypes();
            for (Type pt : caseTypes) {
                if (!this.hasTypeParameterWithConstraintsOutsideScopeResolved(pt, scope)) continue;
                return true;
            }
            return false;
        }
        if (type.isIntersection()) {
            List<Type> satisfiedTypes = type.getSatisfiedTypes();
            for (Type pt : satisfiedTypes) {
                if (!this.hasTypeParameterWithConstraintsOutsideScopeResolved(pt, scope)) continue;
                return true;
            }
            return false;
        }
        TypeDeclaration declaration = type.getDeclaration();
        if (declaration == null) {
            return false;
        }
        if (type.isTypeParameter()) {
            Scope typeParameterScope = declaration.getContainer();
            while (scope != null) {
                if (Decl.equalScopes(scope, typeParameterScope)) {
                    return false;
                }
                scope = scope.getContainer();
            }
            TypeParameter tp = (TypeParameter)declaration;
            Boolean nonErasedBounds = tp.hasNonErasedBounds();
            if (nonErasedBounds == null) {
                this.visitTypeParameter(tp);
            }
            return nonErasedBounds != null ? nonErasedBounds : false;
        }
        for (Type pt : type.getTypeArgumentList()) {
            if (!this.hasTypeParameterWithConstraintsOutsideScopeResolved(pt, scope)) continue;
            return true;
        }
        return false;
    }

    private void visitTypeParameter(TypeParameter typeParameter) {
        if (typeParameter.hasNonErasedBounds() != null) {
            return;
        }
        for (Type pt : typeParameter.getSatisfiedTypes()) {
            if (this.willEraseToObject(pt)) continue;
            typeParameter.setNonErasedBounds(true);
            return;
        }
        typeParameter.setNonErasedBounds(false);
    }

    @Override
    public void visit(Tree.TypeLiteral that) {
        super.visit(that);
        if (!that.getWantsDeclaration()) {
            CodegenUtil.markRaw(that);
        }
    }

    @Override
    public void visit(Tree.IfExpression that) {
        super.visit(that);
        if (that.getIfClause() == null || that.getElseClause() == null) {
            return;
        }
        Tree.Expression ifExpr = that.getIfClause().getExpression();
        Tree.Expression elseExpr = that.getElseClause().getExpression();
        if (ifExpr == null || elseExpr == null) {
            return;
        }
        if (CodegenUtil.isUnBoxed(ifExpr) && CodegenUtil.isUnBoxed(elseExpr) && !this.willEraseToObject(that.getUnit().denotableType(that.getTypeModel()))) {
            CodegenUtil.markUnBoxed(that);
        }
        if (that.getTypeModel().isExactly(that.getUnit().getNullValueType())) {
            CodegenUtil.markTypeErased(that);
        }
    }

    @Override
    public void visit(Tree.SwitchExpression that) {
        super.visit(that);
        Tree.SwitchCaseList caseList = that.getSwitchCaseList();
        if (caseList == null || caseList.getCaseClauses() == null) {
            return;
        }
        boolean unboxed = true;
        for (Tree.CaseClause caseClause : caseList.getCaseClauses()) {
            Tree.Expression expr = caseClause.getExpression();
            if (expr == null) {
                return;
            }
            if (CodegenUtil.isUnBoxed(expr)) continue;
            unboxed = false;
        }
        if (caseList.getElseClause() != null) {
            Tree.Expression expr = caseList.getElseClause().getExpression();
            if (expr == null) {
                return;
            }
            if (!CodegenUtil.isUnBoxed(expr)) {
                unboxed = false;
            }
        }
        if (unboxed && !this.willEraseToObject(that.getUnit().denotableType(that.getTypeModel()))) {
            CodegenUtil.markUnBoxed(that);
        }
        if (that.getTypeModel().isExactly(that.getUnit().getNullValueType())) {
            CodegenUtil.markTypeErased(that);
        }
    }

    @Override
    public void visit(Tree.LetExpression that) {
        super.visit(that);
        if (that.getLetClause() == null || that.getLetClause().getExpression() == null) {
            return;
        }
        this.propagateFromTerm(that, that.getLetClause().getExpression());
    }

    @Override
    public void visit(Tree.DefaultOp that) {
        super.visit(that);
        if (TreeUtil.unwrapExpressionUntilTerm(that.getLeftTerm()) instanceof Tree.ThenOp) {
            Tree.ThenOp then = (Tree.ThenOp)TreeUtil.unwrapExpressionUntilTerm(that.getLeftTerm());
            if (CodegenUtil.isUnBoxed(that.getRightTerm()) && CodegenUtil.isUnBoxed(then.getRightTerm()) && !this.willEraseToObject(that.getUnit().denotableType(that.getTypeModel()))) {
                CodegenUtil.markUnBoxed(that);
            }
        }
    }

    @Override
    public void visit(Tree.Parameter that) {
        if (that.getParameterModel().getModel() == null) {
            return;
        }
        Boolean currentPEB = this.setNextPEBs(that.getParameterModel().getModel().getUnboxed());
        super.visit(that);
        this.preferredExpressionBoxing = currentPEB;
    }

    @Override
    public void visit(Tree.ElementRange that) {
        Boolean currentPEB = this.setNextPEBs(false, true);
        super.visit(that);
        this.preferredExpressionBoxing = currentPEB;
    }

    private Boolean setNextPEBs(Boolean ... boxings) {
        this.nextPreferredExpressionBoxings = new Stack();
        for (Boolean b : boxings) {
            this.nextPreferredExpressionBoxings.push(b);
        }
        return this.preferredExpressionBoxing;
    }

    private Stack<Boolean> setPEB() {
        Stack<Boolean> npebs = this.nextPreferredExpressionBoxings;
        this.preferredExpressionBoxing = npebs != null && !npebs.isEmpty() ? npebs.pop() : null;
        this.nextPreferredExpressionBoxings = null;
        return npebs;
    }

    private void resetPEB(Stack<Boolean> npebs) {
        this.preferredExpressionBoxing = null;
        this.nextPreferredExpressionBoxings = npebs;
    }
}

