/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.java.codegen.LiteralAnnotationTerm;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import java.util.ArrayList;
import java.util.List;

public class CollectionLiteralAnnotationTerm
extends LiteralAnnotationTerm {
    private final List<AnnotationTerm> elements;
    private final LiteralAnnotationTerm factory;

    public CollectionLiteralAnnotationTerm(LiteralAnnotationTerm factory) {
        this.factory = factory;
        this.elements = new ArrayList<AnnotationTerm>();
    }

    public boolean isTuple() {
        return this.factory == null;
    }

    public void addElement(AnnotationTerm element) {
        if (this.factory != null && !this.factory.getClass().isInstance(element)) {
            throw new RuntimeException("Different types in sequence " + this.factory.getClass() + " vs " + element.getClass());
        }
        this.elements.add(element);
    }

    @Override
    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeDpmAnnotations(ExpressionTransformer exprGen) {
        if (this.factory != null) {
            ListBuffer<JCTree.JCExpression> lb = new ListBuffer<JCTree.JCExpression>();
            for (LiteralAnnotationTerm literalAnnotationTerm : this.elements) {
                lb.add(literalAnnotationTerm.makeLiteral(exprGen));
            }
            JCTree.JCNewArray array = exprGen.make().NewArray(null, null, lb.toList());
            return this.factory.makeAtValue(exprGen, null, array);
        }
        return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
    }

    @Override
    public String toString() {
        return this.elements.toString();
    }

    @Override
    protected JCTree.JCExpression makeLiteral(ExpressionTransformer exprGen) {
        ListBuffer<JCTree.JCExpression> lb = new ListBuffer<JCTree.JCExpression>();
        for (LiteralAnnotationTerm literalAnnotationTerm : this.elements) {
            lb.add(literalAnnotationTerm.makeLiteral(exprGen));
        }
        JCTree.JCNewArray array = exprGen.make().NewArray(null, null, lb.toList());
        return array;
    }

    @Override
    protected com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeAtValue(ExpressionTransformer exprGen, String name, JCTree.JCExpression value) {
        return this.factory.makeAtValue(exprGen, name, value);
    }

    @Override
    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> makeExprs(ExpressionTransformer exprGen, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> value) {
        return this.factory.makeExprs(exprGen, value);
    }
}

