/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CallBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.DirectInvocation;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Type;
import java.util.List;

class MethodReferenceSpecifierInvocation
extends DirectInvocation {
    private final Function method;
    private boolean variadic;
    private List<Parameter> targetParameters;
    private List<Parameter> sourceParameters;

    public MethodReferenceSpecifierInvocation(AbstractTransformer gen, Tree.Primary primary, Declaration primaryDeclaration, Reference producedReference, Function method, Tree.SpecifierExpression node) {
        super(gen, primary, primaryDeclaration, producedReference, method.getType(), node);
        this.method = method;
        this.setUnboxed(primary.getUnboxed());
        this.setBoxingStrategy(CodegenUtil.getBoxingStrategy(method));
        this.sourceParameters = method.getFirstParameterList().getParameters();
        this.targetParameters = ((Functional)((Object)this.getPrimaryDeclaration())).getFirstParameterList().getParameters();
        this.variadic = this.getPrimaryDeclaration().isVariadic();
        if (!this.targetParameters.isEmpty()) {
            Parameter lastParam = this.targetParameters.get(this.targetParameters.size() - 1);
            this.variadic |= lastParam.isSequenced();
        }
    }

    @Override
    protected int getNumArguments() {
        return this.sourceParameters.size();
    }

    @Override
    protected int getNumParameters() {
        return this.targetParameters.size();
    }

    @Override
    protected JCTree.JCExpression getTransformedArgumentExpression(int argIndex) {
        Type exprType = this.getArgumentType(argIndex);
        Parameter declaredParameter = this.getParameter(argIndex);
        Parameter declaredArgument = this.sourceParameters.get(argIndex);
        JCTree.JCExpression result = this.gen.naming.makeName(declaredArgument.getModel(), 1);
        AbstractTransformer.BoxingStrategy boxingStrategy = this.variadic ? AbstractTransformer.BoxingStrategy.BOXED : CodegenUtil.getBoxingStrategy(declaredParameter.getModel());
        result = this.gen.expressionGen().applyErasureAndBoxing(result, exprType, !CodegenUtil.isUnBoxed(declaredArgument.getModel()), boxingStrategy, declaredParameter.getType());
        return result;
    }

    @Override
    protected Parameter getParameter(int argIndex) {
        if (this.variadic && argIndex >= this.targetParameters.size()) {
            return this.targetParameters.get(this.targetParameters.size() - 1);
        }
        return this.targetParameters.get(argIndex);
    }

    @Override
    protected boolean isSpread() {
        return this.sourceParameters.get(this.getNumArguments() - 1).isSequenced();
    }

    @Override
    protected boolean isArgumentSpread(int argIndex) {
        return this.isSpread() && argIndex == this.getNumArguments() - 1;
    }

    @Override
    protected Tree.Expression getArgumentExpression(int argIndex) {
        throw new BugException("I override getArgumentExpression(), so should never be called");
    }

    @Override
    protected boolean isArgumentComprehension(int argIndex) {
        throw new BugException("I override getTransformedArgumentExpression(), so should never be called");
    }

    @Override
    public void location(CallBuilder callBuilder) {
        callBuilder.location(null);
    }

    @Override
    protected Type getArgumentType(int argIndex) {
        Parameter param = this.sourceParameters.get(argIndex);
        return this.getParameterTypeForValueType(this.appliedReference(), param);
    }
}

