/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CallBuilder;
import com.redhat.ceylon.compiler.java.codegen.DirectInvocation;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Type;
import java.util.List;

class PositionalInvocation
extends DirectInvocation {
    private final Tree.PositionalArgumentList positional;
    private final List<Parameter> parameters;

    public PositionalInvocation(AbstractTransformer gen, Tree.Term primary, Declaration primaryDeclaration, Reference producedReference, Tree.InvocationExpression invocation, List<Parameter> parameters) {
        super(gen, primary, PositionalInvocation.unfake(primaryDeclaration), PositionalInvocation.unfake(producedReference), invocation.getTypeModel(), invocation);
        this.positional = invocation.getPositionalArgumentList();
        this.parameters = parameters;
    }

    private static Declaration unfake(Declaration primaryDeclaration) {
        if (primaryDeclaration.isCoercionPoint()) {
            if (primaryDeclaration instanceof Function) {
                return ((Function)primaryDeclaration).getRealFunction();
            }
            return ((Class)primaryDeclaration).getRealClass();
        }
        return primaryDeclaration;
    }

    private static Reference unfake(Reference producedReference) {
        Declaration declaration = producedReference.getDeclaration();
        if (declaration.isCoercionPoint()) {
            if (declaration instanceof Function) {
                Function realFunction = ((Function)declaration).getRealFunction();
                return realFunction.appliedTypedReference(producedReference.getQualifyingType(), producedReference.getTypeArgumentList());
            }
            Class realClass = ((Class)declaration).getRealClass();
            return realClass.appliedType(producedReference.getQualifyingType(), producedReference.getTypeArgumentList());
        }
        return producedReference;
    }

    List<Parameter> getParameters() {
        return this.parameters;
    }

    Tree.PositionalArgumentList getPositional() {
        return this.positional;
    }

    @Override
    protected Tree.Expression getArgumentExpression(int argIndex) {
        Tree.PositionalArgument arg = this.getPositional().getPositionalArguments().get(argIndex);
        if (arg instanceof Tree.ListedArgument) {
            return ((Tree.ListedArgument)arg).getExpression();
        }
        if (arg instanceof Tree.SpreadArgument) {
            return ((Tree.SpreadArgument)arg).getExpression();
        }
        throw new BugException("argument expression is " + arg.getNodeType());
    }

    @Override
    protected boolean isArgumentComprehension(int argIndex) {
        Tree.PositionalArgument arg = this.getPositional().getPositionalArguments().get(argIndex);
        return arg instanceof Tree.Comprehension;
    }

    @Override
    protected Type getArgumentType(int argIndex) {
        Tree.PositionalArgument arg = this.getPositional().getPositionalArguments().get(argIndex);
        if (arg instanceof Tree.Comprehension) {
            return this.gen.typeFact().getSequentialType(arg.getTypeModel());
        }
        return arg.getTypeModel();
    }

    @Override
    protected JCTree.JCExpression getTransformedArgumentExpression(int argIndex) {
        Tree.Expression expr;
        Tree.PositionalArgument arg = this.getPositional().getPositionalArguments().get(argIndex);
        if (arg instanceof Tree.ListedArgument && (expr = ((Tree.ListedArgument)arg).getExpression()).getTerm() instanceof Tree.FunctionArgument) {
            Tree.FunctionArgument farg = (Tree.FunctionArgument)expr.getTerm();
            return this.gen.expressionGen().transform(farg, this.getParameterType(argIndex));
        }
        if (arg instanceof Tree.Comprehension) {
            Type type = this.getParameterType(argIndex);
            return this.gen.expressionGen().comprehensionAsSequential((Tree.Comprehension)arg, type);
        }
        return this.gen.expressionGen().transformArg(this, argIndex);
    }

    @Override
    protected Parameter getParameter(int argIndex) {
        int realIndex = argIndex >= this.parameters.size() ? this.parameters.size() - 1 : argIndex;
        Parameter param = this.parameters.get(realIndex);
        if (param.getModel().isCoercionPoint()) {
            Parameter realParameter = ((Functional)((Object)this.getPrimaryDeclaration())).getFirstParameterList().getParameters().get(realIndex);
            return realParameter;
        }
        return param;
    }

    @Override
    public boolean isParameterCoerced(int argIndex) {
        Parameter param = this.parameters.get(argIndex >= this.parameters.size() ? this.parameters.size() - 1 : argIndex);
        return param.getModel().isCoercionPoint();
    }

    @Override
    protected int getNumArguments() {
        return this.getPositional().getPositionalArguments().size();
    }

    @Override
    protected int getNumParameters() {
        return this.parameters.size();
    }

    @Override
    protected boolean isSpread() {
        List<Tree.PositionalArgument> args = this.getPositional().getPositionalArguments();
        if (args.isEmpty()) {
            return false;
        }
        Tree.PositionalArgument last = args.get(args.size() - 1);
        return last instanceof Tree.SpreadArgument || last instanceof Tree.Comprehension;
    }

    @Override
    protected boolean isArgumentSpread(int argIndex) {
        Tree.PositionalArgument arg = this.getPositional().getPositionalArguments().get(argIndex);
        return arg instanceof Tree.SpreadArgument || arg instanceof Tree.Comprehension;
    }

    @Override
    protected boolean isParameterRaw(int argIndex) {
        return this.isParameterRaw(this.getParameter(argIndex));
    }

    @Override
    protected boolean isParameterWithConstrainedTypeParameters(int argIndex) {
        return this.isParameterWithConstrainedTypeParameters(this.getParameter(argIndex));
    }

    @Override
    protected boolean isParameterWithDependentCovariantTypeParameters(int argIndex) {
        return this.isParameterWithDependentCovariantTypeParameters(this.getParameter(argIndex));
    }

    protected boolean hasDefaultArgument(int ii) {
        return this.getParameters().get(ii).isDefaulted();
    }

    @Override
    public void location(CallBuilder callBuilder) {
        callBuilder.location(this.positional);
    }
}

