/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.language;

import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Integer;
import ceylon.language.Iterator;
import ceylon.language.Null;
import ceylon.language.String;
import ceylon.language.finished_;
import ceylon.language.impl.BaseIterable;
import ceylon.language.impl.BaseIterator;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8)
@Class(extendsType="ceylon.language::Object", basic=false, identifiable=false)
@SatisfiedTypes(value={"{ceylon.language::String+}"})
public class StringTokens
extends BaseIterable<String, Object> {
    private static final long serialVersionUID = -8391084560840739585L;
    private final java.lang.String str;
    private final Callable<? extends Boolean> separator;
    private final boolean keepSeparators;
    private final boolean groupSeparators;
    private final Integer limit;

    public StringTokens(java.lang.String str, @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> separator, boolean keepSeparators, boolean groupSeparators, @TypeInfo(value="ceylon.language::Integer?") Integer limit) {
        super(String.$TypeDescriptor$, Null.$TypeDescriptor$);
        this.str = str;
        this.separator = separator;
        this.keepSeparators = keepSeparators;
        this.groupSeparators = groupSeparators;
        this.limit = limit;
    }

    @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)")
    private final Callable<? extends Boolean> getSeparator$priv() {
        return this.separator;
    }

    @Override
    public Iterator<? extends String> iterator() {
        return new TokenIterator();
    }

    @Override
    public boolean getEmpty() {
        return false;
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(StringTokens.class, new TypeDescriptor[0]);
    }

    private class TokenIterator
    extends BaseIterator<String> {
        private static final long serialVersionUID = 3972342354562630763L;
        protected int index;
        private boolean first;
        private boolean lastTokenWasSeparator;
        private int count;

        public TokenIterator() {
            super(String.$TypeDescriptor$);
            this.index = 0;
            this.first = true;
            this.lastTokenWasSeparator = false;
            this.count = 0;
        }

        @Override
        public Object next() {
            if (!this.eof()) {
                int start;
                if ((this.first || this.lastTokenWasSeparator) && this.isSeparator()) {
                    return this.emptyToken();
                }
                if (this.isSeparator()) {
                    start = this.index;
                    this.advance();
                    if (StringTokens.this.groupSeparators) {
                        while (this.isSeparator()) {
                            this.advance();
                        }
                    }
                    if (StringTokens.this.keepSeparators) {
                        return this.token(start, true);
                    }
                }
                start = this.index;
                if (StringTokens.this.limit != null && (long)this.count >= StringTokens.this.limit.longValue()) {
                    this.advanceToEnd();
                } else {
                    while (this.isRegular()) {
                        this.advance();
                    }
                }
                return this.token(start, false);
            }
            if (this.lastTokenWasSeparator) {
                return this.emptyToken();
            }
            return finished_.get_();
        }

        private String token(int start, boolean separator) {
            if (!separator) {
                ++this.count;
            }
            this.first = false;
            this.lastTokenWasSeparator = separator;
            return String.instance(StringTokens.this.str.substring(start, this.index));
        }

        private String emptyToken() {
            ++this.count;
            this.first = false;
            this.lastTokenWasSeparator = false;
            return String.instance("");
        }

        private void advanceToEnd() {
            this.index = StringTokens.this.str.length();
        }

        private void advance() {
            this.index += Character.charCount(StringTokens.this.str.codePointAt(this.index));
        }

        private boolean eof() {
            return this.index >= StringTokens.this.str.length();
        }

        private boolean isRegular() {
            if (this.eof()) {
                return false;
            }
            int codePoint = Character.codePointAt(StringTokens.this.str, this.index);
            return !((Boolean)StringTokens.this.separator.$call$((Object)ceylon.language.Character.instance(codePoint))).booleanValue();
        }

        private boolean isSeparator() {
            if (this.eof()) {
                return false;
            }
            int codePoint = Character.codePointAt(StringTokens.this.str, this.index);
            return ((Boolean)StringTokens.this.separator.$call$((Object)ceylon.language.Character.instance(codePoint))).booleanValue();
        }

        @Override
        @Ignore
        public TypeDescriptor $getType$() {
            return TypeDescriptor.klass(TokenIterator.class, new TypeDescriptor[0]);
        }
    }
}

