/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.compiler.java.codegen.AnnotationArgument;
import com.redhat.ceylon.compiler.java.codegen.AnnotationConstructorParameter;
import com.redhat.ceylon.compiler.java.codegen.AnnotationFieldName;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocation;
import com.redhat.ceylon.compiler.java.codegen.AnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.BooleanLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.CharacterLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.CollectionLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.DeclarationLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.FloatLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.IntegerLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.InvocationAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.LiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ObjectLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.ParameterAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.StringLiteralAnnotationTerm;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.mirror.AnnotatedMirror;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.LazyFunction;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.List;

public class AnnotationLoader {
    private AbstractModelLoader modelLoader;
    private Unit typeFactory;

    public AnnotationLoader(AbstractModelLoader modelLoader, Unit unit) {
        this.modelLoader = modelLoader;
        this.typeFactory = unit;
    }

    public void setAnnotationConstructor(LazyFunction method, MethodMirror meth) {
        AnnotationInvocation ai = this.loadAnnotationInvocation(method, method.classMirror, meth);
        if (ai != null) {
            this.loadAnnotationConstructorDefaultedParameters(method, meth, ai);
            ai.setConstructorDeclaration(method);
            method.setAnnotationConstructor(ai);
        }
    }

    private AnnotationInvocation loadAnnotationInvocation(LazyFunction method, AnnotatedMirror annoInstMirror, MethodMirror meth) {
        AnnotationInvocation ai = null;
        AnnotationMirror annotationInvocationAnnotation = null;
        List<AnnotationMirror> annotationTree = this.getAnnotationArrayValue(annoInstMirror, "com.redhat.ceylon.compiler.java.metadata.AnnotationInstantiationTree", "value");
        annotationInvocationAnnotation = annotationTree != null && !annotationTree.isEmpty() ? (AnnotationMirror)annotationTree.get(0) : annoInstMirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.AnnotationInstantiation");
        if (annotationInvocationAnnotation != null) {
            ai = new AnnotationInvocation();
            this.setPrimaryFromAnnotationInvocationAnnotation(annotationInvocationAnnotation, ai);
            this.loadAnnotationInvocationArguments(new ArrayList<AnnotationFieldName>(2), method, ai, annotationInvocationAnnotation, annotationTree, annoInstMirror);
        }
        return ai;
    }

    private void loadAnnotationInvocationArguments(List<AnnotationFieldName> path, LazyFunction method, AnnotationInvocation ai, AnnotationMirror annotationInvocationAnnotation, List<AnnotationMirror> annotationTree, AnnotatedMirror dpm) {
        List argumentCodes = (List)annotationInvocationAnnotation.getValue("arguments");
        if (argumentCodes != null) {
            for (int ii = 0; ii < argumentCodes.size(); ++ii) {
                short code = (Short)argumentCodes.get(ii);
                AnnotationArgument argument = new AnnotationArgument();
                Parameter classParameter = ai.getParameters().get(ii);
                argument.setParameter(classParameter);
                path.add(argument);
                argument.setTerm(this.loadAnnotationArgumentTerm(path, method, ai, classParameter, annotationTree, dpm, code));
                path.remove(path.size() - 1);
                ai.getAnnotationArguments().add(argument);
            }
        }
    }

    private AnnotationTerm decode(Module moduleScope, List<Parameter> sourceParameters, AnnotationInvocation info, Parameter parameter, AnnotatedMirror dpm, List<AnnotationFieldName> path, int code) {
        AnnotationTerm result;
        if (code == Short.MIN_VALUE) {
            return this.findLiteralAnnotationTerm(moduleScope, path, parameter, dpm);
        }
        if (code < 0) {
            InvocationAnnotationTerm invocation;
            result = invocation = new InvocationAnnotationTerm();
        } else if (code >= 0 && code < 512) {
            ParameterAnnotationTerm parameterArgument = new ParameterAnnotationTerm();
            boolean spread = false;
            if (code >= 256) {
                spread = true;
                code -= 256;
            }
            parameterArgument.setSpread(spread);
            Parameter sourceParameter = sourceParameters.get(code);
            parameterArgument.setSourceParameter(sourceParameter);
            result = parameterArgument;
        } else {
            throw new RuntimeException();
        }
        return result;
    }

    private AnnotationTerm loadAnnotationArgumentTerm(List<AnnotationFieldName> path, LazyFunction method, AnnotationInvocation ai, Parameter parameter, List<AnnotationMirror> annotationTree, AnnotatedMirror dpm, short code) {
        if (code < 0 && code != Short.MIN_VALUE) {
            AnnotationMirror i = annotationTree.get(-code);
            AnnotationInvocation nested = new AnnotationInvocation();
            this.setPrimaryFromAnnotationInvocationAnnotation(i, nested);
            this.loadAnnotationInvocationArguments(path, method, nested, i, annotationTree, dpm);
            InvocationAnnotationTerm term = new InvocationAnnotationTerm();
            term.setInstantiation(nested);
            return term;
        }
        AnnotationTerm term = this.decode(Decl.getModuleContainer(method), method.getFirstParameterList().getParameters(), ai, parameter, dpm, path, code);
        return term;
    }

    private void setPrimaryFromAnnotationInvocationAnnotation(AnnotationMirror annotationInvocationAnnotation, AnnotationInvocation ai) {
        TypeMirror annotationType = (TypeMirror)annotationInvocationAnnotation.getValue("primary");
        ClassMirror annotationClassMirror = annotationType.getDeclaredClass();
        Module module = this.modelLoader.findModuleForClassMirror(annotationClassMirror);
        if (annotationClassMirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Method") != null) {
            ai.setPrimary((Function)this.modelLoader.convertToDeclaration(module, annotationClassMirror, ModelLoader.DeclarationType.VALUE));
        } else {
            ai.setPrimary((Class)this.modelLoader.convertToDeclaration(module, annotationClassMirror, ModelLoader.DeclarationType.TYPE));
        }
    }

    private void loadAnnotationConstructorDefaultedParameters(LazyFunction method, MethodMirror meth, AnnotationInvocation ai) {
        for (Parameter ctorParam : method.getFirstParameterList().getParameters()) {
            AnnotationConstructorParameter acp = new AnnotationConstructorParameter();
            acp.setParameter(ctorParam);
            if (ctorParam.isDefaulted()) {
                acp.setDefaultArgument(this.loadAnnotationConstructorDefaultedParameter(method, meth, ctorParam, acp));
            }
            ai.addConstructorParameter(acp);
        }
    }

    private AnnotationTerm loadAnnotationConstructorDefaultedParameter(LazyFunction method, MethodMirror meth, Parameter ctorParam, AnnotationConstructorParameter acp) {
        for (MethodMirror mm : method.classMirror.getDirectMethods()) {
            if (!mm.getName().equals(Naming.getDefaultedParamMethodName(method, ctorParam))) continue;
            if (mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.AnnotationInstantiation") != null) {
                InvocationAnnotationTerm invocationTerm = new InvocationAnnotationTerm();
                invocationTerm.setInstantiation(this.loadAnnotationInvocation(method, mm, meth));
                return invocationTerm;
            }
            return this.loadLiteralAnnotationTerm(method, ctorParam, mm);
        }
        return null;
    }

    private LiteralAnnotationTerm loadLiteralAnnotationTerm(LazyFunction method, Parameter parameter, AnnotatedMirror mm) {
        boolean singleValue = !this.typeFactory.isIterableType(parameter.getType()) || parameter.getType().isString();
        AnnotationMirror valueAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.StringValue");
        if (valueAnnotation != null) {
            return this.readStringValuesAnnotation(valueAnnotation, singleValue);
        }
        valueAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.IntegerValue");
        if (valueAnnotation != null) {
            return this.readIntegerValuesAnnotation(valueAnnotation, singleValue);
        }
        valueAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.BooleanValue");
        if (valueAnnotation != null) {
            return this.readBooleanValuesAnnotation(valueAnnotation, singleValue);
        }
        valueAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.DeclarationValue");
        if (valueAnnotation != null) {
            return this.readDeclarationValuesAnnotation(valueAnnotation, singleValue);
        }
        valueAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.ObjectValue");
        if (valueAnnotation != null) {
            return this.readObjectValuesAnnotation(Decl.getModuleContainer(method), valueAnnotation, singleValue);
        }
        valueAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.CharacterValue");
        if (valueAnnotation != null) {
            return this.readCharacterValuesAnnotation(valueAnnotation, singleValue);
        }
        valueAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.FloatValue");
        if (valueAnnotation != null) {
            return this.readFloatValuesAnnotation(valueAnnotation, singleValue);
        }
        return null;
    }

    private LiteralAnnotationTerm findLiteralAnnotationTerm(Module moduleScope, List<AnnotationFieldName> namePath, Parameter parameter, AnnotatedMirror mm) {
        String path;
        boolean singeValue = !this.typeFactory.isIterableType(parameter.getType()) || parameter.getType().isString();
        String name = Naming.getAnnotationFieldName(namePath);
        AnnotationMirror exprsAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.StringExprs");
        if (exprsAnnotation != null) {
            for (AnnotationMirror valueAnnotation : this.getAnnotationAnnoValues(exprsAnnotation, "value")) {
                path = (String)valueAnnotation.getValue("name");
                if (!name.equals(path)) continue;
                return this.readStringValuesAnnotation(valueAnnotation, singeValue);
            }
        }
        if ((exprsAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.IntegerExprs")) != null) {
            for (AnnotationMirror valueAnnotation : this.getAnnotationAnnoValues(exprsAnnotation, "value")) {
                path = (String)valueAnnotation.getValue("name");
                if (!name.equals(path)) continue;
                return this.readIntegerValuesAnnotation(valueAnnotation, singeValue);
            }
        }
        if ((exprsAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.BooleanExprs")) != null) {
            for (AnnotationMirror valueAnnotation : this.getAnnotationAnnoValues(exprsAnnotation, "value")) {
                path = (String)valueAnnotation.getValue("name");
                if (!name.equals(path)) continue;
                return this.readBooleanValuesAnnotation(valueAnnotation, singeValue);
            }
        }
        if ((exprsAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.DeclarationExprs")) != null) {
            for (AnnotationMirror valueAnnotation : this.getAnnotationAnnoValues(exprsAnnotation, "value")) {
                path = (String)valueAnnotation.getValue("name");
                if (!name.equals(path)) continue;
                return this.readDeclarationValuesAnnotation(valueAnnotation, singeValue);
            }
        }
        if ((exprsAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.ObjectExprs")) != null) {
            for (AnnotationMirror valueAnnotation : this.getAnnotationAnnoValues(exprsAnnotation, "value")) {
                path = (String)valueAnnotation.getValue("name");
                if (!name.equals(path)) continue;
                return this.readObjectValuesAnnotation(moduleScope, valueAnnotation, singeValue);
            }
        }
        if ((exprsAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.CharacterExprs")) != null) {
            for (AnnotationMirror valueAnnotation : this.getAnnotationAnnoValues(exprsAnnotation, "value")) {
                path = (String)valueAnnotation.getValue("name");
                if (!name.equals(path)) continue;
                return this.readCharacterValuesAnnotation(valueAnnotation, singeValue);
            }
        }
        if ((exprsAnnotation = mm.getAnnotation("com.redhat.ceylon.compiler.java.metadata.FloatExprs")) != null) {
            for (AnnotationMirror valueAnnotation : this.getAnnotationAnnoValues(exprsAnnotation, "value")) {
                path = (String)valueAnnotation.getValue("name");
                if (!name.equals(path)) continue;
                return this.readFloatValuesAnnotation(valueAnnotation, singeValue);
            }
        }
        return null;
    }

    private LiteralAnnotationTerm readObjectValuesAnnotation(Module moduleScope, AnnotationMirror valueAnnotation, boolean singleValue) {
        if (singleValue) {
            TypeMirror klass = this.getAnnotationClassValues(valueAnnotation, "value").get(0);
            Type type = this.modelLoader.obtainType(moduleScope, klass, null, null, null);
            ObjectLiteralAnnotationTerm term = new ObjectLiteralAnnotationTerm(type);
            return term;
        }
        CollectionLiteralAnnotationTerm result = new CollectionLiteralAnnotationTerm(ObjectLiteralAnnotationTerm.FACTORY);
        for (TypeMirror klass : this.getAnnotationClassValues(valueAnnotation, "value")) {
            Type type = this.modelLoader.obtainType(moduleScope, klass, null, null, null);
            result.addElement(new ObjectLiteralAnnotationTerm(type));
        }
        return result;
    }

    private LiteralAnnotationTerm readStringValuesAnnotation(AnnotationMirror valueAnnotation, boolean singleValue) {
        if (singleValue) {
            String value = this.getAnnotationStringValues(valueAnnotation, "value").get(0);
            StringLiteralAnnotationTerm term = new StringLiteralAnnotationTerm(value);
            return term;
        }
        CollectionLiteralAnnotationTerm result = new CollectionLiteralAnnotationTerm(StringLiteralAnnotationTerm.FACTORY);
        for (String value : this.getAnnotationStringValues(valueAnnotation, "value")) {
            result.addElement(new StringLiteralAnnotationTerm(value));
        }
        return result;
    }

    private LiteralAnnotationTerm readIntegerValuesAnnotation(AnnotationMirror valueAnnotation, boolean singleValue) {
        if (singleValue) {
            Long value = this.getAnnotationLongValues(valueAnnotation, "value").get(0);
            IntegerLiteralAnnotationTerm term = new IntegerLiteralAnnotationTerm(value);
            return term;
        }
        CollectionLiteralAnnotationTerm result = new CollectionLiteralAnnotationTerm(IntegerLiteralAnnotationTerm.FACTORY);
        for (Long value : this.getAnnotationLongValues(valueAnnotation, "value")) {
            result.addElement(new IntegerLiteralAnnotationTerm(value));
        }
        return result;
    }

    private LiteralAnnotationTerm readCharacterValuesAnnotation(AnnotationMirror valueAnnotation, boolean singleValue) {
        if (singleValue) {
            Integer value = this.getAnnotationIntegerValues(valueAnnotation, "value").get(0);
            CharacterLiteralAnnotationTerm term = new CharacterLiteralAnnotationTerm(value);
            return term;
        }
        CollectionLiteralAnnotationTerm result = new CollectionLiteralAnnotationTerm(CharacterLiteralAnnotationTerm.FACTORY);
        for (Integer value : this.getAnnotationIntegerValues(valueAnnotation, "value")) {
            result.addElement(new CharacterLiteralAnnotationTerm(value));
        }
        return result;
    }

    private LiteralAnnotationTerm readFloatValuesAnnotation(AnnotationMirror valueAnnotation, boolean singleValue) {
        if (singleValue) {
            Double value = this.getAnnotationDoubleValues(valueAnnotation, "value").get(0);
            FloatLiteralAnnotationTerm term = new FloatLiteralAnnotationTerm(value);
            return term;
        }
        CollectionLiteralAnnotationTerm result = new CollectionLiteralAnnotationTerm(FloatLiteralAnnotationTerm.FACTORY);
        for (Double value : this.getAnnotationDoubleValues(valueAnnotation, "value")) {
            result.addElement(new FloatLiteralAnnotationTerm(value));
        }
        return result;
    }

    private LiteralAnnotationTerm readBooleanValuesAnnotation(AnnotationMirror valueAnnotation, boolean singleValue) {
        if (singleValue) {
            boolean value = this.getAnnotationBooleanValues(valueAnnotation, "value").get(0);
            BooleanLiteralAnnotationTerm term = new BooleanLiteralAnnotationTerm(value);
            return term;
        }
        CollectionLiteralAnnotationTerm result = new CollectionLiteralAnnotationTerm(BooleanLiteralAnnotationTerm.FACTORY);
        for (Boolean value : this.getAnnotationBooleanValues(valueAnnotation, "value")) {
            result.addElement(new BooleanLiteralAnnotationTerm(value));
        }
        return result;
    }

    private LiteralAnnotationTerm readDeclarationValuesAnnotation(AnnotationMirror valueAnnotation, boolean singleValue) {
        if (singleValue) {
            String value = this.getAnnotationStringValues(valueAnnotation, "value").get(0);
            DeclarationLiteralAnnotationTerm term = new DeclarationLiteralAnnotationTerm(value);
            return term;
        }
        CollectionLiteralAnnotationTerm result = new CollectionLiteralAnnotationTerm(DeclarationLiteralAnnotationTerm.FACTORY);
        for (String value : this.getAnnotationStringValues(valueAnnotation, "value")) {
            result.addElement(new DeclarationLiteralAnnotationTerm(value));
        }
        return result;
    }

    private List<TypeMirror> getAnnotationClassValues(AnnotationMirror annotation, String field) {
        return (List)annotation.getValue(field);
    }

    private List<Integer> getAnnotationIntegerValues(AnnotationMirror annotation, String field) {
        return (List)annotation.getValue(field);
    }

    private List<Boolean> getAnnotationBooleanValues(AnnotationMirror annotation, String field) {
        return (List)annotation.getValue(field);
    }

    private List<Long> getAnnotationLongValues(AnnotationMirror annotation, String field) {
        return (List)annotation.getValue(field);
    }

    private List<Double> getAnnotationDoubleValues(AnnotationMirror annotation, String field) {
        return (List)annotation.getValue(field);
    }

    private List<AnnotationMirror> getAnnotationAnnoValues(AnnotationMirror annotation, String field) {
        return (List)annotation.getValue(field);
    }

    private List<String> getAnnotationStringValues(AnnotationMirror annotation, String field) {
        return (List)annotation.getValue(field);
    }

    private <T> List<T> getAnnotationArrayValue(AnnotatedMirror mirror, String type, String field) {
        return (List)this.getAnnotationValue(mirror, type, field);
    }

    private Object getAnnotationValue(AnnotatedMirror mirror, String type, String fieldName) {
        AnnotationMirror annotation = mirror.getAnnotation(type);
        if (annotation != null) {
            return annotation.getValue(fieldName);
        }
        return null;
    }

    public void makeInterorAnnotationConstructorInvocation(AnnotationProxyMethod ctor, AnnotationProxyClass klass, List<Parameter> ctorParams) {
        AnnotationInvocation ai = new AnnotationInvocation();
        ai.setConstructorDeclaration(ctor);
        ai.setPrimary(klass);
        ai.setInterop(true);
        ctor.setAnnotationConstructor(ai);
        ArrayList<AnnotationArgument> annotationArgs = new ArrayList<AnnotationArgument>();
        for (Parameter ctorParam : ctorParams) {
            boolean isValue = ctorParam.getName().equals("value");
            ParameterAnnotationTerm term = new ParameterAnnotationTerm();
            AnnotationArgument argument = new AnnotationArgument();
            argument.setTerm(term);
            argument.setParameter(klass.getParameter(ctorParam.getName()));
            term.setSourceParameter(ctorParam);
            AnnotationConstructorParameter acp = new AnnotationConstructorParameter();
            acp.setParameter(ctorParam);
            if (isValue) {
                ai.addConstructorParameter(0, acp);
            } else {
                ai.addConstructorParameter(acp);
            }
            annotationArgs.add(argument);
        }
        ai.getAnnotationArguments().addAll(annotationArgs);
    }
}

