/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.loader.BaseModuleLoaderImpl;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleNotFoundException;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.java.tools.StatusPrinterAptProgressListener;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ModuleScope;
import java.util.Map;

public class CompilerModuleLoader
extends BaseModuleLoaderImpl {
    private StatusPrinter statusPrinter;
    private CeylonLog log;

    public CompilerModuleLoader(RepositoryManager repositoryManager, ClassLoader delegateClassLoader, Map<String, String> extraModules, boolean verbose, StatusPrinter statusPrinter, CeylonLog log) {
        super(repositoryManager, delegateClassLoader, extraModules, verbose);
        this.statusPrinter = statusPrinter;
        this.log = log;
    }

    @Override
    public void log(String string) {
        this.log.printRawLines(Log.WriterKind.NOTICE, "[" + string + "]");
    }

    @Override
    protected BaseModuleLoaderImpl.ModuleLoaderContext createModuleLoaderContext(String name, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
        return new CompilerModuleLoaderContext(name, version2, lookupScope);
    }

    private CompilerModuleLoaderContext getContext() {
        if (this.contexts.size() == 1) {
            return (CompilerModuleLoaderContext)this.contexts.values().iterator().next();
        }
        throw new RuntimeException("No context found");
    }

    public String getModuleVersion(String name) {
        CompilerModuleLoaderContext context = this.getContext();
        return context.getModuleVersion(ModuleUtil.getModuleNameFromUri(name));
    }

    public void setupOverrides(Overrides overrides) {
        CompilerModuleLoaderContext context = this.getContext();
        context.fillOverrides(overrides);
    }

    public int getModuleCount() {
        CompilerModuleLoaderContext context = this.getContext();
        return context.getModuleCount();
    }

    public class CompilerModuleLoaderContext
    extends BaseModuleLoaderImpl.ModuleLoaderContext {
        private StatusPrinterAptProgressListener progressListener;
        private final String[] artifactSuffixes;

        CompilerModuleLoaderContext(String module, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
            super(CompilerModuleLoader.this, module, version2, lookupScope);
            this.artifactSuffixes = new String[]{".car", ".jar"};
            if (CompilerModuleLoader.this.statusPrinter != null) {
                this.progressListener = new StatusPrinterAptProgressListener(CompilerModuleLoader.this.statusPrinter){

                    @Override
                    protected long getNumberOfModulesResolved() {
                        return CompilerModuleLoaderContext.this.getModuleCount();
                    }
                };
            }
        }

        @Override
        protected void initialise() throws ModuleNotFoundException {
            this.preloadModules();
        }

        @Override
        protected String[] getArtifactSuffixes() {
            return this.artifactSuffixes;
        }

        @Override
        protected void resolvingSuccess(ArtifactResult result) {
            if (CompilerModuleLoader.this.verbose) {
                CompilerModuleLoader.this.log("Pre-resolved module: " + result);
            }
            if (this.progressListener != null) {
                this.progressListener.retrievingModuleArtifactSuccess(this.toModuleSpec(result), result);
            }
        }

        private ModuleSpec toModuleSpec(ArtifactResult result) {
            return new ModuleSpec(result.namespace(), result.name(), result.version());
        }

        @Override
        protected void resolvingFailed(ArtifactContext artifactContext) {
            if (CompilerModuleLoader.this.verbose) {
                CompilerModuleLoader.this.log("Pre-resolving module failed for: " + artifactContext);
            }
            if (this.progressListener != null) {
                this.progressListener.retrievingModuleArtifactFailed(this.toModuleSpec(artifactContext), artifactContext);
            }
        }

        @Override
        protected void prepareContext(ArtifactContext artifactContext) {
            if (CompilerModuleLoader.this.verbose) {
                CompilerModuleLoader.this.log("Pre-resolving module: " + artifactContext);
            }
            if (this.progressListener != null) {
                this.progressListener.retrievingModuleArtifact(this.toModuleSpec(artifactContext), artifactContext);
            }
        }

        private ModuleSpec toModuleSpec(ArtifactContext artifactContext) {
            return new ModuleSpec(artifactContext.getNamespace(), artifactContext.getName(), artifactContext.getVersion());
        }

        public String getModuleVersion(String name) {
            ModuleGraph.Module module = this.moduleGraph.findModule(name);
            return module != null ? module.version : null;
        }
    }
}

