/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;

final class ImportScanner
extends JCTree.Visitor {
    private final AbstractModelLoader modelLoader;
    private Module importingModule;

    ImportScanner(AbstractModelLoader modelLoader) {
        this.modelLoader = modelLoader;
    }

    @Override
    public void visitImport(JCTree.JCImport that) {
        JCTree.JCExpression selected;
        if (that.qualid instanceof JCTree.JCFieldAccess && (selected = ((JCTree.JCFieldAccess)that.qualid).selected) instanceof JCTree.JCFieldAccess) {
            if (that.staticImport && !((selected = ((JCTree.JCFieldAccess)selected).selected) instanceof JCTree.JCFieldAccess)) {
                return;
            }
            this.importPackage((JCTree.JCFieldAccess)selected);
        }
    }

    private void importPackage(JCTree.JCFieldAccess selected) {
        Package importedPackage;
        String importedPkg = selected.toString();
        if (importedPkg.isEmpty()) {
            return;
        }
        if (importedPkg.startsWith(".")) {
            importedPkg = importedPkg.substring(1);
        }
        if ((importedPackage = this.importingModule.getPackage(importedPkg)) == null && selected.selected instanceof JCTree.JCFieldAccess) {
            this.importPackage((JCTree.JCFieldAccess)selected.selected);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl that) {
        this.visit(that.defs);
        this.visitType(that.extending);
        for (JCTree.JCExpression impl2 : that.implementing) {
            this.visitType(impl2);
        }
        this.visitTypeParameters(that.typarams);
    }

    private void visitTypeParameters(List<JCTree.JCTypeParameter> typarams) {
        for (JCTree.JCTypeParameter param : typarams) {
            for (JCTree.JCExpression bound : param.bounds) {
                this.visitType(bound);
            }
        }
    }

    private void visitType(JCTree.JCExpression type) {
        JCTree inner;
        if (type instanceof JCTree.JCFieldAccess) {
            this.importPackage((JCTree.JCFieldAccess)type);
        } else if (type instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply parameterisedType = (JCTree.JCTypeApply)type;
            this.visitType(parameterisedType.clazz);
            for (JCTree.JCExpression arg : parameterisedType.arguments) {
                this.visitType(arg);
            }
        } else if (type instanceof JCTree.JCWildcard && (inner = ((JCTree.JCWildcard)type).inner) instanceof JCTree.JCExpression) {
            this.visitType((JCTree.JCExpression)inner);
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl that) {
        this.visitType(that.vartype);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl that) {
        this.visitType(that.restype);
        for (JCTree.JCVariableDecl param : that.params) {
            this.visitVarDef(param);
        }
    }

    @Override
    public void visitTree(JCTree thatceylonEnter) {
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit that) {
        JCTree.JCExpression pid = that.pid;
        String pkgName = pid instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)pid).toString() : (pid instanceof JCTree.JCIdent ? ((JCTree.JCIdent)pid).toString() : "");
        Package thisPackage = this.modelLoader.findPackage(pkgName);
        if (thisPackage == null) {
            return;
        }
        this.importingModule = thisPackage.getModule();
        if (this.importingModule == this.modelLoader.getLanguageModule()) {
            return;
        }
        this.visit(that.defs);
    }

    private void visit(List<JCTree> trees) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            ((JCTree)l.head).accept(this);
            l = l.tail;
        }
    }
}

