/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.compiler.java.tools.LanguageCompiler;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import java.util.Collections;
import java.util.List;

public class TypeFactory
extends Unit {
    private Context context;

    public static TypeFactory instance(com.redhat.ceylon.langtools.tools.javac.util.Context context) {
        TypeFactory instance = context.get(TypeFactory.class);
        if (instance == null) {
            instance = new TypeFactory(LanguageCompiler.getCeylonContextInstance(context));
            context.put(TypeFactory.class, instance);
        }
        return instance;
    }

    public TypeFactory(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isUnion(Type pt) {
        return pt != null && pt.isUnion() && pt.getCaseTypes().size() > 1;
    }

    public boolean isIntersection(Type pt) {
        return pt != null && pt.isIntersection() && pt.getSatisfiedTypes().size() > 1;
    }

    public TypeDeclaration getArraySequenceDeclaration() {
        return (Class)this.getLanguageModuleDeclaration("ArraySequence");
    }

    public Type getArraySequenceType(Type et) {
        return ModelUtil.appliedType(this.getArraySequenceDeclaration(), et);
    }

    public Type getArrayType(Type et) {
        return ModelUtil.appliedType(this.getArrayDeclaration(), et);
    }

    public Type getArrayElementType(Type type) {
        Type st = type.getSupertype(this.getArrayDeclaration());
        if (st != null && st.getTypeArguments().size() == 1) {
            return st.getTypeArgumentList().get(0);
        }
        return null;
    }

    public Type getCallableType(List<Type> typeArgs) {
        if (typeArgs.size() != 2) {
            throw new IllegalArgumentException("Callable type always has two arguments: " + typeArgs);
        }
        if (!typeArgs.get(1).isSubtypeOf(this.getSequentialDeclaration().appliedType(null, Collections.singletonList(this.getAnythingType())))) {
            throw new IllegalArgumentException("Callable's second argument should be sequential " + typeArgs.get(1));
        }
        return this.getCallableDeclaration().appliedType(null, typeArgs);
    }

    public Type getCallableType(Type resultType) {
        return this.getCallableType(com.redhat.ceylon.langtools.tools.javac.util.List.of(resultType, this.getEmptyType()));
    }

    @Override
    public Type getUnknownType() {
        return new UnknownType(this).getType();
    }

    public Type getIteratedAbsentType(Type type) {
        Type st = type.getSupertype(this.getIterableDeclaration());
        if (st != null && st.getTypeArguments().size() > 1) {
            return st.getTypeArgumentList().get(1);
        }
        return null;
    }

    public TypedDeclaration getBooleanTrueDeclaration() {
        return (TypedDeclaration)this.getLanguageModuleDeclaration("true");
    }

    public TypedDeclaration getBooleanFalseDeclaration() {
        return (TypedDeclaration)this.getLanguageModuleDeclaration("false");
    }

    public TypeDeclaration getBooleanTrueClassDeclaration() {
        TypedDeclaration trueDecl = this.getBooleanTrueDeclaration();
        return trueDecl instanceof TypedDeclaration ? trueDecl.getTypeDeclaration() : null;
    }

    public TypeDeclaration getBooleanFalseClassDeclaration() {
        TypedDeclaration trueDecl = this.getBooleanFalseDeclaration();
        return trueDecl instanceof TypedDeclaration ? trueDecl.getTypeDeclaration() : null;
    }

    public TypeDeclaration getMetamodelTypeDeclaration() {
        return (TypeDeclaration)this.getLanguageModuleModelDeclaration("Type");
    }

    public TypedDeclaration getMetamodelNothingTypeDeclaration() {
        return (TypedDeclaration)this.getLanguageModuleModelDeclaration("nothingType");
    }

    public TypeDeclaration getMetamodelDeclarationDeclaration() {
        return (TypeDeclaration)this.getLanguageModuleDeclarationDeclaration("Declaration");
    }

    public TypeDeclaration getAssertionErrorDeclaration() {
        return (TypeDeclaration)this.getLanguageModuleDeclaration("AssertionError");
    }

    public Type getReferenceType(Type value) {
        TypeDeclaration referenceTypeDecl = (TypeDeclaration)this.getLanguageModuleSerializationDeclaration("Reference");
        Type serializedValueType = referenceTypeDecl.appliedType(null, Collections.singletonList(value));
        return serializedValueType;
    }

    public Type getDeconstructorType() {
        return ((TypeDeclaration)this.getLanguageModuleSerializationDeclaration("Deconstructor")).getType();
    }

    public boolean isTupleOfVariadicCallable(Type args) {
        if (args != null) {
            List<Type> tal;
            if (this.isEmptyType(args)) {
                return false;
            }
            if (this.isVariadicElement(args)) {
                return true;
            }
            Class td = this.getTupleDeclaration();
            Type tuple = this.nonemptyArgs(args).getSupertype(td);
            if (tuple == null) {
                return false;
            }
            while ((tal = tuple.getTypeArgumentList()).size() >= 3) {
                Type rest = tal.get(2);
                if (rest == null) {
                    return false;
                }
                if (this.isEmptyType(rest)) {
                    return false;
                }
                if (this.isVariadicElement(rest)) {
                    return true;
                }
                tuple = this.nonemptyArgs(rest).getSupertype(td);
                if (tuple != null) continue;
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean isVariadicElement(Type args) {
        return args.isClassOrInterface() && (args.isSequential() || args.isSequence());
    }

    public Interface getJavaIoSerializable() {
        for (Module m : this.context.getModules().getListOfModules()) {
            if (!"java.base".equals(m.getNameAsString())) continue;
            return (Interface)m.getPackage("java.io").getDirectMember("Serializable", null, false);
        }
        return null;
    }

    public Type getJavaIoSerializableType() {
        Interface ser = this.getJavaIoSerializable();
        if (ser != null) {
            return ser.getType();
        }
        return null;
    }

    @Override
    protected Package getJavaUtilPackage() {
        return this.getPackage().getModule().getPackage("java.util");
    }

    public Interface getJavaIteratorDeclaration() {
        Package lang = this.getJavaUtilPackage();
        if (lang == null) {
            return null;
        }
        return (Interface)lang.getMember("Iterator", null, false);
    }

    public Type getJavaIteratorType(Type iteratedType) {
        return this.getJavaIteratorDeclaration().appliedType(null, Collections.singletonList(iteratedType));
    }
}

