/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class UnknownTypeCollector
extends Visitor {
    @Override
    public void visit(Tree.BaseMemberOrTypeExpression that) {
        super.visit(that);
        Declaration declaration = that.getDeclaration();
        if (declaration == null) {
            return;
        }
        if (declaration instanceof Functional) {
            Functional m = (Functional)((Object)declaration);
            this.collectUnknownTypes(m.getType());
            for (ParameterList pl : m.getParameterLists()) {
                for (Parameter p : pl.getParameters()) {
                    this.collectUnknownTypes(p.getType());
                }
            }
        } else if (declaration instanceof Value) {
            Value v = (Value)declaration;
            this.collectUnknownTypes(v.getType());
        }
    }

    private void collectUnknownTypes(Type type) {
        IdentityHashMap<Declaration, Declaration> visited = new IdentityHashMap<Declaration, Declaration>(0);
        this.collectUnknownTypes(type, visited);
    }

    private void collectUnknownTypesResolved(Type type, Map<Declaration, Declaration> visited) {
        if (type != null) {
            this.collectUnknownTypes(type, visited);
            List<Type> typeArguments = type.getTypeArgumentList();
            int l = typeArguments.size();
            for (int i = 0; i < l; ++i) {
                Type tl = typeArguments.get(i);
                this.collectUnknownTypesResolved(tl, visited);
            }
        }
    }

    private void collectUnknownTypes(Type type, Map<Declaration, Declaration> visited) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        if (type == null) break block6;
                        if (!(type = type.resolveAliases()).isUnknown()) break block7;
                        UnknownType ut = (UnknownType)type.getDeclaration();
                        ut.reportErrors();
                        ut.setErrorReporter(null);
                        break block6;
                    }
                    if (!type.isUnion()) break block8;
                    for (Type t : type.getCaseTypes()) {
                        this.collectUnknownTypesResolved(t, visited);
                    }
                    break block6;
                }
                if (!type.isIntersection()) break block9;
                for (Type t : type.getSatisfiedTypes()) {
                    this.collectUnknownTypesResolved(t, visited);
                }
                break block6;
            }
            if (type.isUnknown() || type.isTypeParameter()) break block6;
            TypeDeclaration declaration = type.getDeclaration();
            if (visited.put(declaration, declaration) != null) {
                return;
            }
            if (type.isClassOrInterface()) {
                if (type.getExtendedType() != null) {
                    this.collectUnknownTypes(type.getExtendedType(), visited);
                }
                for (Type t : type.getSatisfiedTypes()) {
                    this.collectUnknownTypes(t, visited);
                }
            }
        }
    }
}

