/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader.mirror;

import com.redhat.ceylon.compiler.java.loader.mirror.JavacType;
import com.redhat.ceylon.langtools.tools.javac.code.Attribute;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.util.Pair;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JavacAnnotation
implements AnnotationMirror {
    private Attribute.Compound annotation;
    private Map<String, Object> attributes;

    public JavacAnnotation(Attribute.Compound annotation) {
        this.annotation = annotation;
        this.attributes = new HashMap<String, Object>();
    }

    @Override
    public Object getValue(String fieldName) {
        Object result = this.attributes.get(fieldName);
        if (result == null) {
            Attribute attr = this.member(fieldName);
            result = this.attributeToRefl(attr);
            this.attributes.put(fieldName, result);
        }
        return result;
    }

    private Object attributeToRefl(Attribute attr) {
        if (attr == null) {
            return null;
        }
        if (attr instanceof Attribute.Constant) {
            return attr.getValue();
        }
        if (attr instanceof Attribute.Array) {
            Attribute[] values = ((Attribute.Array)attr).values;
            ArrayList<Object> list = new ArrayList<Object>(values.length);
            for (Attribute elem : values) {
                list.add(this.attributeToRefl(elem));
            }
            return list;
        }
        if (attr instanceof Attribute.Compound) {
            return new JavacAnnotation((Attribute.Compound)attr);
        }
        if (attr instanceof Attribute.Enum) {
            return ((Attribute.Enum)attr).getValue().name.toString();
        }
        if (attr instanceof Attribute.Class) {
            return new JavacType(((Attribute.Class)attr).getValue());
        }
        throw new RuntimeException("Unknown attribute type: " + attr);
    }

    private Attribute member(String fieldName) {
        for (Pair<Symbol.MethodSymbol, Attribute> pair : this.annotation.values) {
            if (!((Symbol.MethodSymbol)pair.fst).name.toString().equals(fieldName)) continue;
            return (Attribute)pair.snd;
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.getValue("value");
    }
}

