/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactOverrides;
import com.redhat.ceylon.cmr.api.DependencyOverride;
import com.redhat.ceylon.cmr.api.DependencyResolver;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.OverridesRuntimeResolver;
import com.redhat.ceylon.cmr.api.PathFilterParser;
import com.redhat.ceylon.cmr.impl.AbstractArtifactResult;
import com.redhat.ceylon.cmr.impl.BytecodeUtils;
import com.redhat.ceylon.cmr.impl.Configuration;
import com.redhat.ceylon.cmr.impl.OSGiDependencyResolver;
import com.redhat.ceylon.cmr.impl.PropertiesDependencyResolver;
import com.redhat.ceylon.cmr.impl.XmlDependencyResolver;
import com.redhat.ceylon.cmr.maven.MavenBackupDependencyResolver;
import com.redhat.ceylon.common.Java9ModuleUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.compiler.java.metadata.Module;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.langtools.classfile.Annotation;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.RuntimeAnnotations_attribute;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.model.loader.ClassFileUtil;
import com.redhat.ceylon.model.loader.Java9ModuleReader;
import com.redhat.ceylon.model.loader.OsgiUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Main {
    private boolean allowMissingModules;
    private boolean allowMissingSystem;
    private String overrides;
    private ClassPath classPath;
    private Set<ClassPath.Module> visited;
    private ClassLoader moduleClassLoader;

    public static Main instance() {
        return new Main();
    }

    private Main() {
    }

    public Main allowMissingModules(boolean allowMissingModules) {
        this.allowMissingModules = allowMissingModules;
        return this;
    }

    public Main overrides(String overrides) {
        this.overrides = overrides;
        return this;
    }

    public Main allowMissingSystem(boolean allowMissingSystem) {
        this.allowMissingSystem = allowMissingSystem;
        return this;
    }

    public static void runModule(String module, String version2, String runClass, String ... arguments) {
        Main.instance().run(module, version2, runClass, arguments);
    }

    public void run(String module, String version2, String runClass, String ... arguments) {
        this.setup(module, version2);
        try {
            Class<?> klass = this.moduleClassLoader.loadClass(runClass);
            Main.invokeMain(klass, arguments);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void runModule(String module, String version2, Class<?> runClass, String ... arguments) {
        Main.instance().run(module, version2, runClass, arguments);
    }

    public void run(String module, String version2, Class<?> runClass, String ... arguments) {
        this.setup(module, version2);
        try {
            Main.invokeMain(runClass, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void invokeMain(Class<?> klass, String[] arguments) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method main = klass.getMethod("main", String[].class);
        main.invoke(null, new Object[]{arguments});
    }

    public static void setupMetamodel(String module, String version2) {
        Main.instance().setup(module, version2);
    }

    public void setup(String module, String version2) {
        Overrides parsedOverrides = Overrides.getDistOverrides();
        if (this.overrides != null) {
            try {
                parsedOverrides = parsedOverrides.append(this.overrides);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Metamodel.resetModuleManager(new OverridesRuntimeResolver(parsedOverrides));
        if (this.moduleClassLoader == null) {
            this.setupModuleClassLoader(module);
        }
        if (this.classPath == null) {
            this.classPath = new ClassPath(parsedOverrides);
            this.visited = new HashSet<ClassPath.Module>();
            this.registerInMetamodel("ceylon.language", "1.3.2", false);
            this.registerInMetamodel("com.redhat.ceylon.common", "1.3.2", false);
            this.registerInMetamodel("com.redhat.ceylon.model", "1.3.2", false);
        }
        if (module.equals("default")) {
            version2 = null;
        }
        this.registerInMetamodel(module, version2, false);
    }

    private void setupModuleClassLoader(String module) {
        if (JDKUtils.jdk.providesVersion(JDKUtils.JDK.JDK9.version)) {
            try {
                Object mod = Java9ModuleUtil.getModule(this.getClass());
                if (Java9ModuleUtil.isNamedModule(mod)) {
                    Object otherModule = Java9ModuleUtil.findModule(mod, module);
                    if (otherModule == null) {
                        otherModule = Java9ModuleUtil.loadModuleDynamically(module);
                    }
                    if (otherModule != null) {
                        Class<?> moduleClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.reflect.Module");
                        Method addReads = moduleClass.getMethod("addReads", moduleClass);
                        addReads.invoke(mod, otherModule);
                        this.moduleClassLoader = Java9ModuleUtil.getClassLoader(otherModule);
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException x) {
                throw new RuntimeException(x);
            }
        }
        if (this.moduleClassLoader == null) {
            this.moduleClassLoader = ClassLoader.getSystemClassLoader();
        }
    }

    public static void resetMetamodel() {
        Main.instance().reset();
    }

    public void reset() {
        Metamodel.resetModuleManager();
    }

    private void registerInMetamodel(String name, String version2, boolean optional) {
        ClassPath.Module module;
        try {
            module = this.classPath.loadModule(name, version2, this.allowMissingModules);
        }
        catch (ClassPath.ModuleNotFoundException e) {
            if (optional) {
                return;
            }
            throw new RuntimeException(e);
        }
        if (!this.visited.add(module)) {
            return;
        }
        if (module.type == ClassPath.Type.JDK) {
            return;
        }
        Metamodel.loadModule(name, version2, module, this.moduleClassLoader);
        for (ClassPath.Dependency dep : module.dependencies) {
            this.registerInMetamodel(dep.name(), dep.version(), dep.optional);
        }
    }

    public static void main(String[] args) {
        ModuleSpec moduleSpec;
        String arg;
        int idx = 0;
        boolean allowMissingModules = false;
        String overrides = null;
        for (int i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("--allow-missing-modules")) {
                allowMissingModules = true;
            } else if (arg.equals("--overrides") || arg.equals("--maven-overrides")) {
                if (i + 1 >= args.length) {
                    Main.usage();
                }
                overrides = args[++i];
                ++idx;
            } else {
                Main.usage();
            }
            ++idx;
        }
        if (args.length < 2 + idx) {
            Main.usage();
        }
        String version2 = (moduleSpec = ModuleSpec.parse(args[idx], ModuleSpec.Option.VERSION_REQUIRED)).getName().equals("default") ? null : moduleSpec.getVersion();
        String[] moduleArgs = Arrays.copyOfRange(args, 2 + idx, args.length);
        Main.instance().allowMissingModules(allowMissingModules).overrides(overrides).run(moduleSpec.getName(), version2, args[idx + 1], moduleArgs);
    }

    private static void usage() {
        System.err.println("Invalid arguments.");
        System.err.println("Usage: \n");
        System.err.println(Main.class.getName() + " [--allow-missing-modules] [--overrides overridesFile.xml] moduleSpec mainJavaClassName args*");
        System.exit(1);
    }

    static class ClassPath {
        private static final String METAINF_JBOSSMODULES = "META-INF/jbossmodules/";
        private static final String METAINF_MAVEN = "META-INF/maven/";
        private static final String MODULE_PROPERTIES = "module.properties";
        private static final String MODULE_XML = "module.xml";
        private static final String POM_XML = "pom.xml";
        private static final String JAVA9_MODULE = "module-info.class";
        private List<File> potentialJars = new LinkedList<File>();
        private Map<String, Module> modules = new HashMap<String, Module>();
        private Overrides overrides;
        private static DependencyResolver MavenResolver = Configuration.getMavenResolver();
        private static final Module NO_MODULE;

        ClassPath(Overrides overrides) {
            String modulePath;
            String[] classPathEntries;
            String classPath = System.getProperty("java.class.path");
            for (String classPathEntry : classPathEntries = classPath.split(File.pathSeparator)) {
                File entry = new File(classPathEntry);
                if (!entry.isFile()) continue;
                this.potentialJars.add(entry);
            }
            if (JDKUtils.jdk.providesVersion(JDKUtils.JDK.JDK9.version) && (modulePath = System.getProperty("jdk.module.path")) != null) {
                String[] modulePathEntries;
                for (String moduleFolder : modulePathEntries = modulePath.split(File.pathSeparator)) {
                    File folder = new File(moduleFolder);
                    if (!folder.isDirectory()) continue;
                    this.scanFolderForJars(folder);
                }
            }
            this.overrides = overrides;
            this.initJars();
        }

        private void scanFolderForJars(File folder) {
            for (File file : folder.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".car") && !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                this.potentialJars.add(file);
            }
        }

        ClassPath(List<File> potentialJars) {
            this.potentialJars = potentialJars;
            this.initJars();
        }

        private List<ZipEntry> findEntries(ZipFile zipFile, String startFolder, String entryName) {
            LinkedList<ZipEntry> result = new LinkedList<ZipEntry>();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(startFolder) || !name.endsWith(entryName)) continue;
                result.add(entry);
            }
            return result;
        }

        private ModuleSpec moduleFromEntry(ZipEntry entry) {
            String fullName = entry.getName();
            if (fullName.startsWith(METAINF_JBOSSMODULES)) {
                fullName = fullName.substring(METAINF_JBOSSMODULES.length());
            }
            if (fullName.endsWith(MODULE_PROPERTIES)) {
                fullName = fullName.substring(0, fullName.length() - MODULE_PROPERTIES.length() - 1);
            } else if (fullName.endsWith(MODULE_XML)) {
                fullName = fullName.substring(0, fullName.length() - MODULE_XML.length() - 1);
            }
            int p = fullName.lastIndexOf(47);
            if (p > 0) {
                String name = fullName.substring(0, p);
                String version2 = fullName.substring(p + 1);
                if (!name.isEmpty() && !version2.isEmpty()) {
                    name = name.replace('/', '.');
                    return new ModuleSpec(null, name, version2);
                }
            }
            return null;
        }

        private ModuleSpec moduleFromCeylonRepoFile(File jar) {
            String suffix;
            File parent = jar.getParentFile();
            if (parent == null) {
                return null;
            }
            String version2 = parent.getName();
            String jarName = jar.getName();
            if (!jarName.endsWith(suffix = "-" + version2 + ".jar")) {
                return null;
            }
            String modName = jarName.substring(0, jarName.length() - suffix.length());
            return new ModuleSpec(null, modName, version2);
        }

        public Module loadModule(String name, String version2) throws ModuleNotFoundException {
            return this.loadModule(name, version2, false);
        }

        public Module loadModule(String name, String version2, boolean allowMissingModules) throws ModuleNotFoundException {
            String key = name;
            Module module = this.modules.get(key);
            if (module != null) {
                return module;
            }
            if (JDKUtils.jdk.providesVersion(JDKUtils.JDK.JDK9.version)) {
                name = JDKUtils.getJava9ModuleName(name, version2);
            }
            if (JDKUtils.isJDKModule(name) || JDKUtils.isOracleJDKModule(name)) {
                module = new Module(name, JDKUtils.jdk.version, null, null, Type.JDK, null);
                this.modules.put(key, module);
                return module;
            }
            module = this.searchJars(name, version2);
            if (module != null) {
                return module;
            }
            if (allowMissingModules) {
                return new Module(name, version2, null, null, Type.UNKNOWN, null);
            }
            throw new ModuleNotFoundException("Module " + key + " not found");
        }

        private void initJars() {
            this.searchJars(null, null);
        }

        private Module searchJars(String name, String version2) {
            if (this.overrides != null) {
                ArtifactContext ctx = new ArtifactContext(null, name, version2);
                ArtifactContext replacement = this.overrides.replace(ctx);
                if (replacement != null) {
                    name = replacement.getName();
                    version2 = replacement.getVersion();
                    ctx = replacement;
                }
                if (this.overrides.isVersionOverridden(ctx)) {
                    version2 = this.overrides.getVersionOverride(ctx);
                }
            }
            Iterator<File> iterator = this.potentialJars.iterator();
            while (iterator.hasNext()) {
                Module module;
                File file = iterator.next();
                try {
                    module = name == null && version2 == null ? this.initJar(file) : this.loadJar(file, name, version2);
                }
                catch (IOException e) {
                    iterator.remove();
                    e.printStackTrace();
                    System.err.println("Non-zip jar file in classpath: " + file + ". Skipping it next time.");
                    continue;
                }
                if (module == null) continue;
                if (module != NO_MODULE) {
                    String key = module.name();
                    this.modules.put(key, module);
                }
                iterator.remove();
                if (name == null && version2 == null) continue;
                return module;
            }
            return null;
        }

        /*
         * Exception decompiling
         */
        private Module initJar(File file) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Module loadJar(File file, String name, String version2) throws IOException {
            try (ZipFile zipFile = new ZipFile(file);){
                Module module;
                List<ZipEntry> java9Module;
                Object groupId;
                String ceylonPath;
                ZipEntry moduleDescriptor;
                Object externalDescriptorPath;
                Object mavenDescriptor;
                Object descriptorPath;
                int mavenSeparator = name.indexOf(":");
                if (mavenSeparator != -1) {
                    String artifactId;
                    String groupId2 = name.substring(0, mavenSeparator);
                    descriptorPath = String.format("META-INF/maven/%s/%s/pom.xml", groupId2, artifactId = name.substring(mavenSeparator + 1));
                    mavenDescriptor = zipFile.getEntry((String)descriptorPath);
                    if (mavenDescriptor != null) {
                        Module module2 = this.loadMavenJar(file, zipFile, (ZipEntry)mavenDescriptor, name, version2);
                        return module2;
                    }
                    externalDescriptorPath = String.format("%s-%s.pom", artifactId, version2);
                    File externalDescriptor = new File(file.getParentFile(), (String)externalDescriptorPath);
                    if (externalDescriptor.exists()) {
                        Module module3 = this.loadMavenJar(file, externalDescriptor, name, version2);
                        return module3;
                    }
                }
                if ((moduleDescriptor = zipFile.getEntry((ceylonPath = name.replace('.', '/')) + "/" + "$module_" + ".class")) != null) {
                    descriptorPath = this.loadCeylonModuleCar(file, zipFile, moduleDescriptor, name, version2);
                    return descriptorPath;
                }
                ZipEntry moduleXml = zipFile.getEntry(METAINF_JBOSSMODULES + ceylonPath + "/" + version2 + "/module.xml");
                if (moduleXml != null) {
                    mavenDescriptor = this.loadJBossModuleXmlJar(file, zipFile, moduleXml, name, version2);
                    return mavenDescriptor;
                }
                ZipEntry moduleProperties = zipFile.getEntry(METAINF_JBOSSMODULES + ceylonPath + "/" + version2 + "/module.properties");
                if (moduleProperties != null) {
                    externalDescriptorPath = this.loadJBossModulePropertiesJar(file, zipFile, moduleProperties, name, version2);
                    return externalDescriptorPath;
                }
                if (MavenResolver != null) {
                    int lastDot = name.lastIndexOf(46);
                    while (lastDot != -1) {
                        String artifactId;
                        groupId = name.substring(0, lastDot);
                        String descriptorPath2 = String.format("META-INF/maven/%s/%s/pom.xml", groupId, artifactId = name.substring(lastDot + 1));
                        ZipEntry mavenDescriptor2 = zipFile.getEntry(descriptorPath2);
                        if (mavenDescriptor2 != null) {
                            Module module4 = this.loadMavenJar(file, zipFile, mavenDescriptor2, name, version2);
                            return module4;
                        }
                        lastDot = name.lastIndexOf(46, lastDot - 1);
                    }
                }
                if ((java9Module = this.findEntries(zipFile, "", JAVA9_MODULE)).size() == 1) {
                    groupId = this.loadJava9ModuleJar(file, zipFile, java9Module.get(0), name, version2);
                    return groupId;
                }
                ZipEntry osgiProperties = zipFile.getEntry("META-INF/MANIFEST.MF");
                if (osgiProperties != null && (module = this.loadOsgiJar(file, zipFile, osgiProperties, name, version2)) != null) {
                    Module module5 = module;
                    return module5;
                }
                Module module6 = null;
                return module6;
            }
        }

        private Module loadCeylonModuleCar(File file, ZipFile zipFile, ZipEntry moduleDescriptor, String name, String version2) throws IOException {
            try (InputStream inputStream = zipFile.getInputStream(moduleDescriptor);){
                String artifactId;
                ClassFile classFile = ClassFile.read(inputStream);
                RuntimeAnnotations_attribute annotationsAttribute = (RuntimeAnnotations_attribute)classFile.getAttribute("RuntimeVisibleAnnotations");
                Annotation moduleAnnotation = ClassFileUtil.findAnnotation(classFile, annotationsAttribute, com.redhat.ceylon.compiler.java.metadata.Module.class);
                if (moduleAnnotation == null) {
                    throw new IOException("Missing module annotation");
                }
                Object moduleName = ClassFileUtil.getAnnotationValue(classFile, moduleAnnotation, "name");
                Object moduleVersion = ClassFileUtil.getAnnotationValue(classFile, moduleAnnotation, "version");
                if (!(moduleName instanceof String) || !(moduleVersion instanceof String)) {
                    throw new IOException("Invalid module annotation");
                }
                if (name != null && !((String)moduleName).equals(name)) {
                    throw new IOException("Module name does not match module descriptor");
                }
                if (version2 != null && !((String)moduleVersion).equals(version2)) {
                    throw new IOException("Module version does not match module descriptor");
                }
                name = (String)moduleName;
                version2 = (String)moduleVersion;
                String groupId = (String)ClassFileUtil.getAnnotationValue(classFile, moduleAnnotation, "group");
                if (groupId != null) {
                    artifactId = (String)ClassFileUtil.getAnnotationValue(classFile, moduleAnnotation, "artifact");
                    if (artifactId == null || artifactId.isEmpty()) {
                        artifactId = name;
                    }
                } else {
                    String[] coordinates = ModuleUtil.getMavenCoordinates(name);
                    groupId = coordinates[0];
                    artifactId = coordinates[1];
                }
                Module module = new Module(name, version2, groupId, artifactId, Type.CEYLON, file);
                Object moduleDependencies = ClassFileUtil.getAnnotationValue(classFile, moduleAnnotation, "dependencies");
                ArtifactOverrides ao = null;
                if (this.overrides != null) {
                    ao = this.overrides.getArtifactOverrides(new ArtifactContext(null, name, version2));
                }
                if (moduleDependencies instanceof Object[]) {
                    int[] binver = BytecodeUtils.getBinaryVersions(classFile);
                    boolean supportsNamespaces = binver != null && ModuleUtil.supportsImportsWithNamespaces(binver[0], binver[1]);
                    for (Object dependency : (Object[])moduleDependencies) {
                        Boolean export;
                        String depNamespace;
                        Annotation dependencyAnnotation = (Annotation)dependency;
                        String depName = (String)ClassFileUtil.getAnnotationValue(classFile, dependencyAnnotation, "name");
                        if (supportsNamespaces) {
                            depNamespace = (String)ClassFileUtil.getAnnotationValue(classFile, dependencyAnnotation, "namespace");
                            if (depNamespace != null && depNamespace.isEmpty()) {
                                depNamespace = null;
                            }
                        } else {
                            depNamespace = ModuleUtil.isMavenModule(depName) ? "maven" : null;
                        }
                        String depVersion = (String)ClassFileUtil.getAnnotationValue(classFile, dependencyAnnotation, "version");
                        Boolean optional = (Boolean)ClassFileUtil.getAnnotationValue(classFile, dependencyAnnotation, "optional");
                        if (optional == null) {
                            optional = false;
                        }
                        if ((export = (Boolean)ClassFileUtil.getAnnotationValue(classFile, dependencyAnnotation, "export")) == null) {
                            export = false;
                        }
                        if (depName == null || depVersion == null) {
                            throw new IOException("Invalid module import");
                        }
                        if (this.overrides != null) {
                            ArtifactContext depCtx = new ArtifactContext(depNamespace, depName, depVersion);
                            ArtifactContext replacement = this.overrides.replace(depCtx);
                            if (replacement != null) {
                                depCtx = replacement;
                                depNamespace = replacement.getNamespace();
                                depName = replacement.getName();
                                depVersion = replacement.getVersion();
                            }
                            if (this.overrides.isVersionOverridden(depCtx)) {
                                depVersion = this.overrides.getVersionOverride(depCtx);
                                depCtx.setVersion(depVersion);
                            }
                            if (this.overrides.isRemoved(depCtx)) continue;
                            if (ao != null) {
                                if (ao.isAddedOrUpdated(depCtx)) continue;
                                if (ao.isOptionalOverridden(depCtx)) {
                                    optional = ao.isOptional(depCtx);
                                }
                                if (ao.isShareOverridden(depCtx)) {
                                    export = ao.isShared(depCtx);
                                }
                            }
                        }
                        module.addDependency(depName, depVersion, optional, export);
                    }
                    if (ao != null) {
                        for (DependencyOverride dep : ao.getAdd()) {
                            module.addDependency(dep.getArtifactContext().getName(), dep.getArtifactContext().getVersion(), dep.isOptional(), dep.isShared());
                        }
                    }
                }
                Module module2 = module;
                return module2;
            }
        }

        private Module loadJBossModulePropertiesJar(File file, ZipFile zipFile, ZipEntry moduleProperties, String name, String version2) throws IOException {
            return this.loadJBossModuleJar(file, zipFile, moduleProperties, PropertiesDependencyResolver.INSTANCE, name, version2);
        }

        private Module loadJBossModuleJar(File file, ZipFile zipFile, ZipEntry moduleDescriptor, DependencyResolver dependencyResolver, String name, String version2) throws IOException {
            return this.loadFromResolver(file, zipFile, moduleDescriptor, dependencyResolver, name, version2, Type.JBOSS_MODULES);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Module loadFromResolver(File file, ZipFile zipFile, ZipEntry moduleDescriptor, DependencyResolver dependencyResolver, String name, String version2, Type moduleType) throws IOException {
            try (InputStream inputStream = zipFile.getInputStream(moduleDescriptor);){
                Module module = this.loadFromResolver(file, inputStream, dependencyResolver, name, version2, moduleType);
                return module;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Module loadFromResolver(File file, File moduleDescriptor, DependencyResolver dependencyResolver, String name, String version2, Type moduleType) throws IOException {
            try (FileInputStream inputStream = new FileInputStream(moduleDescriptor);){
                Module module = this.loadFromResolver(file, inputStream, dependencyResolver, name, version2, moduleType);
                return module;
            }
        }

        private Module loadFromResolver(File file, InputStream inputStream, DependencyResolver dependencyResolver, String name, String version2, Type moduleType) throws IOException {
            ModuleInfo moduleInfo = dependencyResolver.resolveFromInputStream(inputStream, name, version2, this.overrides);
            if (moduleInfo != null) {
                if (name != null && moduleInfo.getName() != null && !name.equals(moduleInfo.getName())) {
                    return null;
                }
                if (version2 != null && moduleInfo.getVersion() != null && !version2.equals(moduleInfo.getVersion())) {
                    return null;
                }
                Module module = new Module(name != null ? name : moduleInfo.getName(), version2 != null ? version2 : moduleInfo.getVersion(), moduleInfo.getGroupId(), moduleInfo.getArtifactId(), moduleType, file);
                for (ModuleDependencyInfo dep : moduleInfo.getDependencies()) {
                    if (dep.getModuleScope() == ModuleScope.TEST) continue;
                    module.addDependency(dep.getName(), dep.getVersion(), dep.isOptional(), dep.isExport());
                }
                if (moduleInfo.getFilter() != null) {
                    module.setFilter(PathFilterParser.parse(moduleInfo.getFilter()));
                }
                return module;
            }
            return null;
        }

        private Module loadJBossModuleXmlJar(File file, ZipFile zipFile, ZipEntry moduleXml, String name, String version2) throws IOException {
            return this.loadJBossModuleJar(file, zipFile, moduleXml, XmlDependencyResolver.INSTANCE, name, version2);
        }

        private Module loadMavenJar(File file, ZipFile zipFile, ZipEntry moduleDescriptor, String name, String version2) throws IOException {
            if (MavenResolver == null) {
                return null;
            }
            return this.loadFromResolver(file, zipFile, moduleDescriptor, MavenResolver, name, version2, Type.MAVEN);
        }

        private Module loadMavenJar(File file, File moduleDescriptor, String name, String version2) throws IOException {
            if (MavenResolver == null) {
                return null;
            }
            return this.loadFromResolver(file, moduleDescriptor, MavenResolver, name, version2, Type.MAVEN);
        }

        private Module loadDefaultJar(File file) throws IOException {
            return new Module("default", null, null, null, Type.CEYLON, file);
        }

        private Module loadJava9ModuleJar(File file, ZipFile zipFile, ZipEntry moduleDescriptor, String name, String version2) throws IOException {
            Java9ModuleReader.Java9Module java9Module = Java9ModuleReader.getJava9Module(zipFile, moduleDescriptor);
            if (java9Module != null) {
                return new Module(java9Module.name, java9Module.version, null, null, Type.JAVA9, file);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Module loadOsgiJar(File file, ZipFile zipFile, ZipEntry moduleDescriptor, String name, String version2) throws IOException {
            try (InputStream inputStream = zipFile.getInputStream(moduleDescriptor);){
                Manifest manifest = new Manifest(inputStream);
                if (OsgiUtil.DefaultModuleManifest.isDefaultModule(manifest)) {
                    Module module = this.loadDefaultJar(file);
                    return module;
                }
                Attributes attributes = manifest.getMainAttributes();
                String bundleName = attributes.getValue(OsgiUtil.OsgiManifest.Bundle_SymbolicName);
                String bundleVersion = attributes.getValue(OsgiUtil.OsgiManifest.Bundle_Version);
                if (name != null && version2 != null) {
                    if (!Objects.equals(name, bundleName) || !Objects.equals(version2, bundleVersion)) {
                        Module module = null;
                        return module;
                    }
                } else {
                    name = bundleName;
                    version2 = bundleVersion;
                }
            }
            return this.loadFromResolver(file, zipFile, moduleDescriptor, OSGiDependencyResolver.INSTANCE, name, version2, Type.OSGi);
        }

        static {
            if (MavenResolver == null) {
                MavenResolver = MavenBackupDependencyResolver.INSTANCE;
            }
            NO_MODULE = new Module("$$$", "$$$", null, null, Type.UNKNOWN, null);
        }

        static class Module
        extends AbstractArtifactResult {
            public final File jar;
            public final Type type;
            public final List<Dependency> dependencies = new LinkedList<Dependency>();
            private String groupId;
            private String artifactId;

            public Module(String name, String version2, String groupId, String artifactId, Type type, File jar) {
                super(null, null, name, version2);
                this.type = type;
                this.jar = jar;
                this.groupId = groupId;
                this.artifactId = artifactId;
            }

            public void addDependency(String name, String version2, boolean optional, boolean shared) {
                this.dependencies.add(new Dependency(name, version2, optional, shared));
            }

            @Override
            public String namespace() {
                return null;
            }

            public int hashCode() {
                int ret = 31;
                ret = 37 * ret + this.name().hashCode();
                ret = 37 * ret + (this.version() != null ? this.version().hashCode() : 0);
                return ret;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Module)) {
                    return false;
                }
                Module other = (Module)obj;
                return this.name().equals(other.name()) && Objects.equals(this.version(), other.version());
            }

            @Override
            public String toString() {
                StringBuilder b = new StringBuilder();
                b.append("Module{ name = ").append(this.name());
                b.append(", version = ").append(this.version());
                b.append(", jar = ").append(this.jar);
                b.append(", type = ").append((Object)this.type);
                b.append(", dependencies = [");
                boolean once = true;
                for (Dependency dep : this.dependencies) {
                    if (once) {
                        once = false;
                    } else {
                        b.append(", ");
                    }
                    b.append(dep);
                }
                b.append(" ] }");
                return b.toString();
            }

            @Override
            public ArtifactResultType type() {
                switch (this.type) {
                    case CEYLON: 
                    case JBOSS_MODULES: 
                    case OSGi: 
                    case JDK: {
                        return ArtifactResultType.CEYLON;
                    }
                    case MAVEN: {
                        return ArtifactResultType.MAVEN;
                    }
                }
                return ArtifactResultType.OTHER;
            }

            @Override
            public List<ArtifactResult> dependencies() throws RepositoryException {
                return this.dependencies;
            }

            @Override
            public String repositoryDisplayString() {
                return this.name() + "/" + this.version();
            }

            @Override
            protected File artifactInternal() {
                return this.jar;
            }

            public void setFilter(PathFilter filter) {
                this.setFilterInternal(filter);
            }

            @Override
            public String groupId() {
                return this.groupId;
            }

            @Override
            public String artifactId() {
                return this.artifactId;
            }
        }

        static class Dependency
        extends AbstractArtifactResult {
            public final boolean optional;
            public final boolean shared;

            public Dependency(String name, String version2, boolean optional, boolean shared) {
                super(null, null, name, version2);
                this.optional = optional;
                this.shared = shared;
            }

            @Override
            public String toString() {
                StringBuilder b = new StringBuilder();
                b.append("Import{ name = ").append(this.name());
                b.append(", version = ").append(this.version());
                b.append(", optional = ").append(this.optional);
                b.append(", shared = ").append(this.shared);
                b.append(" }");
                return b.toString();
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Dependency)) {
                    return false;
                }
                Dependency other = (Dependency)obj;
                return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && this.optional == other.optional && this.shared == other.shared;
            }

            public int hashCode() {
                int ret = 17;
                ret = ret * 23 + (this.name() != null ? this.name().hashCode() : 0);
                ret = ret * 23 + (this.version() != null ? this.version().hashCode() : 0);
                ret = ret * 23 + (this.optional ? 1 : 0);
                ret = ret * 23 + (this.shared ? 1 : 0);
                return ret;
            }

            @Override
            public ArtifactResultType type() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<ArtifactResult> dependencies() throws RepositoryException {
                throw new UnsupportedOperationException();
            }

            @Override
            public String repositoryDisplayString() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected File artifactInternal() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String groupId() {
                return null;
            }

            @Override
            public String artifactId() {
                return null;
            }
        }

        private static enum Type {
            CEYLON,
            JBOSS_MODULES,
            MAVEN,
            OSGi,
            UNKNOWN,
            JDK,
            JAVA9;

        }

        public class ModuleNotFoundException
        extends Exception {
            public ModuleNotFoundException(String string) {
                super(string);
            }
        }
    }
}

