/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools;

import com.redhat.ceylon.compiler.java.runtime.tools.Backend;
import com.redhat.ceylon.compiler.java.runtime.tools.Compiler;
import com.redhat.ceylon.compiler.java.runtime.tools.Runner;
import com.redhat.ceylon.compiler.java.runtime.tools.RunnerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.JavaCompilerImpl;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.JavaRunnerImpl;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.JavaScriptCompilerImpl;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.JavaScriptRunnerImpl;

public class CeylonToolProvider {
    public static Compiler getCompiler(Backend backend) {
        switch (backend) {
            case Java: {
                return new JavaCompilerImpl();
            }
            case JavaScript: {
                return new JavaScriptCompilerImpl();
            }
        }
        throw new RuntimeException("Compiler for backend not supported yet: " + (Object)((Object)backend));
    }

    public static Runner getRunner(Backend backend, RunnerOptions options, String module, String version2) {
        switch (backend) {
            case JavaScript: {
                return new JavaScriptRunnerImpl(options, module, version2);
            }
            case Java: {
                return new JavaRunnerImpl(options, module, version2);
            }
        }
        throw new RuntimeException("Runner for backend not supported yet: " + (Object)((Object)backend));
    }
}

