/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools;

import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.Options;
import java.io.File;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public class CompilerOptions
extends Options {
    private List<String> modules = new LinkedList<String>();
    private List<File> files = new LinkedList<File>();
    private List<File> sourcePath = new LinkedList<File>();
    private List<File> resourcePath = new LinkedList<File>();
    private List<String> suppressWarnings;
    private String resourceRootName;
    private String outputRepository;
    private Writer outWriter;
    private String encoding;
    private String includeDependencies;
    private boolean progress;

    public List<String> getModules() {
        return this.modules;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public void addModule(String module) {
        this.modules.add(module);
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public List<File> getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(List<File> sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void addSourcePath(File sourcePath) {
        this.sourcePath.add(sourcePath);
    }

    public List<File> getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(List<File> resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void addResourcePath(File resourcePath) {
        this.resourcePath.add(resourcePath);
    }

    public String getResourceRootName() {
        return this.resourceRootName;
    }

    public void setResourceRootName(String resourceRootName) {
        this.resourceRootName = resourceRootName;
    }

    public String getOutputRepository() {
        return this.outputRepository;
    }

    public void setOutputRepository(String outputRepository) {
        this.outputRepository = outputRepository;
    }

    public List<String> getSuppressWarnings() {
        return this.suppressWarnings;
    }

    public void setSuppressWarnings(List<String> suppressWarnings) {
        this.suppressWarnings = suppressWarnings;
    }

    public boolean getProgress() {
        return this.progress;
    }

    public void setProgress(boolean progress) {
        this.progress = progress;
    }

    public String getIncludeDependencies() {
        return this.includeDependencies;
    }

    public void setIncludeDependencies(String includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public Writer getOutWriter() {
        return this.outWriter;
    }

    public void setOutWriter(Writer outWriter) {
        this.outWriter = outWriter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void mapOptions(CeylonConfig config) {
        super.mapOptions(config);
        this.setEncoding(DefaultToolOptions.getDefaultEncoding(config));
        this.setOutputRepository(DefaultToolOptions.getCompilerOutputRepo(config));
        this.setSourcePath(DefaultToolOptions.getCompilerSourceDirs(config));
        this.setResourcePath(DefaultToolOptions.getCompilerResourceDirs(config));
        this.setResourceRootName(DefaultToolOptions.getCompilerResourceRootName(config));
        this.setSuppressWarnings(DefaultToolOptions.getCompilerSuppressWarnings(config));
        this.setProgress(DefaultToolOptions.getCompilerProgress(config));
        this.setIncludeDependencies(DefaultToolOptions.getCompilerIncludeDependencies(config));
    }

    public static CompilerOptions fromConfig() {
        return CompilerOptions.fromConfig(CeylonConfig.get());
    }

    public static CompilerOptions fromConfig(CeylonConfig config) {
        CompilerOptions options = new CompilerOptions();
        options.mapOptions(config);
        return options;
    }
}

