/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.javax.lang.model.element.Modifier;
import com.redhat.ceylon.javax.lang.model.element.NestingKind;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;

public class JarEntryFileObject
implements JavaFileObject {
    private File jarTempFolder;
    private String fileName;
    private File file;

    public JarEntryFileObject(File jarTempFolder, String fileName) {
        this.jarTempFolder = jarTempFolder;
        this.fileName = fileName;
        this.file = new File(jarTempFolder, fileName);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        FileUtil.mkdirs(this.file.getParentFile());
        return new FileOutputStream(this.file);
    }

    public int hashCode() {
        int ret = 17;
        ret = 37 * ret + this.jarTempFolder.hashCode();
        ret = 37 * ret + this.fileName.hashCode();
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JarEntryFileObject) {
            JarEntryFileObject r = (JarEntryFileObject)obj;
            return this.jarTempFolder.equals(r.jarTempFolder) && this.fileName.equals(r.fileName);
        }
        return false;
    }

    public String toString() {
        return this.jarTempFolder + ":" + this.fileName;
    }

    @Override
    public URI toUri() {
        return null;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return null;
    }

    @Override
    public Writer openWriter() throws IOException {
        return null;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return null;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }
}

