/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.compiler.java.codegen.CeylonClassWriter;
import com.redhat.ceylon.compiler.java.codegen.CeylonCompilationUnit;
import com.redhat.ceylon.compiler.java.codegen.CeylonFileObject;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.loader.CeylonEnter;
import com.redhat.ceylon.compiler.java.loader.CeylonModelLoader;
import com.redhat.ceylon.compiler.java.tools.CeylonLocation;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.java.tools.CeylonPhasedUnit;
import com.redhat.ceylon.compiler.java.tools.CeyloncCompilerDelegate;
import com.redhat.ceylon.compiler.java.tools.CeyloncFileManager;
import com.redhat.ceylon.compiler.java.tools.StatusPrinterAptProgressListener;
import com.redhat.ceylon.compiler.java.tools.StatusPrinterTaskListener;
import com.redhat.ceylon.compiler.java.util.Timer;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.io.VFS;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.parser.CeylonLexer;
import com.redhat.ceylon.compiler.typechecker.parser.CeylonParser;
import com.redhat.ceylon.compiler.typechecker.parser.LexError;
import com.redhat.ceylon.compiler.typechecker.parser.ParseError;
import com.redhat.ceylon.compiler.typechecker.parser.RecognitionError;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.util.ModuleManagerFactory;
import com.redhat.ceylon.compiler.typechecker.util.NewlineFixingStringStream;
import com.redhat.ceylon.javax.annotation.processing.Processor;
import com.redhat.ceylon.javax.tools.FileObject;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.comp.AttrContext;
import com.redhat.ceylon.langtools.tools.javac.comp.CompileStates;
import com.redhat.ceylon.langtools.tools.javac.comp.Env;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import com.redhat.ceylon.langtools.tools.javac.jvm.ClassWriter;
import com.redhat.ceylon.langtools.tools.javac.main.JavaCompiler;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.parser.JavacParser;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeInfo;
import com.redhat.ceylon.langtools.tools.javac.util.Abort;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Convert;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.langtools.tools.javac.util.Pair;
import com.redhat.ceylon.langtools.tools.javac.util.Position;
import com.redhat.ceylon.langtools.tools.javac.util.SourceLanguage;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.antlr.runtime.CommonTokenStream;

public class LanguageCompiler
extends JavaCompiler {
    protected static final Context.Key<PhasedUnits> phasedUnitsKey = new Context.Key();
    public static final Context.Key<CompilerDelegate> compilerDelegateKey = new Context.Key();
    public static final Context.Key<com.redhat.ceylon.compiler.typechecker.context.Context> ceylonContextKey = new Context.Key();
    public static final Context.Key<StatusPrinter> statusPrinterKey = new Context.Key();
    private final CeylonTransformer gen;
    private final PhasedUnits phasedUnits;
    private final CompilerDelegate compilerDelegate;
    private final com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext;
    private final VFS vfs;
    private AbstractModelLoader modelLoader;
    private CeylonEnter ceylonEnter;
    private Options options;
    private Timer timer;
    private boolean isBootstrap;
    private boolean addedDefaultModuleToClassPath;
    private boolean treatLikelyBugsAsErrors = false;
    private Set<Module> modulesLoadedFromSource = new HashSet<Module>();
    private com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> resourceFileObjects;
    private Map<String, CeylonFileObject> moduleNamesToFileObjects = new HashMap<String, CeylonFileObject>();
    private SourceLanguage sourceLanguage;
    private boolean addModuleTrees = true;
    private boolean hadRunTwiceException;
    private StatusPrinter sp;

    public static PhasedUnits getPhasedUnitsInstance(final Context context) {
        PhasedUnits phasedUnits = context.get(phasedUnitsKey);
        if (phasedUnits == null) {
            com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext = LanguageCompiler.getCeylonContextInstance(context);
            phasedUnits = new PhasedUnits(ceylonContext, new ModuleManagerFactory(){

                @Override
                public ModuleManager createModuleManager(com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext) {
                    CompilerDelegate phasedUnitsManager = LanguageCompiler.getCompilerDelegate(context);
                    return phasedUnitsManager.getModuleManager();
                }

                @Override
                public ModuleSourceMapper createModuleManagerUtil(com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext, ModuleManager moduleManager) {
                    CompilerDelegate phasedUnitsManager = LanguageCompiler.getCompilerDelegate(context);
                    return phasedUnitsManager.getModuleSourceMapper();
                }
            });
            context.put(phasedUnitsKey, phasedUnits);
        }
        return phasedUnits;
    }

    public static CompilerDelegate getCompilerDelegate(Context context) {
        CompilerDelegate compilerDelegate = context.get(compilerDelegateKey);
        if (compilerDelegate == null) {
            compilerDelegate = new CeyloncCompilerDelegate(context);
            context.put(compilerDelegateKey, compilerDelegate);
        }
        return compilerDelegate;
    }

    public static com.redhat.ceylon.compiler.typechecker.context.Context getCeylonContextInstance(Context context) {
        com.redhat.ceylon.compiler.typechecker.context.Context ceylonContext = context.get(ceylonContextKey);
        if (ceylonContext == null) {
            CeyloncFileManager fileManager = (CeyloncFileManager)context.get(JavaFileManager.class);
            VFS vfs = new VFS();
            ceylonContext = new com.redhat.ceylon.compiler.typechecker.context.Context(fileManager.getRepositoryManager(), vfs);
            context.put(ceylonContextKey, ceylonContext);
        }
        return ceylonContext;
    }

    public static StatusPrinter getStatusPrinterInstance(Context context) {
        StatusPrinter statusPrinter = context.get(statusPrinterKey);
        if (statusPrinter == null) {
            statusPrinter = new StatusPrinter();
            context.put(statusPrinterKey, statusPrinter);
        }
        return statusPrinter;
    }

    public static JavaCompiler instance(Context context) {
        Options options = Options.instance(context);
        options.put("-Xprefer", "source");
        Log log = CeylonLog.instance(context);
        CeylonEnter.instance(context);
        CeylonClassWriter.instance(context);
        JavaCompiler instance = (JavaCompiler)context.get(compilerKey);
        if (instance == null) {
            instance = new LanguageCompiler(context);
        }
        return instance;
    }

    public LanguageCompiler(Context context) {
        super(context);
        boolean isProgressPrinted;
        this.ceylonContext = LanguageCompiler.getCeylonContextInstance(context);
        this.vfs = this.ceylonContext.getVfs();
        this.compilerDelegate = LanguageCompiler.getCompilerDelegate(context);
        this.phasedUnits = LanguageCompiler.getPhasedUnitsInstance(context);
        try {
            this.gen = CeylonTransformer.getInstance(context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.modelLoader = CeylonModelLoader.instance(context);
        this.ceylonEnter = CeylonEnter.instance(context);
        this.options = Options.instance(context);
        this.isBootstrap = this.options.get(Option.BOOTSTRAPCEYLON) != null;
        this.timer = Timer.instance(context);
        this.sourceLanguage = SourceLanguage.instance(context);
        boolean bl = isProgressPrinted = this.options.get(Option.CEYLONPROGRESS) != null && StatusPrinter.canPrint();
        if (isProgressPrinted) {
            this.sp = LanguageCompiler.getStatusPrinterInstance(context);
            if (this.taskListener == null) {
                this.taskListener.add(new StatusPrinterTaskListener(this.sp));
            }
        }
    }

    @Override
    public void compile(com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> fileObjects, com.redhat.ceylon.langtools.tools.javac.util.List<String> classnames, Iterable<? extends Processor> processors) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> sourceFiles = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> resourceFiles = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (JavaFileObject fo : fileObjects) {
            if (this.isResource(fo)) {
                resourceFiles = resourceFiles.append(fo);
                continue;
            }
            sourceFiles = sourceFiles.append(fo);
        }
        this.resourceFileObjects = resourceFiles;
        sourceFiles = this.addModuleDescriptors(sourceFiles, resourceFiles);
        super.compile(sourceFiles, classnames, processors);
    }

    private boolean isResource(JavaFileObject fo) {
        String fileName = FileUtil.absoluteFile(new File(fo.toUri().getPath())).getPath();
        JavacFileManager dfm = (JavacFileManager)this.fileManager;
        for (File file : dfm.getLocation(CeylonLocation.RESOURCE_PATH)) {
            String prefix = FileUtil.absoluteFile(file).getPath();
            if (!fileName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> addModuleDescriptors(com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> sourceFiles, com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> resourceFiles) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> result = sourceFiles;
        JavacFileManager dfm = (JavacFileManager)this.fileManager;
        for (JavaFileObject fo : resourceFiles) {
            String resName = JarUtils.toPlatformIndependentPath(dfm.getLocation(CeylonLocation.RESOURCE_PATH), fo.getName());
            JavaFileObject moduleFile = this.findModuleDescriptorForFile(new File(resName));
            if (moduleFile == null || result.contains(moduleFile)) continue;
            result = result.append(moduleFile);
        }
        return result;
    }

    private JavaFileObject findModuleDescriptorForFile(File file) {
        JavacFileManager dfm = (JavacFileManager)this.fileManager;
        for (File dir = file.getParentFile(); dir != null; dir = dir.getParentFile()) {
            try {
                String name = dir.getPath() + "/module";
                JavaFileObject fo = dfm.getJavaFileForInput(StandardLocation.SOURCE_PATH, name, JavaFileObject.Kind.SOURCE);
                if (fo == null) continue;
                return fo;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void close(boolean disposeNames) {
        if (this.resourceFileObjects != null) {
            this.addResources();
            this.resourceFileObjects = null;
        }
        super.close(disposeNames);
    }

    public void addResourceFileObject(JavaFileObject rersoureFile) {
        this.resourceFileObjects = this.resourceFileObjects.append(rersoureFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResources() throws Abort {
        HashSet<String> written = new HashSet<String>();
        try {
            for (JavaFileObject fo : this.resourceFileObjects) {
                CeyloncFileManager dfm = (CeyloncFileManager)this.fileManager;
                String jarFileName = JarUtils.toPlatformIndependentPath(dfm.getLocation(CeylonLocation.RESOURCE_PATH), fo.getName());
                if (written.contains(jarFileName)) continue;
                dfm.setModule(this.modelLoader.findModuleForFile(new File(jarFileName)));
                FileObject outFile = dfm.getFileForOutput(StandardLocation.CLASS_OUTPUT, "", jarFileName, null);
                try (OutputStream out = outFile.openOutputStream();
                     FileInputStream in = new FileInputStream(new File(fo.getName()));){
                    JarUtils.copy(in, out);
                }
                written.add(jarFileName);
            }
        }
        catch (IOException ex) {
            throw new Abort(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCTree.JCCompilationUnit parse(JavaFileObject filename) {
        JavaFileObject prev = this.log.useSource(filename);
        try {
            JCTree.JCCompilationUnit t;
            if (filename.getName().endsWith(".java")) {
                t = this.parse(filename, this.readSource(filename));
            } else {
                t = this.ceylonParse(filename, this.readSource(filename));
                t.endPositions = new JavacParser.EmptyEndPosTable(null);
            }
            if (t.endPositions != null) {
                this.log.setEndPosTable(filename, t.endPositions);
            }
            JCTree.JCCompilationUnit jCCompilationUnit = t;
            return jCCompilationUnit;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    @Override
    protected JCTree.JCCompilationUnit parse(JavaFileObject filename, CharSequence readSource) {
        if (filename instanceof CeylonFileObject) {
            return this.ceylonParse(filename, readSource);
        }
        return super.parse(filename, readSource);
    }

    private JCTree.JCCompilationUnit ceylonParse(JavaFileObject filename, CharSequence readSource) {
        if (this.ceylonEnter.hasRun()) {
            throw new RunTwiceException("Trying to load new source file after CeylonEnter has been called: " + filename);
        }
        try {
            EnumSet<Warning> suppressedWarnings;
            ModuleManager moduleManager = this.phasedUnits.getModuleManager();
            ModuleSourceMapper moduleSourceMapper = this.phasedUnits.getModuleSourceMapper();
            File sourceFile = new File(filename.getName());
            VirtualFile file = this.vfs.getFromFile(sourceFile);
            VirtualFile srcDir = this.vfs.getFromFile(this.getSrcDir(sourceFile));
            String source = readSource.toString();
            char[] chars = source.toCharArray();
            Position.LineMap map = Position.makeLineMap(chars, chars.length, false);
            CeylonPhasedUnit phasedUnit = null;
            PhasedUnit externalPhasedUnit = this.compilerDelegate.getExternalSourcePhasedUnit(srcDir, file);
            String suppressWarnings = this.options.get(Option.CEYLONSUPPRESSWARNINGS);
            if (suppressWarnings != null) {
                if (suppressWarnings.trim().isEmpty()) {
                    suppressedWarnings = EnumSet.allOf(Warning.class);
                } else {
                    suppressedWarnings = EnumSet.noneOf(Warning.class);
                    for (String name : suppressWarnings.trim().split(" *, *")) {
                        suppressedWarnings.add(Warning.valueOf(name));
                    }
                }
            } else {
                suppressedWarnings = EnumSet.noneOf(Warning.class);
            }
            if (externalPhasedUnit != null) {
                phasedUnit = new CeylonPhasedUnit(externalPhasedUnit, filename, map);
                phasedUnit.setSuppressedWarnings(suppressedWarnings);
                this.phasedUnits.addPhasedUnit(externalPhasedUnit.getUnitFile(), phasedUnit);
                this.gen.setMap(map);
                String pkgName = phasedUnit.getPackage().getQualifiedNameString();
                if ("".equals(pkgName)) {
                    pkgName = null;
                }
                return this.gen.makeJCCompilationUnitPlaceholder(phasedUnit.getCompilationUnit(), filename, pkgName, phasedUnit);
            }
            if (phasedUnit == null) {
                NewlineFixingStringStream input = new NewlineFixingStringStream(source);
                CeylonLexer lexer = new CeylonLexer(input);
                CommonTokenStream tokens = new CommonTokenStream(lexer);
                CeylonParser parser = new CeylonParser(tokens);
                Tree.CompilationUnit cu = parser.compilationUnit();
                List<LexError> lexerErrors = lexer.getErrors();
                for (LexError le : lexerErrors) {
                    this.printError(le, le.getMessage(), "ceylon.lexer", map);
                }
                List<ParseError> parserErrors = parser.getErrors();
                for (ParseError pe : parserErrors) {
                    this.printError(pe, pe.getMessage(), "ceylon.parser", map);
                }
                if (this.options.get(Option.CEYLONCONTINUE) != null && !"module.ceylon".equals(sourceFile.getName()) && !"package.ceylon".equals(sourceFile.getName()) || lexerErrors.size() == 0 && parserErrors.size() == 0) {
                    String pkgName = this.getPackage(filename);
                    LazyPackage p = this.modelLoader.findOrCreateModulelessPackage(pkgName == null ? "" : pkgName);
                    phasedUnit = new CeylonPhasedUnit(file, srcDir, cu, p, moduleManager, moduleSourceMapper, this.ceylonContext, filename, map);
                    phasedUnit.setSuppressedWarnings(suppressedWarnings);
                    this.phasedUnits.addPhasedUnit(file, phasedUnit);
                    this.gen.setMap(map);
                    return this.gen.makeJCCompilationUnitPlaceholder(cu, filename, pkgName, phasedUnit);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JCTree.JCCompilationUnit result = this.make.TopLevel(com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null, com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make.Erroneous()));
        result.sourcefile = filename;
        return result;
    }

    @Override
    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> parseFiles(Iterable<JavaFileObject> fileObjects) {
        this.timer.startTask("parse");
        this.modelLoader.fixDefaultPackage();
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> trees = super.parseFiles(fileObjects);
        this.timer.startTask("loadCompiledModules");
        LinkedList<JCTree.JCCompilationUnit> moduleTrees = new LinkedList<JCTree.JCCompilationUnit>();
        trees = this.loadCompiledModules(trees, moduleTrees);
        this.modelLoader.cacheModulelessPackages();
        this.timer.endTask();
        return trees;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> loadCompiledModules(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> trees, LinkedList<JCTree.JCCompilationUnit> moduleTrees) {
        this.compilerDelegate.visitModules(this.phasedUnits);
        Modules modules = this.ceylonContext.getModules();
        for (PhasedUnit pu : this.phasedUnits.getPhasedUnits()) {
            Package pkg = pu.getPackage();
            this.loadModuleFromSource(pkg, modules, moduleTrees, trees);
        }
        for (JCTree.JCCompilationUnit cu : trees) {
            if (cu instanceof CeylonCompilationUnit) continue;
            String packageName = "";
            if (cu.pid != null) {
                packageName = TreeInfo.fullName(cu.pid).toString();
            }
            LazyPackage pkg = this.modelLoader.findOrCreateModulelessPackage(packageName);
            this.loadModuleFromSource(pkg, modules, moduleTrees, trees);
        }
        for (PhasedUnit phasedUnit : this.phasedUnits.getPhasedUnits()) {
            for (Tree.ModuleDescriptor modDescr : phasedUnit.getCompilationUnit().getModuleDescriptors()) {
                String name = phasedUnit.getPackage().getNameAsString();
                CeylonPhasedUnit cpu = (CeylonPhasedUnit)phasedUnit;
                CeylonFileObject cfo = (CeylonFileObject)cpu.getFileObject();
                this.moduleNamesToFileObjects.put(name, cfo);
            }
        }
        if (this.addModuleTrees) {
            for (JCTree.JCCompilationUnit moduleTree : moduleTrees) {
                trees = trees.append(moduleTree);
            }
        }
        return trees;
    }

    private void loadModuleFromSource(Package pkg, Modules modules, LinkedList<JCTree.JCCompilationUnit> moduleTrees, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> parsedTrees) {
        if (pkg.getModule() != null) {
            if (!this.addedDefaultModuleToClassPath && pkg.getModule().isDefaultModule()) {
                this.addedDefaultModuleToClassPath = true;
                this.ceylonEnter.addOutputModuleToClassPath(pkg.getModule());
            }
            return;
        }
        String pkgName = pkg.getQualifiedNameString();
        Module module = null;
        if (pkgName.isEmpty()) {
            module = modules.getDefaultModule();
        } else {
            for (Module m : this.modulesLoadedFromSource) {
                if (!JvmBackendUtil.isSubPackage(m.getNameAsString(), pkgName)) continue;
                module = m;
                break;
            }
            if (module == null) {
                module = this.loadModuleFromSource(pkgName, moduleTrees, parsedTrees);
            } else if (!module.isAvailable()) {
                this.loadModuleFromSource(pkgName, moduleTrees, parsedTrees);
            }
            if (module == null) {
                module = this.isBootstrap ? modules.getLanguageModule() : modules.getDefaultModule();
            }
        }
        pkg.setModule(module);
        if (!module.getPackages().contains(pkg)) {
            module.getPackages().add(pkg);
        }
        this.ceylonEnter.addOutputModuleToClassPath(module);
    }

    private Module loadModuleFromSource(String pkgName, LinkedList<JCTree.JCCompilationUnit> moduleTrees, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> parsedTrees) {
        JavaFileObject fileObject;
        if (pkgName.isEmpty()) {
            return null;
        }
        String moduleClassName = pkgName + ".module";
        try {
            if (this.options.get(Option.VERBOSE) != null) {
                this.log.printRawLines(Log.WriterKind.NOTICE, "[Trying to load source for module " + moduleClassName + "]");
            }
            fileObject = this.fileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, moduleClassName, JavaFileObject.Kind.SOURCE);
            if (this.options.get(Option.VERBOSE) != null) {
                this.log.printRawLines(Log.WriterKind.NOTICE, "[Got file object: " + fileObject + "]");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.loadModuleFromSource(this.getParentPackage(pkgName), moduleTrees, parsedTrees);
        }
        if (fileObject != null) {
            Module module;
            for (JCTree.JCCompilationUnit parsedTree : parsedTrees) {
                if (!parsedTree.sourcefile.equals(fileObject) || !(parsedTree instanceof CeylonCompilationUnit)) continue;
                PhasedUnit phasedUnit = ((CeylonCompilationUnit)parsedTree).phasedUnit;
                if (phasedUnit.getPackage().getModule() == null) {
                    for (Module mod : this.ceylonContext.getModules().getListOfModules()) {
                        if (mod.getUnit() != phasedUnit.getUnit()) continue;
                        Package pkg = phasedUnit.getPackage();
                        pkg.setModule(mod);
                        mod.getPackages().add(pkg);
                        this.modulesLoadedFromSource.add(mod);
                        break;
                    }
                }
                return phasedUnit.getPackage().getModule();
            }
            JCTree.JCCompilationUnit javaCompilationUnit = this.parse(fileObject);
            if (javaCompilationUnit instanceof CeylonCompilationUnit) {
                CeylonCompilationUnit ceylonCompilationUnit = (CeylonCompilationUnit)javaCompilationUnit;
                moduleTrees.add(ceylonCompilationUnit);
                module = ceylonCompilationUnit.phasedUnit.visitSrcModulePhase();
                ceylonCompilationUnit.phasedUnit.visitRemainingModulePhase();
                if (module != null) {
                    ceylonCompilationUnit.phasedUnit.getPackage().setModule(module);
                }
            } else {
                ModuleManager moduleManager = this.phasedUnits.getModuleManager();
                module = moduleManager.getOrCreateModule(Arrays.asList(pkgName.split("\\.")), "bogus");
            }
            if (module != null) {
                this.modulesLoadedFromSource.add(module);
                return module;
            }
        }
        return this.loadModuleFromSource(this.getParentPackage(pkgName), moduleTrees, parsedTrees);
    }

    private String getParentPackage(String pkgName) {
        int lastDot = pkgName.lastIndexOf(".");
        if (lastDot == -1) {
            return "";
        }
        return pkgName.substring(0, lastDot);
    }

    private File getSrcDir(File sourceFile) throws IOException {
        Iterable<? extends File> prefixes = ((JavacFileManager)this.fileManager).getLocation(StandardLocation.SOURCE_PATH);
        File srcDirFile = FileUtil.selectPath(prefixes, sourceFile.getPath());
        if (srcDirFile != null) {
            return srcDirFile;
        }
        throw new RuntimeException(sourceFile.getPath() + " is not in the current source path");
    }

    private String getPackage(JavaFileObject file) throws IOException {
        Iterable<? extends File> prefixes = ((JavacFileManager)this.fileManager).getLocation(StandardLocation.SOURCE_PATH);
        String filePath = file.toUri().getPath();
        filePath = new File(filePath).getCanonicalPath();
        int srcDirLength = 0;
        for (File file2 : prefixes) {
            String prefix = file2.getCanonicalPath();
            if (!filePath.startsWith(prefix) || prefix.length() <= srcDirLength) continue;
            srcDirLength = prefix.length();
        }
        if (srcDirLength > 0) {
            String string;
            String fullname = filePath.substring(srcDirLength);
            assert (fullname.endsWith(".ceylon"));
            fullname = fullname.substring(0, fullname.length() - ".ceylon".length());
            if ((fullname = fullname.replace(File.separator, ".")).startsWith(".")) {
                fullname = fullname.substring(1);
            }
            if (!(string = Convert.packagePart(fullname)).equals("")) {
                return string;
            }
        }
        return null;
    }

    private void printError(RecognitionError le, String message, String key, Position.LineMap map) {
        int pos = -1;
        if (le.getLine() > 0) {
            try {
                pos = map.getStartPosition(le.getLine()) + le.getCharacterInLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.error(pos, key, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Env<AttrContext> attribute(Env<AttrContext> env) {
        if (env.toplevel.sourcefile instanceof CeylonFileObject || this.isBootstrap) {
            try {
                this.sourceLanguage.push(SourceLanguage.Language.CEYLON);
                Env<AttrContext> env2 = super.attribute(env);
                return env2;
            }
            finally {
                this.sourceLanguage.pop();
            }
        }
        return super.attribute(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaFileObject genCode(Env<AttrContext> env, JCTree.JCClassDecl cdef) throws IOException {
        if (env.toplevel.sourcefile instanceof CeylonFileObject) {
            try {
                this.sourceLanguage.push(SourceLanguage.Language.CEYLON);
                JavaFileObject javaFileObject = this.genCodeUnlessError(env, cdef);
                return javaFileObject;
            }
            finally {
                this.sourceLanguage.pop();
            }
        }
        return super.genCode(env, cdef);
    }

    @Override
    protected boolean shouldStop(CompileStates.CompileState cs) {
        CompileStates.CompileState shouldStopPolicy = this.unrecoverableError() ? this.shouldStopPolicyIfError : this.shouldStopPolicyIfNoError;
        boolean result = shouldStopPolicy == null ? false : cs.isAfter(shouldStopPolicy);
        if (!result && super.shouldStop(cs)) {
            this.treatLikelyBugsAsErrors = true;
        }
        return result;
    }

    public boolean getTreatLikelyBugsAsErrors() {
        return this.treatLikelyBugsAsErrors;
    }

    private JavaFileObject genCodeUnlessError(Env<AttrContext> env, JCTree.JCClassDecl cdef) throws IOException {
        CeylonFileObject sourcefile = (CeylonFileObject)env.toplevel.sourcefile;
        try {
            if (((JavaCompiler)this).gen.genClass(env, cdef)) {
                String moduleName;
                CeylonFileObject moduleFileObject;
                String packageName = cdef.sym.packge().getQualifiedName().toString();
                Package pkg = this.modelLoader.findPackage(packageName);
                if (pkg == null) {
                    throw new RuntimeException("Failed to find package: " + packageName);
                }
                Module module = pkg.getModule();
                if (!module.isDefaultModule() && ((moduleFileObject = this.moduleNamesToFileObjects.get(moduleName = module.getNameAsString())) == null || moduleFileObject.hasError())) {
                    if (this.options.get(Option.VERBOSE) != null) {
                        this.log.printRawLines(Log.WriterKind.NOTICE, "[Not writing class " + cdef.sym.className() + " because its module has errors: " + moduleName + "]");
                    }
                    return null;
                }
                return this.writer.writeClass(cdef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow ex) {
            this.log.error(cdef.pos(), "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow ex) {
            this.log.error(cdef.pos(), "limit.string.overflow", ex.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(cdef.pos(), ex);
        }
        catch (AssertionError e) {
            throw new RuntimeException("Error generating bytecode for " + sourcefile.getName(), (Throwable)((Object)e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void desugar(Env<AttrContext> env, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results) {
        if (env.toplevel.sourcefile instanceof CeylonFileObject) {
            try {
                this.sourceLanguage.push(SourceLanguage.Language.CEYLON);
                super.desugar(env, results);
                return;
            }
            finally {
                this.sourceLanguage.pop();
            }
        }
        super.desugar(env, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flow(Env<AttrContext> env, Queue<Env<AttrContext>> results) {
        if (env.toplevel.sourcefile instanceof CeylonFileObject) {
            try {
                this.sourceLanguage.push(SourceLanguage.Language.CEYLON);
                super.flow(env, results);
                return;
            }
            finally {
                this.sourceLanguage.pop();
            }
        }
        super.flow(env, results);
    }

    @Override
    public void initProcessAnnotations(Iterable<? extends Processor> processors) {
        List<String> aptModules = this.options.getMulti(Option.CEYLONAPT);
        if (aptModules != null) {
            CeyloncFileManager dfm = (CeyloncFileManager)this.fileManager;
            RepositoryManager repositoryManager = dfm.getRepositoryManager();
            final HashSet<ModuleSpec> visited = new HashSet<ModuleSpec>();
            StatusPrinterAptProgressListener progressListener = null;
            if (this.sp != null) {
                progressListener = new StatusPrinterAptProgressListener(this.sp){

                    @Override
                    protected long getNumberOfModulesResolved() {
                        return visited.size();
                    }
                };
                this.sp.clearLine();
                this.sp.log("Starting APT resolving");
            }
            for (String aptModule : aptModules) {
                ModuleSpec moduleSpec = ModuleSpec.parse(aptModule, new ModuleSpec.Option[0]);
                this.addDependenciesToAptPath(repositoryManager, moduleSpec, visited, progressListener);
            }
            if (this.sp != null) {
                this.sp.clearLine();
                this.sp.log("Done APT resolving");
            }
            super.initProcessAnnotations(processors);
        }
    }

    private void addDependenciesToAptPath(RepositoryManager repositoryManager, ModuleSpec moduleSpec, Set<ModuleSpec> visited, StatusPrinterAptProgressListener progressListener) {
        if (!visited.add(moduleSpec)) {
            return;
        }
        String ns = ModuleUtil.getNamespaceFromUri(moduleSpec.getName());
        String name = ModuleUtil.getModuleNameFromUri(moduleSpec.getName());
        ArtifactContext context = new ArtifactContext(ns, name, moduleSpec.getVersion(), ".jar", ".car");
        if (progressListener != null) {
            progressListener.retrievingModuleArtifact(moduleSpec, context);
        }
        ArtifactResult result = repositoryManager.getArtifactResult(context);
        if (progressListener != null) {
            if (result == null) {
                progressListener.retrievingModuleArtifactFailed(moduleSpec, context);
            } else {
                progressListener.retrievingModuleArtifactSuccess(moduleSpec, result);
            }
        }
        this.ceylonEnter.addModuleToAptPath(moduleSpec, result);
        for (ArtifactResult dep : result.dependencies()) {
            if (JDKUtils.isJDKModule(dep.name()) || JDKUtils.isOracleJDKModule(dep.name()) || dep.moduleScope() == ModuleScope.TEST) continue;
            ModuleSpec depSpec = new ModuleSpec(dep.namespace(), dep.name(), dep.version());
            this.addDependenciesToAptPath(repositoryManager, depSpec, visited, progressListener);
        }
    }

    @Override
    public void complete(Symbol.ClassSymbol c) throws Symbol.CompletionFailure {
        try {
            this.sourceLanguage.push(SourceLanguage.Language.JAVA);
            super.complete(c);
        }
        catch (RunTwiceException e) {
            this.hadRunTwiceException = true;
            throw new Symbol.CompletionFailure((Symbol)c, e.getLocalizedMessage());
        }
        finally {
            this.sourceLanguage.pop();
        }
    }

    @Override
    public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue, Queue<JavaFileObject> results) {
        this.timer.startTask("Generate");
        super.generate(queue, results);
        this.timer.endTask();
    }

    @Override
    public void initRound(JavaCompiler prev) {
        super.initRound(prev);
        this.addModuleTrees = false;
        PhasedUnits oldPUs = ((LanguageCompiler)prev).phasedUnits;
        ModuleManager moduleManager = this.phasedUnits.getModuleManager();
        ModuleSourceMapper moduleSourceMapper = this.phasedUnits.getModuleSourceMapper();
        for (PhasedUnit pu : oldPUs.getPhasedUnits()) {
            if (pu instanceof CeylonPhasedUnit) {
                String pkgName;
                CeylonPhasedUnit cpu = (CeylonPhasedUnit)pu;
                try {
                    pkgName = this.getPackage(((CeylonPhasedUnit)pu).getFileObject());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                LazyPackage p = this.modelLoader.findOrCreateModulelessPackage(pkgName == null ? "" : pkgName);
                CeylonPhasedUnit newPu = new CeylonPhasedUnit(pu.getUnitFile(), pu.getSrcDir(), pu.getCompilationUnit(), p, moduleManager, moduleSourceMapper, this.ceylonContext, cpu.getFileObject(), cpu.getLineMap());
                this.phasedUnits.addPhasedUnit(pu.getUnitFile(), newPu);
                continue;
            }
            this.phasedUnits.addPhasedUnit(pu.getUnitFile(), pu);
        }
    }

    public void setAddModuleTrees(boolean addModuleTrees) {
        this.addModuleTrees = addModuleTrees;
    }

    public boolean isAddModuleTrees() {
        return this.addModuleTrees;
    }

    public boolean isHadRunTwiceException() {
        return this.hadRunTwiceException;
    }

    public Set<Module> getCompiledModules() {
        return this.modulesLoadedFromSource;
    }

    private static class RunTwiceException
    extends RuntimeException {
        public RunTwiceException(String string) {
            super(string);
        }
    }

    public static interface CompilerDelegate {
        public ModuleManager getModuleManager();

        public ModuleSourceMapper getModuleSourceMapper();

        public PhasedUnit getExternalSourcePhasedUnit(VirtualFile var1, VirtualFile var2);

        public void typeCheck(List<PhasedUnit> var1);

        public void visitModules(PhasedUnits var1);

        public void loadStandardModules(AbstractModelLoader var1);

        public void setupSourceFileObjects(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> var1, AbstractModelLoader var2);

        public void resolveModuleDependencies(PhasedUnits var1);

        public void loadPackageDescriptors(AbstractModelLoader var1);
    }
}

