/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;

public class RepositoryLister {
    private List<String> extensions;

    public RepositoryLister(List<String> extensions) {
        this.extensions = extensions;
    }

    public RepositoryLister() {
        this.extensions = Arrays.asList(".jar", ".car");
    }

    public void list(File path, Actions actions) {
        if (path.isDirectory()) {
            actions.enterDirectory(path);
            for (File f : path.listFiles()) {
                this.list(f, actions);
            }
            actions.exitDirectory(path);
        } else if (path.isFile()) {
            String fileName = path.getName();
            for (String extension : this.extensions) {
                if (!extension.equals(".*") && !fileName.endsWith(extension)) continue;
                actions.doWithFile(path);
                return;
            }
        }
    }

    public static abstract class Actions {
        public abstract void doWithFile(File var1);

        public void enterDirectory(File path) {
        }

        public void exitDirectory(File path) {
        }
    }
}

